/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.digitalmediaserver.cuelib.Error;
import org.digitalmediaserver.cuelib.FileData;
import org.digitalmediaserver.cuelib.LineOfInput;
import org.digitalmediaserver.cuelib.Message;
import org.digitalmediaserver.cuelib.TrackData;
import org.digitalmediaserver.cuelib.Warning;
import org.digitalmediaserver.cuelib.util.Utils;

public class CueSheet {
    private final Path file;
    private final List<Message> messages = new ArrayList<Message>();
    private final List<FileData> fileData = new ArrayList<FileData>();
    private String catalog = null;
    private String cdTextFile = null;
    private String performer = null;
    private String title = null;
    private String songwriter = null;
    private String comment = null;
    private int year = -1;
    private String discId = null;
    private String genre = null;
    private int totalDiscs = -1;
    private int discNumber = -1;

    public CueSheet() {
        this.file = null;
    }

    public CueSheet(Path file) {
        this.file = file;
    }

    public String getMetaData(MetaDataField metaDataField) throws IllegalArgumentException {
        switch (metaDataField) {
            case CATALOG: {
                return this.getCatalog() == null ? "" : this.getCatalog();
            }
            case CDTEXTFILE: {
                return this.getCdTextFile() == null ? "" : this.getCdTextFile();
            }
            case COMMENT: {
                return this.getComment() == null ? "" : this.getComment();
            }
            case DISCID: {
                return this.getDiscId() == null ? "" : this.getDiscId();
            }
            case DISCNUMBER: {
                return this.getDiscNumber() == -1 ? "" : "" + this.getDiscNumber();
            }
            case GENRE: {
                return this.getGenre() == null ? "" : this.getGenre();
            }
            case PERFORMER: 
            case ALBUMPERFORMER: {
                return this.getPerformer() == null ? "" : this.getPerformer();
            }
            case SONGWRITER: 
            case ALBUMSONGWRITER: {
                return this.getSongwriter() == null ? "" : this.getSongwriter();
            }
            case TITLE: 
            case ALBUMTITLE: {
                return this.getTitle() == null ? "" : this.getTitle();
            }
            case TOTALDISCS: {
                return this.getTotalDiscs() == -1 ? "" : "" + this.getTotalDiscs();
            }
            case YEAR: {
                return this.getYear() == -1 ? "" : "" + this.getYear();
            }
        }
        throw new IllegalArgumentException("Unsupported field: " + metaDataField.toString());
    }

    public void addError(LineOfInput lineOfInput, String message) {
        this.messages.add(new Error(lineOfInput, message));
    }

    public void addWarning(LineOfInput lineOfInput, String message) {
        this.messages.add(new Warning(lineOfInput, message));
    }

    public List<TrackData> getAllTrackData() {
        ArrayList<TrackData> allTrackData = new ArrayList<TrackData>();
        for (FileData fileDataElement : this.fileData) {
            allTrackData.addAll(fileDataElement.getTrackData());
        }
        return allTrackData;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getCdTextFile() {
        return this.cdTextFile;
    }

    public void setCdTextFile(String cdTextFile) {
        this.cdTextFile = cdTextFile;
    }

    public String getPerformer() {
        return this.performer;
    }

    public void setPerformer(String performer) {
        this.performer = performer;
    }

    public String getSongwriter() {
        return this.songwriter;
    }

    public void setSongwriter(String songwriter) {
        this.songwriter = songwriter;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Deprecated
    public String getDiscid() {
        return this.discId;
    }

    public String getDiscId() {
        return this.discId;
    }

    @Deprecated
    public void setDiscid(String discid) {
        this.discId = discid;
    }

    public void setDiscId(String discId) {
        this.discId = discId;
    }

    public String getGenre() {
        return this.genre;
    }

    public void setGenre(String genre) {
        this.genre = genre;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<FileData> getFileData() {
        return this.fileData;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public int getTotalDiscs() {
        return this.totalDiscs;
    }

    public void setTotalDiscs(int totalDiscs) {
        this.totalDiscs = totalDiscs;
    }

    public int getDiscNumber() {
        return this.discNumber;
    }

    public void setDiscNumber(int discNumber) {
        this.discNumber = discNumber;
    }

    public Path getFile() {
        return this.file;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CueSheet [").append("\n");
        boolean first = true;
        if (this.file != null) {
            sb.append("    file=").append('\"').append(this.file).append('\"');
            first = false;
        }
        if (!Utils.isBlank(this.title)) {
            first = Utils.appendSeparator(sb, first, "\n");
            sb.append("    title=").append(this.title);
        }
        if (!Utils.isBlank(this.performer)) {
            first = Utils.appendSeparator(sb, first, "\n");
            sb.append("    performer=").append(this.performer);
        }
        if (!Utils.isBlank(this.songwriter)) {
            first = Utils.appendSeparator(sb, first, "\n");
            sb.append("    songwriter=").append(this.songwriter);
        }
        if (this.year > 0) {
            first = Utils.appendSeparator(sb, first, "\n");
            sb.append("    year=").append(this.year);
        }
        if (!Utils.isBlank(this.genre)) {
            first = Utils.appendSeparator(sb, first, "\n");
            sb.append("    genre=").append(this.genre);
        }
        if (this.discNumber > 0) {
            first = Utils.appendSeparator(sb, first, "\n");
            sb.append("    discNumber=").append(this.discNumber);
        }
        if (this.totalDiscs > 0) {
            first = Utils.appendSeparator(sb, first, "\n");
            sb.append("    totalDiscs=").append(this.totalDiscs);
        }
        if (!Utils.isBlank(this.cdTextFile)) {
            first = Utils.appendSeparator(sb, first, "\n");
            sb.append("    cdTextFile=").append(this.cdTextFile);
        }
        if (!Utils.isBlank(this.discId)) {
            first = Utils.appendSeparator(sb, first, "\n");
            sb.append("    discId=").append(this.discId);
        }
        if (!Utils.isBlank(this.comment)) {
            first = Utils.appendSeparator(sb, first, "\n");
            sb.append("    comment=").append(this.comment);
        }
        if (!Utils.isBlank(this.catalog)) {
            first = Utils.appendSeparator(sb, first, "\n");
            sb.append("    catalog=").append(this.catalog);
        }
        if (!this.fileData.isEmpty()) {
            first = Utils.appendSeparator(sb, first, "\n");
            sb.append("    fileData=").append(Utils.collectionToString(this.fileData, 8));
        }
        if (!this.messages.isEmpty()) {
            first = Utils.appendSeparator(sb, first, "\n");
            sb.append("    messages=").append(Utils.collectionToString(this.messages, 8));
        }
        sb.append("\n]");
        return sb.toString();
    }

    public static enum MetaDataField {
        ALBUMPERFORMER,
        ALBUMSONGWRITER,
        ALBUMTITLE,
        CATALOG,
        CDTEXTFILE,
        COMMENT,
        DISCID,
        DISCNUMBER,
        GENRE,
        ISRCCODE,
        PERFORMER,
        SONGWRITER,
        TITLE,
        TOTALDISCS,
        TRACKNUMBER,
        TRACKPERFORMER,
        TRACKSONGWRITER,
        TRACKTITLE,
        YEAR;

    }
}

