/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib;

import java.util.Set;
import org.digitalmediaserver.cuelib.CueSheet;
import org.digitalmediaserver.cuelib.FileData;
import org.digitalmediaserver.cuelib.Index;
import org.digitalmediaserver.cuelib.Position;
import org.digitalmediaserver.cuelib.TrackData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CueSheetSerializer {
    private String indentationValue = "  ";
    private static final Logger LOGGER = LoggerFactory.getLogger(CueSheetSerializer.class);

    public CueSheetSerializer() {
    }

    public CueSheetSerializer(String indentationValue) {
        LOGGER.debug("Setting CueSheetSerializer indentation value to: '{}'", (Object)indentationValue);
        this.indentationValue = indentationValue;
    }

    public String serializeCueSheet(CueSheet cueSheet) {
        StringBuilder builder = new StringBuilder();
        this.serializeCueSheet(builder, cueSheet, "");
        return builder.toString();
    }

    protected void serializeCueSheet(StringBuilder builder, CueSheet cueSheet, String indentation) {
        LOGGER.debug("Serializing cue sheet to cue format.");
        CueSheetSerializer.addField(builder, "REM GENRE", indentation, cueSheet.getGenre());
        CueSheetSerializer.addField(builder, "REM DATE", indentation, cueSheet.getYear());
        CueSheetSerializer.addField(builder, "REM DISCID", indentation, cueSheet.getDiscId());
        CueSheetSerializer.addField(builder, "REM COMMENT", indentation, cueSheet.getComment());
        CueSheetSerializer.addField(builder, "CATALOG", indentation, cueSheet.getCatalog());
        CueSheetSerializer.addField(builder, "PERFORMER", indentation, cueSheet.getPerformer());
        CueSheetSerializer.addField(builder, "TITLE", indentation, cueSheet.getTitle());
        CueSheetSerializer.addField(builder, "SONGWRITER", indentation, cueSheet.getSongwriter());
        CueSheetSerializer.addField(builder, "CDTEXTFILE", indentation, cueSheet.getCdTextFile());
        for (FileData fileData : cueSheet.getFileData()) {
            this.serializeFileData(builder, fileData, indentation);
        }
    }

    protected void serializeFileData(StringBuilder builder, FileData fileData, String indentation) {
        builder.append(indentation).append("FILE");
        if (fileData.getFile() != null) {
            builder.append(' ').append(CueSheetSerializer.quoteIfNecessary(fileData.getFile()));
        }
        if (fileData.getFileType() != null) {
            builder.append(' ').append(CueSheetSerializer.quoteIfNecessary(fileData.getFileType()));
        }
        builder.append('\n');
        for (TrackData trackData : fileData.getTrackData()) {
            this.serializeTrackData(builder, trackData, indentation + this.getIndentationValue());
        }
    }

    protected void serializeTrackData(StringBuilder builder, TrackData trackData, String indentation) {
        builder.append(indentation).append("TRACK");
        if (trackData.getNumber() > -1) {
            builder.append(' ').append(String.format("%1$02d", trackData.getNumber()));
        }
        if (trackData.getDataType() != null) {
            builder.append(' ').append(CueSheetSerializer.quoteIfNecessary(trackData.getDataType()));
        }
        builder.append('\n');
        String childIndentation = indentation + this.getIndentationValue();
        CueSheetSerializer.addField(builder, "ISRC", childIndentation, trackData.getIsrcCode());
        CueSheetSerializer.addField(builder, "PERFORMER", childIndentation, trackData.getPerformer());
        CueSheetSerializer.addField(builder, "TITLE", childIndentation, trackData.getTitle());
        CueSheetSerializer.addField(builder, "SONGWRITER", childIndentation, trackData.getSongwriter());
        CueSheetSerializer.addField(builder, "PREGAP", childIndentation, trackData.getPregap());
        CueSheetSerializer.addField(builder, "POSTGAP", childIndentation, trackData.getPostgap());
        if (trackData.getFlags().size() > 0) {
            CueSheetSerializer.serializeFlags(builder, trackData.getFlags(), childIndentation);
        }
        for (Index index : trackData.getIndices()) {
            CueSheetSerializer.serializeIndex(builder, index, childIndentation);
        }
    }

    protected static void serializeFlags(StringBuilder builder, Set<String> flags, String indentation) {
        builder.append(indentation).append("FLAGS");
        for (String flag : flags) {
            builder.append(' ').append(CueSheetSerializer.quoteIfNecessary(flag));
        }
        builder.append('\n');
    }

    protected static void serializeIndex(StringBuilder builder, Index index, String indentation) {
        builder.append(indentation).append("INDEX");
        if (index.getNumber() > -1) {
            builder.append(' ').append(String.format("%1$02d", index.getNumber()));
        }
        if (index.getPosition() != null) {
            builder.append(' ').append(CueSheetSerializer.formatPosition(index.getPosition()));
        }
        builder.append('\n');
    }

    protected static String formatPosition(Position position) {
        return String.format("%1$02d:%2$02d:%3$02d", position.getMinutes(), position.getSeconds(), position.getFrames());
    }

    protected static void addField(StringBuilder cueBuilder, String command, String indentation, Position value) {
        if (value != null) {
            cueBuilder.append(indentation).append(command).append(' ').append(CueSheetSerializer.formatPosition(value)).append('\n');
        }
    }

    protected static void addField(StringBuilder cueBuilder, String command, String indentation, String value) {
        if (value != null) {
            cueBuilder.append(indentation).append(command).append(' ').append(CueSheetSerializer.quoteIfNecessary(value)).append('\n');
        }
    }

    protected static void addField(StringBuilder cueBuilder, String command, String indentation, int value) {
        if (value > -1) {
            cueBuilder.append(indentation).append(command).append(' ').append("" + value).append('\n');
        }
    }

    protected static String quoteIfNecessary(String input) {
        for (int index = 0; index < input.length(); ++index) {
            if (!Character.isWhitespace(input.charAt(index))) continue;
            return '\"' + input + '\"';
        }
        return input;
    }

    public String getIndentationValue() {
        return this.indentationValue;
    }

    public void setIndentationValue(String indentationValue) {
        this.indentationValue = indentationValue;
    }
}

