/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib;

import org.digitalmediaserver.cuelib.LineOfInput;
import org.digitalmediaserver.cuelib.Message;
import org.digitalmediaserver.cuelib.util.Utils;

public abstract class MessageImplementation
implements Message {
    private String input;
    private int lineNumber;
    private String message;
    private String type;

    public MessageImplementation(String type) {
        this.input = "";
        this.lineNumber = -1;
        this.message = "";
        this.type = type;
    }

    public MessageImplementation(String type, LineOfInput lineOfInput, String message) {
        this.input = lineOfInput.getInput();
        this.lineNumber = lineOfInput.getLineNumber();
        this.message = message;
        this.type = type;
    }

    public MessageImplementation(String type, String input, int lineNumber, String message) {
        this.input = input;
        this.lineNumber = lineNumber;
        this.message = message;
        this.type = type;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (!Utils.isBlank(this.type)) {
            sb.append(this.type);
            first = false;
        }
        if (this.lineNumber > -1) {
            first = Utils.appendSeparator(sb, first, " ");
            sb.append('(').append(String.format("%03d", this.lineNumber)).append(')');
        }
        if (!Utils.isBlank(this.message)) {
            first = Utils.appendSeparator(sb, first, " ");
            sb.append(this.message);
        }
        if (!Utils.isBlank(this.input)) {
            Utils.appendSeparator(sb, first, ": ");
            sb.append('\"').append(this.input).append('\"');
        }
        return sb.toString();
    }

    @Override
    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

