/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.digitalmediaserver.cuelib.CueSheet;
import org.digitalmediaserver.cuelib.FileData;
import org.digitalmediaserver.cuelib.Index;
import org.digitalmediaserver.cuelib.Position;
import org.digitalmediaserver.cuelib.util.Utils;

public class TrackData {
    private final List<Index> indices = new ArrayList<Index>();
    private final Set<String> flags = new TreeSet<String>();
    private int number = -1;
    private String dataType = null;
    private String isrcCode = null;
    private String performer = null;
    private String title = null;
    private Position pregap = null;
    private Position postgap = null;
    private String songwriter = null;
    private FileData parent;

    public TrackData(FileData parent) {
        this.parent = parent;
    }

    public TrackData(FileData parent, int number, String dataType) {
        this.parent = parent;
        this.number = number;
        this.dataType = dataType;
    }

    public String getMetaData(CueSheet.MetaDataField metaDataField) throws IllegalArgumentException {
        switch (metaDataField) {
            case ISRCCODE: {
                return this.getIsrcCode() == null ? "" : this.getIsrcCode();
            }
            case PERFORMER: {
                return this.getPerformer() == null ? this.getParent().getParent().getPerformer() : this.getPerformer();
            }
            case TRACKPERFORMER: {
                return this.getPerformer() == null ? "" : this.getPerformer();
            }
            case SONGWRITER: {
                return this.getSongwriter() == null ? this.getParent().getParent().getSongwriter() : this.getSongwriter();
            }
            case TRACKSONGWRITER: {
                return this.getSongwriter();
            }
            case TITLE: {
                return this.getTitle() == null ? this.getParent().getParent().getTitle() : this.getTitle();
            }
            case TRACKTITLE: {
                return this.getTitle();
            }
            case TRACKNUMBER: {
                return Integer.toString(this.getNumber());
            }
        }
        return this.getParent().getParent().getMetaData(metaDataField);
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getIsrcCode() {
        return this.isrcCode;
    }

    public void setIsrcCode(String isrcCode) {
        this.isrcCode = isrcCode;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public String getPerformer() {
        return this.performer;
    }

    public void setPerformer(String performer) {
        this.performer = performer;
    }

    public Position getPostgap() {
        return this.postgap;
    }

    public void setPostgap(Position postgap) {
        this.postgap = postgap;
    }

    public Position getPregap() {
        return this.pregap;
    }

    public void setPregap(Position pregap) {
        this.pregap = pregap;
    }

    public String getSongwriter() {
        return this.songwriter;
    }

    public void setSongwriter(String songwriter) {
        this.songwriter = songwriter;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Index getIndex(int number) {
        for (Index index : this.indices) {
            if (index.getNumber() != number) continue;
            return index;
        }
        return null;
    }

    public List<Index> getIndices() {
        return this.indices;
    }

    public Index getFirstIndex() {
        return this.indices.isEmpty() ? null : this.indices.get(0);
    }

    public Index getLastIndex() {
        return this.indices.isEmpty() ? null : this.indices.get(this.indices.size() - 1);
    }

    public Index getStartIndex() {
        if (this.indices.isEmpty()) {
            return null;
        }
        Index index0 = null;
        for (Index idx : this.indices) {
            if (idx.getNumber() == 1) {
                return idx;
            }
            if (idx.getNumber() != 0) continue;
            index0 = idx;
        }
        return index0;
    }

    public Set<String> getFlags() {
        return this.flags;
    }

    public FileData getParent() {
        return this.parent;
    }

    public void setParent(FileData parent) {
        this.parent = parent;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        if (!Utils.isBlank(this.dataType)) {
            sb.append("dataType=").append(this.dataType);
            first = false;
        }
        if (!Utils.isBlank(this.title)) {
            first = Utils.appendSeparator(sb, first);
            sb.append("title=").append(this.title);
        }
        if (!Utils.isBlank(this.performer)) {
            first = Utils.appendSeparator(sb, first);
            sb.append("performer=").append(this.performer);
        }
        if (!Utils.isBlank(this.songwriter)) {
            first = Utils.appendSeparator(sb, first);
            sb.append("songwriter=").append(this.songwriter);
        }
        if (this.number > 0) {
            first = Utils.appendSeparator(sb, first);
            sb.append("number=").append(this.number);
        }
        if (!Utils.isBlank(this.isrcCode)) {
            first = Utils.appendSeparator(sb, first);
            sb.append("isrcCode=").append(this.isrcCode);
        }
        if (this.pregap != null) {
            first = Utils.appendSeparator(sb, first);
            sb.append("pregap=").append(this.pregap);
        }
        if (this.postgap != null) {
            first = Utils.appendSeparator(sb, first);
            sb.append("postgap=").append(this.postgap);
        }
        if (!this.flags.isEmpty()) {
            first = Utils.appendSeparator(sb, first);
            sb.append("flags=").append(Utils.collectionToString(this.flags));
        }
        if (!this.indices.isEmpty()) {
            first = Utils.appendSeparator(sb, first);
            sb.append("indices=").append(Utils.collectionToString(this.indices));
        }
        sb.append("]");
        return sb.toString();
    }
}

