/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib.util;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;

public class Utils {
    private Utils() {
    }

    public static boolean isBlank(CharSequence cs) {
        if (cs == null) {
            return true;
        }
        int strLen = cs.length();
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean appendSeparator(StringBuilder sb, boolean first) {
        return Utils.appendSeparator(sb, first, ", ");
    }

    public static boolean appendSeparator(StringBuilder sb, boolean first, String separator) {
        if (!first && sb != null) {
            sb.append(separator);
        }
        return false;
    }

    public static String collectionToString(Collection<?> collection) {
        return Utils.collectionToString(collection, false, 0);
    }

    public static String collectionToString(Collection<?> collection, int indent) {
        return Utils.collectionToString(collection, true, indent);
    }

    public static String collectionToString(Collection<?> collection, boolean lines, int indent) {
        if (collection == null) {
            return "Null";
        }
        if (collection.isEmpty()) {
            return "{}";
        }
        if (collection.size() == 1) {
            return collection.iterator().next().toString();
        }
        StringBuilder sb = new StringBuilder();
        String indentStr = null;
        if (lines) {
            if (indent > 0) {
                for (int i = 0; i < indent; ++i) {
                    sb.append(' ');
                }
                indentStr = sb.toString();
                sb.setLength(0);
            } else {
                indentStr = "";
            }
        } else {
            sb.append('{');
        }
        boolean first = true;
        for (Object object : collection) {
            if (lines) {
                sb.append('\n').append(indentStr);
            } else {
                first = Utils.appendSeparator(sb, first);
            }
            sb.append(object);
        }
        if (!lines) {
            sb.append('}');
        }
        return sb.toString();
    }

    public static void readFully(InputStream inputStream, byte[] target) throws IOException {
        int read;
        if (inputStream == null) {
            return;
        }
        if (target == null) {
            throw new IllegalArgumentException("target cannot be null");
        }
        int length = target.length;
        for (int count = 0; count < length; count += read) {
            read = inputStream.read(target, count, length - count);
            if (read != -1) continue;
            throw new EOFException("InputStream ended prematurely");
        }
    }

    public static long skipOrThrow(InputStream inputStream, long n) throws IOException {
        if (inputStream == null || n < 1L) {
            return 0L;
        }
        long result = inputStream.skip(n);
        if (result < n) {
            throw new EOFException("InputStream ended prematurely");
        }
        return result;
    }

    public static int skipOrThrow(DataInput input, int n) throws IOException {
        if (input == null || n < 1) {
            return 0;
        }
        int result = input.skipBytes(n);
        if (result < n) {
            throw new EOFException("\"" + input + "\" ended prematurely");
        }
        return result;
    }
}

