/*
 * Decompiled with CFR 0.152.
 */
package s32x;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.stream.IntStream;
import omegadrive.Device;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.dict.Sh2Dict;
import s32x.savestate.Gs32xStateHandler;
import s32x.sh2.cache.Sh2Cache;
import s32x.sh2.device.DivUnit;
import s32x.sh2.device.DmaC;
import s32x.sh2.device.IntControl;
import s32x.sh2.device.SerialCommInterface;
import s32x.sh2.device.Sh2DeviceHelper;
import s32x.sh2.device.WatchdogTimer;
import s32x.util.Md32xRuntimeData;
import s32x.util.S32xUtil;

public class Sh2MMREG
implements Device {
    private static final Logger LOG = LogHelper.getLogger((String)Sh2MMREG.class.getSimpleName());
    public static final int SH2_REG_SIZE = 512;
    public static final int SH2_REG_MASK = 511;
    private Sh2MMREGContext ctx;
    private final ByteBuffer regs;
    private SerialCommInterface sci;
    private DivUnit divUnit;
    private DmaC dmaC;
    public IntControl intC;
    private WatchdogTimer wdt;
    private final Sh2Cache cache;
    private final S32xUtil.CpuDeviceAccess cpu;
    private int ticksPerFrame;
    private int sh2TicksPerFrame;
    private static final boolean verbose = false;

    public Sh2MMREG(S32xUtil.CpuDeviceAccess cpu, Sh2Cache sh2Cache) {
        this.cpu = cpu;
        this.cache = sh2Cache;
        this.ctx = new Sh2MMREGContext();
        this.regs = ByteBuffer.allocate(512).put(this.ctx.regsByte);
        Gs32xStateHandler.addDevice(this);
    }

    public void init(Sh2DeviceHelper.Sh2DeviceContext ctx) {
        this.dmaC = ctx.dmaC;
        this.divUnit = ctx.divUnit;
        this.sci = ctx.sci;
        this.intC = ctx.intC;
        this.wdt = ctx.wdt;
        this.reset();
    }

    public void write(int reg, int value, Size size) {
        assert (Sh2Dict.checkName(reg));
        this.regWrite(reg, value, size);
    }

    private void regWrite(int reg, int value, Size size) {
        int pos = reg & 0x1FF;
        Sh2Dict.RegSpecSh2 regSpec = Sh2Dict.sh2RegMapping[pos];
        if (regSpec == null) {
            LOG.error("{} unknown reg write {}: {} {}", new Object[]{this.cpu, Util.th((int)reg), Util.th((int)value), size});
            this.tryWriteBuffer(reg, value, size);
            return;
        }
        switch (Sh2Dict.sh2RegDeviceMapping[pos]) {
            case DIV: {
                this.divUnit.write(regSpec, pos, value, size);
                break;
            }
            case DMA: {
                this.dmaC.write(regSpec, pos, value, size);
                break;
            }
            case SCI: {
                this.sci.write(regSpec, pos, value, size);
                break;
            }
            case INTC: {
                this.intC.write(regSpec, pos, value, size);
                break;
            }
            case WDT: {
                this.wdt.write(regSpec, pos, value, size);
                break;
            }
            case FRT: {
                this.handleWriteFRT(regSpec, pos, value, size);
                break;
            }
            case BSC: {
                this.handleWriteBSC(regSpec, pos, value, size);
                return;
            }
            default: {
                if (regSpec == Sh2Dict.RegSpecSh2.NONE_CCR) {
                    value = this.handleWriteCCR(regSpec, pos, value, size);
                }
                S32xUtil.writeBufferRaw(this.regs, pos, value, size);
            }
        }
    }

    public int readDramMode(int reg, Size size) {
        int res = this.ctx.dramModeRegs.getOrDefault(reg, -1);
        if (res < 0) {
            LOG.error("Unexpected dram mode reg read: {} {}", (Object)reg, (Object)size);
            res = 0;
        }
        return res;
    }

    public void writeDramMode(int reg, int value, Size size) {
        if (this.ctx.dramModeRegs.containsKey(reg)) {
            this.ctx.dramModeRegs.put(reg, value);
        } else {
            LOG.error("Unexpected dram mode reg write: {}, {} {}", new Object[]{reg, value, size});
        }
    }

    public int read(int reg, Size size) {
        assert (Sh2Dict.checkName(reg));
        int pos = reg & 0x1FF;
        Sh2Dict.RegSpecSh2 regSpec = Sh2Dict.sh2RegMapping[pos];
        int res = 0;
        if (regSpec != null) {
            switch (Sh2Dict.sh2RegDeviceMapping[reg & 0x1FF]) {
                case WDT: {
                    res = this.wdt.read(regSpec, pos, size);
                    break;
                }
                case SCI: {
                    res = this.sci.read(regSpec, pos, size);
                    break;
                }
                case DIV: {
                    res = this.divUnit.read(regSpec, pos, size);
                    break;
                }
                case FRT: {
                    res = S32xUtil.readBuffer(this.regs, pos, size);
                    if (regSpec == Sh2Dict.RegSpecSh2.FRT_TIER || regSpec == Sh2Dict.RegSpecSh2.FRT_TOCR) break;
                    LOG.error("{} Unexpected FRT reg {} read: {} {}", new Object[]{this.cpu, regSpec, Util.th((int)res), size});
                    break;
                }
                case BSC: {
                    assert (size != Size.BYTE);
                    res = S32xUtil.readBuffer(this.regs, pos, size);
                    break;
                }
                default: {
                    res = S32xUtil.readBuffer(this.regs, pos, size);
                }
            }
        }
        return res;
    }

    private void handleWriteBSC(Sh2Dict.RegSpecSh2 regSpec, int value, Size size) {
        this.handleWriteBSC(regSpec, regSpec.addr, value, size);
    }

    private void handleWriteBSC(Sh2Dict.RegSpecSh2 regSpec, int pos, int value, Size size) {
        assert (pos == regSpec.addr) : Util.th((int)pos) + ", " + Util.th((int)regSpec.addr);
        if (size != Size.LONG || (value & 0xFFFF0000) != -1520828416) {
            LOG.error("{} Invalid BSC reg {} write: {} {}", new Object[]{this.cpu, regSpec, Util.th((int)value), size});
            return;
        }
        value &= 0xFFFF;
        if (regSpec == Sh2Dict.RegSpecSh2.BSC_BCR1) {
            value |= (this.cpu.ordinal() & 1) << 15;
        }
        S32xUtil.writeRegBuffer(regSpec, this.regs, value, size);
    }

    private void handleWriteFRT(Sh2Dict.RegSpecSh2 r, int pos, int v, Size size) {
        assert (pos == r.addr) : Util.th((int)pos) + ", " + Util.th((int)r.addr);
        if (r == Sh2Dict.RegSpecSh2.FRT_TIER) {
            v = v & 0x8E | 1;
        } else if (r == Sh2Dict.RegSpecSh2.FRT_TOCR) {
            v |= 0xE0;
        }
        S32xUtil.writeBufferRaw(this.regs, r.addr & 0x1FF, v, size);
    }

    private int handleWriteCCR(Sh2Dict.RegSpecSh2 r, int pos, int v, Size size) {
        assert (size != Size.LONG);
        if (size == Size.WORD) {
            LOG.warn("{} {} word write @ {}, val: {}, setting CCR to {}", new Object[]{this.cpu, r, Util.th((int)pos), Util.th((int)v), Util.th((int)(v >>> 8))});
            v >>>= 8;
        }
        assert (pos == r.addr) : Util.th((int)pos) + ", " + Util.th((int)r.addr);
        int prev = Util.readBufferByte((ByteBuffer)this.regs, (int)r.addr);
        if (prev != v) {
            Sh2Cache.CacheRegContext ctx = this.cache.updateState(v);
            v = ctx.ccr;
        }
        return v;
    }

    public ByteBuffer getRegs() {
        return this.regs;
    }

    private void tryWriteBuffer(int reg, int value, Size size) {
        try {
            S32xUtil.writeBufferRaw(this.regs, reg & 0x1FF, value, size);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void newFrame() {
        this.sh2TicksPerFrame = 0;
        this.ticksPerFrame = 0;
    }

    public void saveContext(ByteBuffer buffer) {
        super.saveContext(buffer);
        this.regs.rewind().get(this.ctx.regsByte).rewind();
        buffer.put(Util.serializeObject((Serializable)this.ctx));
    }

    public void loadContext(ByteBuffer buffer) {
        super.loadContext(buffer);
        Serializable s = Util.deserializeObject((byte[])buffer.array(), (int)0, (int)buffer.capacity());
        assert (s instanceof Sh2MMREGContext);
        this.ctx = (Sh2MMREGContext)s;
        this.regs.rewind().put(this.ctx.regsByte).rewind();
    }

    public void reset() {
        IntStream.range(0, this.regs.capacity()).forEach(i -> this.regs.put(i, (byte)0));
        this.sci.reset();
        this.divUnit.reset();
        this.wdt.reset();
        this.dmaC.reset();
        this.intC.reset();
        S32xUtil.writeBufferRaw(this.regs, Sh2Dict.RegSpecSh2.FRT_TIER.addr, 1, Size.BYTE);
        S32xUtil.writeBufferRaw(this.regs, Sh2Dict.RegSpecSh2.FRT_TOCR.addr, 224, Size.BYTE);
        S32xUtil.writeBufferRaw(this.regs, Sh2Dict.RegSpecSh2.FRT_OCRAB_H.addr, 255, Size.BYTE);
        S32xUtil.writeBufferRaw(this.regs, Sh2Dict.RegSpecSh2.FRT_OCRAB_L.addr, 255, Size.BYTE);
        this.handleWriteBSC(Sh2Dict.RegSpecSh2.BSC_BCR1, -1520827408, Size.LONG);
        this.handleWriteBSC(Sh2Dict.RegSpecSh2.BSC_BCR2, -1520828164, Size.LONG);
        this.handleWriteBSC(Sh2Dict.RegSpecSh2.BSC_WCR, -1520784641, Size.LONG);
        this.write(Sh2Dict.RegSpecSh2.NONE_CCR.addr, 16, Size.BYTE);
    }

    public void deviceStepSh2Rate(int cycles) {
        assert (cycles == 3);
        Md32xRuntimeData.setAccessTypeExt(this.cpu);
        this.wdt.step(cycles);
        this.dmaC.step(cycles);
        Md32xRuntimeData.resetCpuDelayExt(this.cpu, 0);
    }

    public static class Sh2MMREGContext
    implements Serializable {
        public final byte[] regsByte = new byte[512];
        public final Map<Integer, Integer> dramModeRegs = Maps.newHashMap(Sh2Dict.dramModeRegsSpec);
    }
}

