/*
 * Decompiled with CFR 0.152.
 */
package s32x.pwm;

import com.google.common.primitives.Ints;
import java.io.Serializable;
import java.nio.ByteBuffer;
import omegadrive.sound.PwmProvider;
import omegadrive.util.Fifo;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.S32XMMREG;
import s32x.dict.S32xDict;
import s32x.pwm.PwmUtil;
import s32x.savestate.Gs32xStateHandler;
import s32x.sh2.device.DmaC;
import s32x.sh2.device.IntControl;
import s32x.util.S32xUtil;

public class Pwm
implements S32xUtil.StepDevice {
    private static final Logger LOG = LogHelper.getLogger((String)Pwm.class.getSimpleName());
    public static boolean PWM_USE_BLIP = false;
    private static final int PWM_DMA_CHANNEL = 1;
    private static final int chLeft = PwmChannel.LEFT.ordinal();
    private static final int chRight = PwmChannel.RIGHT.ordinal();
    private static final int PWM_FIFO_SIZE = 3;
    private static final int PWM_FIFO_FULL_BIT_POS = 15;
    private static final int PWM_FIFO_EMPTY_BIT_POS = 14;
    public static final int CYCLE_LIMIT = 400;
    public static final int CYCLE_22khz = 1042;
    public static final int SAMPLE_LIMIT_DELTA = 5;
    private static final PwmChannelSetup[] chanVals = PwmChannelSetup.values();
    private final ByteBuffer sysRegsMd;
    private final ByteBuffer sysRegsSh2;
    private IntControl[] intControls;
    private DmaC[] dmac;
    private PwmContext ctx;
    private int pwmSamplesPerFrame = 0;
    private int stepsPerFrame = 0;
    private int dreqPerFrame = 0;
    private static final boolean verbose = false;
    private PwmProvider playSupport = PwmProvider.NO_SOUND;
    private final PwmChannelMap fifoMapLeft = new PwmChannelMap();
    private final PwmChannelMap fifoMapRight = new PwmChannelMap();

    public Pwm(S32XMMREG.RegContext regContext) {
        this.sysRegsMd = regContext.sysRegsMd;
        this.sysRegsSh2 = regContext.sysRegsSh2;
        this.ctx = new PwmContext();
        Gs32xStateHandler.addDevice(this);
        this.init();
    }

    public int read(S32xUtil.CpuDeviceAccess cpu, S32xDict.RegSpecS32x regSpec, int address, Size size) {
        int res = S32xUtil.readBuffer(this.sysRegsMd, address, size);
        assert (res == S32xUtil.readBuffer(this.sysRegsSh2, address, size));
        return res;
    }

    public void write(S32xUtil.CpuDeviceAccess cpu, S32xDict.RegSpecS32x regSpec, int reg, int value, Size size) {
        switch (size) {
            case BYTE: {
                this.writeByte(cpu, regSpec, reg, value);
                break;
            }
            case WORD: {
                this.writeWord(cpu, regSpec, reg, value);
                break;
            }
            case LONG: {
                this.writeWord(cpu, regSpec, reg, value >> 16 & 0xFFFF);
                this.writeWord(cpu, S32xDict.getRegSpec(cpu, regSpec.addr + 2), reg + 2, value & 0xFFFF);
            }
        }
    }

    public void writeByte(S32xUtil.CpuDeviceAccess cpu, S32xDict.RegSpecS32x regSpec, int reg, int value) {
        switch (regSpec) {
            case PWM_CTRL: {
                this.handlePwmControl(cpu, reg, value, Size.BYTE);
                break;
            }
            case PWM_CYCLE: {
                assert (cpu.regSide == S32xUtil.S32xRegSide.MD) : regSpec;
                this.handlePartialByteWrite(reg, value);
                if (regSpec != S32xDict.RegSpecS32x.PWM_CYCLE) break;
                int val = Util.readBufferWord((ByteBuffer)this.sysRegsMd, (int)regSpec.addr);
                this.handlePwmCycleWord(cpu, val);
                break;
            }
            case PWM_RCH_PW: 
            case PWM_LCH_PW: 
            case PWM_MONO: {
                this.handlePartialByteWrite(reg, value);
                if ((reg & 1) != 1) break;
                int val = Util.readBufferWord((ByteBuffer)this.sysRegsMd, (int)regSpec.addr);
                this.writeWord(cpu, regSpec, regSpec.addr, val);
                this.updateFifoRegs();
                break;
            }
            default: {
                LOG.error("{} PWM write {} {}: {} {}", new Object[]{cpu, regSpec.getName(), Util.th((int)reg), Util.th((int)value), Size.BYTE});
            }
        }
    }

    private void handlePartialByteWrite(int reg, int value) {
        boolean even;
        boolean bl = even = (reg & 1) == 0;
        if (even) {
            S32xUtil.writeBuffers(this.sysRegsMd, this.sysRegsSh2, reg, value & 0xF, Size.BYTE);
            return;
        }
        S32xUtil.writeBuffers(this.sysRegsMd, this.sysRegsSh2, reg, value & 0xFF, Size.BYTE);
    }

    private void writeWord(S32xUtil.CpuDeviceAccess cpu, S32xDict.RegSpecS32x regSpec, int reg, int value) {
        switch (regSpec) {
            case PWM_CTRL: {
                this.handlePwmControl(cpu, reg, value, Size.WORD);
                break;
            }
            case PWM_CYCLE: {
                this.handlePwmCycleWord(cpu, value);
                break;
            }
            case PWM_MONO: {
                this.writeMono(value);
                break;
            }
            case PWM_LCH_PW: {
                this.writeFifo(this.ctx.fifoLeft, value);
                break;
            }
            case PWM_RCH_PW: {
                this.writeFifo(this.ctx.fifoRight, value);
                break;
            }
            default: {
                S32xUtil.writeBuffers(this.sysRegsMd, this.sysRegsSh2, regSpec.addr, value, Size.WORD);
            }
        }
    }

    private void handlePwmCycleWord(S32xUtil.CpuDeviceAccess cpu, int value) {
        S32xUtil.writeBuffers(this.sysRegsMd, this.sysRegsSh2, S32xDict.RegSpecS32x.PWM_CYCLE.addr, value &= 0xFFF, Size.WORD);
        int prevCycle = this.ctx.cycle;
        this.ctx.cycle = value - 1 & 0xFFF;
        if (this.ctx.cycle < 400) {
            LOG.warn("PWM cycle not supported: {}, limit: {}", (Object)this.ctx.cycle, (Object)400);
        }
        if (prevCycle != this.ctx.cycle) {
            this.handlePwmEnable(true);
        }
    }

    private void handlePwmControl(S32xUtil.CpuDeviceAccess cpu, int reg, int value, Size size) {
        switch (cpu.regSide) {
            case MD: {
                this.handlePwmControlMd(cpu, reg, value, size);
                break;
            }
            default: {
                this.handlePwmControlSh2(cpu, reg, value, size);
            }
        }
        this.handlePwmEnable(false);
    }

    private void handlePwmControlMd(S32xUtil.CpuDeviceAccess cpu, int reg, int value, Size size) {
        assert (size != Size.LONG);
        if (size == Size.BYTE && (reg & 1) == 0) {
            LOG.info("{} ignored write to {} {}, read only byte: val {} {}", new Object[]{cpu, S32xDict.RegSpecS32x.PWM_CTRL, Util.th((int)reg), Util.th((int)value), size});
            return;
        }
        int val = Util.readBufferWord((ByteBuffer)this.sysRegsMd, (int)S32xDict.RegSpecS32x.PWM_CTRL.addr) & 0xFFF0;
        S32xUtil.writeBuffers(this.sysRegsMd, this.sysRegsSh2, reg, val |= value & 0xF, size);
        value = Util.readBufferWord((ByteBuffer)this.sysRegsMd, (int)S32xDict.RegSpecS32x.PWM_CTRL.addr);
        this.ctx.channelMap[Pwm.chLeft] = chanVals[value & 3];
        this.ctx.channelMap[Pwm.chRight] = chanVals[value >> 2 & 3];
        this.updateChannelMap();
    }

    private void handlePwmControlSh2(S32xUtil.CpuDeviceAccess cpu, int reg, int val, Size size) {
        int mask;
        switch (size) {
            case WORD: {
                int n = 3983;
                break;
            }
            case BYTE: {
                int n;
                if ((reg & 1) == 1) {
                    n = 143;
                    break;
                }
                n = 15;
                break;
            }
            default: {
                int n = mask = 0;
            }
        }
        assert (size != Size.LONG);
        S32xUtil.writeBuffers(this.sysRegsMd, this.sysRegsSh2, reg, val & mask, size);
        int value = Util.readBufferWord((ByteBuffer)this.sysRegsMd, (int)S32xDict.RegSpecS32x.PWM_CTRL.addr);
        this.ctx.dreqEn = (value >> 7 & 1) > 0;
        int ival = value >> 8 & 0xF;
        this.ctx.interruptInterval = ival == 0 ? 16 : ival;
        this.ctx.channelMap[Pwm.chLeft] = chanVals[value & 3];
        this.ctx.channelMap[Pwm.chRight] = chanVals[value >> 2 & 3];
        this.updateChannelMap();
    }

    private void handlePwmEnable(boolean cycleChanged) {
        boolean wasEnabled = this.ctx.pwmEnable;
        boolean bl = this.ctx.pwmEnable = this.ctx.cycle > 0 && (this.ctx.channelMap[chLeft].isValid() || this.ctx.channelMap[chRight].isValid());
        if (!wasEnabled && this.ctx.pwmEnable || cycleChanged) {
            assert (this.ctx.interruptInterval > 0);
            this.ctx.sh2TicksToNextPwmSample = this.ctx.cycle;
            this.ctx.sh2ticksToNextPwmInterrupt = this.ctx.interruptInterval;
            this.ctx.latestPwmValue[0] = this.ctx.latestPwmValue[1] = this.ctx.cycle >> 1;
            this.resetFifo();
            this.updateFifoRegs();
            this.playSupport.updatePwmCycle(this.ctx.cycle);
            this.updateChannelMap();
        }
    }

    private void updateChannelMap() {
        switch (this.ctx.channelMap[chLeft]) {
            case SAME: {
                this.fifoMapLeft.fifo = this.ctx.fifoLeft;
                this.fifoMapLeft.channel = PwmChannel.LEFT;
                break;
            }
            case FLIP: {
                this.fifoMapLeft.fifo = this.ctx.fifoRight;
                this.fifoMapLeft.channel = PwmChannel.RIGHT;
                break;
            }
            default: {
                this.fifoMapLeft.fifo = PwmUtil.EMPTY_FIFO;
                this.fifoMapLeft.channel = null;
            }
        }
        switch (this.ctx.channelMap[chRight]) {
            case SAME: {
                this.fifoMapRight.fifo = this.ctx.fifoRight;
                this.fifoMapRight.channel = PwmChannel.RIGHT;
                break;
            }
            case FLIP: {
                this.fifoMapRight.fifo = this.ctx.fifoLeft;
                this.fifoMapRight.channel = PwmChannel.LEFT;
                break;
            }
            default: {
                this.fifoMapRight.fifo = PwmUtil.EMPTY_FIFO;
                this.fifoMapRight.channel = null;
            }
        }
    }

    private void resetFifo() {
        this.ctx.fifoRight.clear();
        this.ctx.fifoLeft.clear();
    }

    private void writeFifo(Fifo<Integer> fifo, int value) {
        if (!this.ctx.pwmEnable) {
            return;
        }
        if (fifo.isFull()) {
            fifo.pop();
            return;
        }
        value = Ints.constrainToRange((int)value, (int)5, (int)4090);
        assert (value >= 0);
        fifo.push((Object)Util.getFromIntegerCache((int)(value - 1 & 0xFFF)));
        this.updateFifoRegs();
    }

    private int readMono() {
        return this.readFifo(this.ctx.fifoLeft, PwmChannel.LEFT) + this.readFifo(this.ctx.fifoRight, PwmChannel.RIGHT) >> 1;
    }

    private int readFifo(Fifo<Integer> fifo, PwmChannel chan) {
        int res;
        if (fifo.isEmpty()) {
            return chan != null ? this.ctx.latestPwmValue[chan.ordinal()] : this.ctx.cycle >> 1;
        }
        this.ctx.latestPwmValue[chan.ordinal()] = res = ((Integer)fifo.pop()).intValue();
        this.updateFifoRegs();
        return res;
    }

    private void updateFifoRegs() {
        int regValue = this.ctx.fifoLeft.isFullBit() << 15 | this.ctx.fifoLeft.isEmptyBit() << 14;
        S32xUtil.writeBuffers(this.sysRegsMd, this.sysRegsSh2, S32xDict.RegSpecS32x.PWM_LCH_PW.addr, regValue, Size.WORD);
        regValue = this.ctx.fifoRight.isFullBit() << 15 | this.ctx.fifoRight.isEmptyBit() << 14;
        S32xUtil.writeBuffers(this.sysRegsMd, this.sysRegsSh2, S32xDict.RegSpecS32x.PWM_RCH_PW.addr, regValue, Size.WORD);
        this.updateMono();
    }

    private void updateMono() {
        int fifoFull = (this.ctx.fifoLeft.isFullBit() | this.ctx.fifoRight.isFullBit()) << 15;
        int fifoEmpty = (this.ctx.fifoLeft.isEmptyBit() & this.ctx.fifoRight.isEmptyBit()) << 14;
        int regValue = fifoFull | fifoEmpty;
        S32xUtil.writeBuffers(this.sysRegsMd, this.sysRegsSh2, S32xDict.RegSpecS32x.PWM_MONO.addr, regValue, Size.WORD);
    }

    public void writeMono(int value) {
        this.writeFifo(this.ctx.fifoLeft, value);
        this.writeFifo(this.ctx.fifoRight, value);
    }

    public void newFrame() {
        this.pwmSamplesPerFrame = 0;
        this.stepsPerFrame = 0;
        this.dreqPerFrame = 0;
        this.playSupport.newFrame();
    }

    @Override
    public void step(int cycles) {
        while (this.ctx.pwmEnable && cycles-- > 0) {
            this.stepOne();
        }
    }

    private void stepOne() {
        if (--this.ctx.sh2TicksToNextPwmSample == 0) {
            this.ctx.sh2TicksToNextPwmSample = this.ctx.cycle;
            ++this.pwmSamplesPerFrame;
            this.ctx.ls = Math.min(this.ctx.cycle - 5, this.readFifo(this.fifoMapLeft.fifo, this.fifoMapLeft.channel) + 5);
            this.ctx.rs = Math.min(this.ctx.cycle - 5, this.readFifo(this.fifoMapRight.fifo, this.fifoMapRight.channel) + 5);
            assert (this.ctx.ls >= 5 && this.ctx.rs >= 5);
            if (PWM_USE_BLIP) {
                this.playSupport.playSample(this.ctx.ls, this.ctx.rs);
            }
            if (--this.ctx.sh2ticksToNextPwmInterrupt == 0) {
                this.intControls[S32xUtil.CpuDeviceAccess.MASTER.ordinal()].setIntPending(IntControl.Sh2Interrupt.PWM_6, true);
                this.intControls[S32xUtil.CpuDeviceAccess.SLAVE.ordinal()].setIntPending(IntControl.Sh2Interrupt.PWM_6, true);
                this.ctx.sh2ticksToNextPwmInterrupt = this.ctx.interruptInterval;
                this.dreq();
            }
        }
        if (!PWM_USE_BLIP && --this.ctx.sh2TicksToNext22khzSample == 0) {
            this.playSupport.playSample(this.ctx.ls, this.ctx.rs);
            this.ctx.sh2TicksToNext22khzSample = 1042;
        }
    }

    private void dreq() {
        if (this.ctx.dreqEn) {
            this.dmac[S32xUtil.CpuDeviceAccess.MASTER.ordinal()].dmaReqTriggerPwm(1, true);
            this.dmac[S32xUtil.CpuDeviceAccess.SLAVE.ordinal()].dmaReqTriggerPwm(1, true);
            ++this.dreqPerFrame;
        }
    }

    public void setIntControls(IntControl ... intControls) {
        this.intControls = intControls;
    }

    public void setDmac(DmaC ... dmac) {
        this.dmac = dmac;
    }

    public void setPwmProvider(PwmProvider p) {
        this.playSupport = p;
        this.playSupport.updatePwmCycle(this.ctx.cycle);
    }

    public void saveContext(ByteBuffer buffer) {
        S32xUtil.StepDevice.super.saveContext(buffer);
        buffer.put(Util.serializeObject((Serializable)this.ctx));
    }

    public void loadContext(ByteBuffer buffer) {
        S32xUtil.StepDevice.super.loadContext(buffer);
        Serializable s = Util.deserializeObject((byte[])buffer.array(), (int)0, (int)buffer.capacity());
        assert (s instanceof PwmContext);
        this.ctx = (PwmContext)s;
        this.updateChannelMap();
    }

    public void init() {
        S32xUtil.writeBuffers(this.sysRegsMd, this.sysRegsSh2, S32xDict.RegSpecS32x.PWM_LCH_PW.addr, 16384, Size.WORD);
        S32xUtil.writeBuffers(this.sysRegsMd, this.sysRegsSh2, S32xDict.RegSpecS32x.PWM_RCH_PW.addr, 16384, Size.WORD);
        S32xUtil.writeBuffers(this.sysRegsMd, this.sysRegsSh2, S32xDict.RegSpecS32x.PWM_MONO.addr, 16384, Size.WORD);
        this.handlePwmControlSh2(S32xUtil.CpuDeviceAccess.MASTER, S32xDict.RegSpecS32x.PWM_CTRL.addr, 0, Size.WORD);
    }

    public void reset() {
        this.init();
        this.playSupport.reset();
        LOG.info("PWM reset done");
    }

    static class PwmChannelMap {
        public Fifo<Integer> fifo;
        public PwmChannel channel;

        PwmChannelMap() {
        }
    }

    static class PwmContext
    implements Serializable {
        private final Fifo<Integer> fifoLeft = Fifo.createIntegerFixedSizeFifo((int)3);
        private final Fifo<Integer> fifoRight = Fifo.createIntegerFixedSizeFifo((int)3);
        private final PwmChannelSetup[] channelMap = new PwmChannelSetup[]{PwmChannelSetup.OFF, PwmChannelSetup.OFF};
        private boolean pwmEnable;
        private boolean dreqEn;
        private int cycle = 0;
        private int interruptInterval;
        private int sh2TicksToNextPwmSample;
        private int sh2ticksToNextPwmInterrupt;
        private int sh2TicksToNext22khzSample = 1042;
        private int rs;
        private int ls;
        private final int[] latestPwmValue = new int[PwmChannel.values().length];

        PwmContext() {
        }
    }

    static enum PwmChannelSetup {
        OFF,
        SAME,
        FLIP,
        INVALID;


        public boolean isValid() {
            return this == SAME || this == FLIP;
        }
    }

    static enum PwmChannel {
        LEFT,
        RIGHT;

    }
}

