/*
 * Decompiled with CFR 0.152.
 */
package s32x.pwm;

import omegadrive.sound.PwmProvider;
import omegadrive.sound.SoundDevice;
import omegadrive.sound.fm.GenericAudioProvider;
import omegadrive.util.LogHelper;
import omegadrive.util.RegionDetector;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.pwm.PwmUtil;
import s32x.util.blipbuffer.BlipBufferHelper;

public class S32xPwmProvider
extends GenericAudioProvider
implements PwmProvider {
    private static final Logger LOG = LogHelper.getLogger((String)S32xPwmProvider.class.getSimpleName());
    private static final boolean collectStats = Boolean.parseBoolean(System.getProperty("helios.32x.pwm.stats", "false"));
    private final float sh2ClockMhz;
    private float scale = 0.0f;
    private int cycle;
    private final int fps;
    private boolean shouldPlay;
    private PwmUtil.Warmup warmup = PwmUtil.NO_WARMUP;
    private PwmUtil.PwmStats stats = PwmUtil.PwmStats.NO_STATS;
    int[] preFilter = new int[0];
    int[] prev = new int[2];

    public S32xPwmProvider(RegionDetector.Region region) {
        super(PwmUtil.pwmAudioFormat);
        this.fps = region.getFps();
        float f = this.sh2ClockMhz = region == RegionDetector.Region.EUROPE ? 2.2801468E7f : 2.301136E7f;
        if (collectStats) {
            this.stats = new PwmUtil.PwmStats();
        }
    }

    public void updatePwmCycle(int cycle) {
        float c = cycle;
        int pwmSamplesPerFrame = (int)(this.sh2ClockMhz / (float)(this.fps * cycle));
        this.scale = 65534.0f / c;
        this.shouldPlay = cycle >= 400;
        this.cycle = cycle;
        this.start();
        if (!this.shouldPlay) {
            LOG.error("Unsupported cycle setting: {}, limit: {}, pwmSamplesPerFrame: {}", new Object[]{cycle, 400, pwmSamplesPerFrame});
            this.stop();
        } else {
            LOG.info("PWM cycle setting: {}, limit: {}, pwmSamplesPerFrame: {}", new Object[]{cycle, 400, pwmSamplesPerFrame});
            this.warmup = PwmUtil.WARMUP;
            this.warmup.reset();
            this.warmup.isWarmup = true;
            LOG.info("PWM warmup start");
        }
    }

    public void playSample(int left, int right) {
        int len;
        if (!this.shouldPlay) {
            return;
        }
        int vleft = (int)((float)(left - (this.cycle >> 1)) * this.scale);
        int vright = (int)((float)(right - (this.cycle >> 1)) * this.scale);
        short sleft = (short)vleft;
        short sright = (short)vright;
        if (sleft != vleft || sright != vright) {
            float sc = this.scale;
            this.scale -= 1.0f;
            LOG.warn("PWM value out of range (16 bit signed), L/R: {}/{}, scale: {}, pwmVal: {}/{}", new Object[]{Util.th((int)sleft), Util.th((int)sright), Float.valueOf(sc), left, right});
            LOG.warn("Reducing scale: {} -> {}", (Object)Float.valueOf(sc), (Object)Float.valueOf(this.scale));
            sleft = (short)BlipBufferHelper.clampToShort(vleft);
            sright = (short)BlipBufferHelper.clampToShort(vright);
        }
        if ((len = this.stereoQueueLen.get()) < 2000) {
            this.addStereoSample(sleft, sright);
            this.addStereoSample(sleft, sright);
            if (collectStats) {
                ++this.stats.monoSamplesPush;
            }
        } else if (len < 3000) {
            this.addStereoSample(sleft, sright);
            if (collectStats) {
                ++this.stats.monoSamplesDiscardHalf;
            }
        } else if (collectStats) {
            ++this.stats.monoSamplesDiscard;
        }
    }

    public int updateStereo16(int[] buf_lr, int offset, int countMono) {
        int stereoSamples = countMono << 1;
        if (countMono == 0 || !this.running) {
            return stereoSamples;
        }
        if (this.preFilter.length < buf_lr.length) {
            this.preFilter = (int[])buf_lr.clone();
        }
        int actualStereo = super.updateStereo16(this.preFilter, offset, countMono);
        if (collectStats) {
            this.stats.monoSamplesPull += actualStereo >> 1;
        }
        if (actualStereo == 0) {
            if (collectStats) {
                this.stats.monoSamplesFiller += stereoSamples >> 1;
            }
            for (int i = 0; i < stereoSamples; i += 2) {
                buf_lr[i] = this.prev[0];
                buf_lr[i + 1] = this.prev[1];
            }
            return stereoSamples;
        }
        if (actualStereo < stereoSamples) {
            for (int i = actualStereo; i < stereoSamples; i += 2) {
                this.preFilter[i] = this.preFilter[actualStereo - 2];
                this.preFilter[i + 1] = this.preFilter[actualStereo - 1];
            }
            if (collectStats) {
                this.stats.monoSamplesFiller += stereoSamples - actualStereo >> 1;
            }
        }
        PwmUtil.dcBlockerLpf(this.preFilter, buf_lr, this.prev, stereoSamples);
        this.warmup.doWarmup(buf_lr, stereoSamples);
        return stereoSamples;
    }

    public void newFrame() {
        int monoLen = this.stereoQueueLen.get() >> 1;
        if (collectStats) {
            this.stats.print(monoLen);
            this.stats.reset();
        }
        if (monoLen > 5000) {
            LOG.warn("Pwm monoQLen: {}", (Object)monoLen);
            this.sampleQueue.clear();
            this.stereoQueueLen.set(0);
        }
    }

    public SoundDevice.SoundDeviceType getType() {
        return SoundDevice.SoundDeviceType.PWM;
    }

    public void reset() {
        this.shouldPlay = false;
        PwmUtil.WARMUP.reset();
        super.reset();
    }
}

