/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2.device;

import java.nio.ByteBuffer;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.dict.Sh2Dict;
import s32x.sh2.device.IntControl;
import s32x.sh2.device.Sh2DeviceHelper;
import s32x.util.S32xUtil;

public class SerialCommInterface
implements S32xUtil.Sh2Device {
    private static final Logger LOG = LogHelper.getLogger((String)SerialCommInterface.class.getSimpleName());
    private static final int SCI_SSR_TDRE_BIT_POS = 7;
    private static final int SCI_SSR_TEND_BIT_POS = 2;
    private static final int SCI_SSR_RDRF_BIT_POS = 6;
    public static final int TIE = 0;
    public static final int RIE = 1;
    private static final boolean verbose = false;
    private final ByteBuffer regs;
    private final S32xUtil.CpuDeviceAccess cpu;
    private final IntControl intControl;
    private int tdre;
    private int rdrf;
    private boolean txEn;
    private boolean rxEn;
    private SerialCommInterface other;
    public static final SciData sciData = new SciData();

    public SerialCommInterface(S32xUtil.CpuDeviceAccess cpu, IntControl intControl, ByteBuffer regs) {
        this.cpu = cpu;
        this.regs = regs;
        this.intControl = intControl;
        this.reset();
    }

    public void setOther(SerialCommInterface other) {
        this.other = other;
        other.other = this;
        assert (other.cpu != this.cpu);
    }

    @Override
    public int read(Sh2Dict.RegSpecSh2 regSpec, int pos, Size size) {
        if (size != Size.BYTE) {
            LOG.error("{} SCI read {}: {}", new Object[]{this.cpu, regSpec.getName(), size});
        }
        assert (pos == regSpec.addr) : Util.th((int)pos) + ", " + Util.th((int)regSpec.addr);
        int res = Util.readBufferByte((ByteBuffer)this.regs, (int)regSpec.addr);
        return res;
    }

    @Override
    public void write(Sh2Dict.RegSpecSh2 regSpec, int pos, int value, Size size) {
        if (size != Size.BYTE) {
            LOG.error("{} SCI write {}: {} {}", new Object[]{this.cpu, regSpec.getName(), Util.th((int)value), size});
        }
        boolean write = true;
        assert (pos == regSpec.addr) : Util.th((int)pos) + ", " + Util.th((int)regSpec.addr);
        switch (regSpec) {
            case SCI_SCR: {
                boolean prevTxEn = this.txEn;
                this.rxEn = (value & 0x10) > 0;
                boolean bl = this.txEn = (value & 0x20) > 0;
                if (prevTxEn && !this.txEn) {
                    this.setTdre(1);
                    break;
                }
                if (!this.txEn || prevTxEn) break;
                this.step(1);
                break;
            }
            case SCI_SSR: {
                this.handleSsrWrite(value);
                write = false;
                break;
            }
            case SCI_SMR: {
                break;
            }
            case SCI_TDR: {
                this.setTdre(1);
                break;
            }
            case SCI_RDR: {
                LOG.warn("{} {} Data written RDR: {}", new Object[]{this.cpu, regSpec.getName(), Util.th((int)value)});
                write = true;
            }
        }
        if (write) {
            S32xUtil.writeBufferRaw(this.regs, pos, value, size);
        }
    }

    private void handleSsrWrite(int value) {
        int wasTdre = this.tdre;
        int tdreVal = (value & 0x80) > 0 || !this.txEn ? this.tdre : 0;
        this.setTdre(tdreVal);
        if (wasTdre > 0 && (value & 0x80) == 0) {
            S32xUtil.setBit(this.regs, Sh2Dict.RegSpecSh2.SCI_SSR.addr, 2, 0, Size.BYTE);
            this.step(1);
        }
        int rdrfVal = (value & 0x40) == 0 ? 0 : this.rdrf;
        this.setRdrf(rdrfVal);
        for (int i = 3; i < 6; ++i) {
            if ((value & 1 << i) != 0) continue;
            S32xUtil.setBit(this.regs, Sh2Dict.RegSpecSh2.SCI_SSR.addr, i, 0, Size.BYTE);
        }
        S32xUtil.setBit(this.regs, Sh2Dict.RegSpecSh2.SCI_SSR.addr, 0, value & 1, Size.BYTE);
    }

    @Override
    public void step(int cycles) {
        if (this.txEn && this.tdre == 0) {
            int data = Util.readBufferByte((ByteBuffer)this.regs, (int)Sh2Dict.RegSpecSh2.SCI_TDR.addr);
            int scr = Util.readBufferByte((ByteBuffer)this.regs, (int)Sh2Dict.RegSpecSh2.SCI_SCR.addr);
            this.setTdre(1);
            S32xUtil.setBit(this.regs, Sh2Dict.RegSpecSh2.SCI_SSR.addr, 2, 1, Size.BYTE);
            this.sendData(data);
            if ((scr & 0x80) > 0) {
                this.intControl.setOnChipDeviceIntPending(Sh2DeviceHelper.Sh2DeviceType.SCI, IntControl.OnChipSubType.TXI);
            }
            this.other.step(1);
            return;
        }
        if (this.rxEn && SerialCommInterface.sciData.isDataInTransit && SerialCommInterface.sciData.sender != this.cpu) {
            S32xUtil.writeBufferRaw(this.regs, Sh2Dict.RegSpecSh2.SCI_RDR.addr, SerialCommInterface.sciData.dataInTransit, Size.BYTE);
            this.setRdrf(1);
            int scr = Util.readBufferByte((ByteBuffer)this.regs, (int)Sh2Dict.RegSpecSh2.SCI_SCR.addr);
            SerialCommInterface.sciData.isDataInTransit = false;
            if ((scr & 0x40) > 0) {
                this.intControl.setOnChipDeviceIntPending(Sh2DeviceHelper.Sh2DeviceType.SCI, IntControl.OnChipSubType.RXI);
            }
        }
    }

    private void setTdre(int value) {
        S32xUtil.setBit(this.regs, Sh2Dict.RegSpecSh2.SCI_SSR.addr, 7, value, Size.BYTE);
        this.tdre = value;
    }

    private void setRdrf(int value) {
        S32xUtil.setBit(this.regs, Sh2Dict.RegSpecSh2.SCI_SSR.addr, 6, value, Size.BYTE);
        this.rdrf = value;
    }

    private void sendData(int data) {
        SerialCommInterface.sciData.sender = this.cpu;
        SerialCommInterface.sciData.dataInTransit = data;
        SerialCommInterface.sciData.isDataInTransit = true;
    }

    public void reset() {
        S32xUtil.writeBufferRaw(this.regs, Sh2Dict.RegSpecSh2.SCI_SMR.addr, 0, Size.BYTE);
        S32xUtil.writeBufferRaw(this.regs, Sh2Dict.RegSpecSh2.SCI_BRR.addr, 255, Size.BYTE);
        S32xUtil.writeBufferRaw(this.regs, Sh2Dict.RegSpecSh2.SCI_SCR.addr, 0, Size.BYTE);
        S32xUtil.writeBufferRaw(this.regs, Sh2Dict.RegSpecSh2.SCI_TDR.addr, 255, Size.BYTE);
        S32xUtil.writeBufferRaw(this.regs, Sh2Dict.RegSpecSh2.SCI_SSR.addr, 132, Size.BYTE);
        S32xUtil.writeBufferRaw(this.regs, Sh2Dict.RegSpecSh2.SCI_RDR.addr, 0, Size.BYTE);
        this.tdre = 1;
        this.rdrf = 0;
        this.rxEn = false;
        this.txEn = false;
    }

    static class SciData {
        public S32xUtil.CpuDeviceAccess sender;
        public int dataInTransit;
        public boolean isDataInTransit;

        SciData() {
        }
    }
}

