/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2.drc;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Predicate;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import s32x.dict.S32xDict;
import s32x.event.PollSysEventManager;
import s32x.sh2.Sh2Context;
import s32x.sh2.Sh2Debug;
import s32x.sh2.Sh2Helper;
import s32x.sh2.Sh2Impl;
import s32x.sh2.drc.Sh2Block;
import s32x.util.Md32xRuntimeData;
import s32x.util.S32xUtil;

public class Ow2DrcOptimizer {
    private static final Logger LOG = LogHelper.getLogger((String)Ow2DrcOptimizer.class.getSimpleName());
    public static final boolean ENABLE_POLL_DETECT = true;
    private static final boolean LOG_POLL_DETECT = false;
    private static final boolean LOG_POLL_DETECT_UNSUPPORTED = false;
    public static final int POLLER_ACTIVATE_LIMIT = 3;
    private static final boolean verbose = false;
    public static final Map<S32xDict.S32xRegType, PollType> ptMap = ImmutableMap.of((Object)((Object)S32xDict.S32xRegType.DMA), (Object)((Object)PollType.DMA), (Object)((Object)S32xDict.S32xRegType.PWM), (Object)((Object)PollType.PWM), (Object)((Object)S32xDict.S32xRegType.VDP), (Object)((Object)PollType.VDP), (Object)((Object)S32xDict.S32xRegType.SYS), (Object)((Object)PollType.SYS), (Object)((Object)S32xDict.S32xRegType.NONE), (Object)((Object)PollType.NONE), (Object)((Object)S32xDict.S32xRegType.COMM), (Object)((Object)PollType.COMM));
    private static final Predicate<Integer> isCmpTstOpcode = Sh2Debug.isTstOpcode.or(Sh2Debug.isCmpOpcode);
    public static final Predicate<Integer> isTasOpcode = op -> (op & 0xF0FF) == 16411;
    public static final Predicate<Integer> isMovtOpcode = op -> (op & 0xF0FF) == 41;
    public static final Predicate<Integer> isMemLoadOpcode = op -> Sh2Debug.isMovOpcode.or(isTasOpcode).test((Integer)op);
    private static final Predicate<Integer> isMoviOpcode = w -> (w & 0xF000) == 57344;
    private static final Predicate<Integer> isShiftOpcode = w -> (w & 0xF0FF) == 16409;
    private static final Predicate<Integer> isFlagOpcode = op -> (op & 0xF0FF) == 16385;
    private static final Predicate<Integer> isSwapOpcode = w -> (w & 0xF00F) == 24584 || (w & 0xF00F) == 24585;
    private static final Predicate<Integer> isXorOpcode = w -> (w & 0xF00F) == 8202;
    private static final Predicate<Integer> isExtOpcode = w -> (w & 0xF00F) == 24588 || (w & 0xF00F) == 24589 || (w & 0xF00F) == 24590 || (w & 0xF00F) == 24591;
    private static final Predicate<Integer> isAndOrOpcode = w -> (w & 0xF00F) == 8201 || (w & 0xFF00) == 51456 || (w & 0xFF00) == 51968;
    public static final Predicate<Integer> isMovR2ROpcode = w -> (w & 0xF00F) == 24579;
    public static final Predicate<Integer> isRegOnlyOpcode = isAndOrOpcode.or(isExtOpcode).or(isSwapOpcode).or(isMovR2ROpcode).or(isMoviOpcode).or(isMovtOpcode).or(isShiftOpcode).or(isXorOpcode);
    private static final Predicate<Integer> isDtOpcode = op -> (op & 0xF0FF) == 16400;
    public static final PollerCtx NO_POLLER = new PollerCtx();
    public static final PollerCtx UNKNOWN_POLLER = new PollerCtx();
    static Predicate<Integer> isMoviuExtu = op -> isMoviOpcode.test(op >> 16) && isExtOpcode.test(op & 0xFFFF) && (op >> 24 & 0xF) == (op >> 4 & 0xF) && (op >> 8 & 0xF) == (op >> 4 & 0xF);

    public static void pollDetector(Sh2Block block) {
        Sh2Helper.Sh2PcInfoWrapper piw = Sh2Helper.get(block.prefetchPc, block.drcContext.cpu);
        if (piw.block.poller != UNKNOWN_POLLER) {
            PollerCtx ctx = piw.block.poller;
            Sh2Block prevBlock = piw.block;
            assert (block.isValid() && ctx != UNKNOWN_POLLER && (prevBlock == Sh2Block.INVALID_BLOCK || prevBlock == block) && ctx.cpu == block.drcContext.cpu) : "Poller: " + ctx + "\nPiwBlock: " + piw.block + "\nPrevPoll: " + prevBlock + "\nNewPoll : " + block;
            return;
        }
        assert (piw.block == block) : "PiwBlock: " + piw.block + "\nBlock: " + block + "\n" + block.drcContext.cpu + "," + Util.th((int)block.prefetchPc) + "," + Util.th((int)block.hashCodeWords);
        if (block.pollType == PollType.UNKNOWN) {
            PollerCtx ctx = PollerCtx.create(piw);
            ctx.blockPollData.init();
            piw.block.poller = Ow2DrcOptimizer.addPollMaybe(ctx, block);
        }
        if (block.pollType == PollType.UNKNOWN) {
            block.pollType = PollType.NONE;
        }
    }

    public static int getBranchDestination(int jmpOpcode, int jmpPc) {
        int branchDest = 0;
        if ((jmpOpcode & 0xF000) == 32768) {
            int d = (byte)(jmpOpcode & 0xFF) << 1;
            branchDest = jmpPc + d + 4;
        } else if ((jmpOpcode & 0xF000) == 40960) {
            int disp = (jmpOpcode & 0x800) == 0 ? 0xFFF & jmpOpcode : 0xFFFFF000 | jmpOpcode;
            branchDest = jmpPc + 4 + (disp << 1);
        }
        return branchDest;
    }

    public static void parseMemLoad(BlockPollData bpd) {
        Ow2DrcOptimizer.parseMemLoad(bpd, bpd.ctx, bpd.memLoadOpcode);
    }

    private static void parseMemLoad(BlockPollData bpd, Sh2Context sh2Context, int memReadOpcode) {
        int[] r = sh2Context.registers;
        if ((memReadOpcode & 0xF000) == 20480) {
            bpd.memLoadTarget = ((memReadOpcode & 0xF) << 2) + r[Sh2Impl.RM(memReadOpcode)];
            bpd.memLoadTargetSize = Size.LONG;
        } else if ((memReadOpcode & 0xF000) == 49152 && ((memReadOpcode >> 8 & 0xF) == 4 || (memReadOpcode >> 8 & 0xF) == 5 || (memReadOpcode >> 8 & 0xF) == 6)) {
            bpd.memLoadTargetSize = Size.vals[memReadOpcode >> 8 & 3];
            bpd.memLoadTarget = ((memReadOpcode & 0xFF) << bpd.memLoadTargetSize.ordinal()) + sh2Context.GBR;
        } else if ((memReadOpcode & 0xF000) == 24576 && (memReadOpcode & 0xF) < 3) {
            bpd.memLoadTarget = r[Sh2Impl.RM(memReadOpcode)];
            bpd.memLoadTargetSize = Size.vals[memReadOpcode & 0xF];
        } else if ((memReadOpcode & 0xF000) == 32768 && ((memReadOpcode & 0xF00) == 1024 || (memReadOpcode & 0xF00) == 1280)) {
            bpd.memLoadTargetSize = Size.vals[memReadOpcode >> 8 & 1];
            bpd.memLoadTarget = r[Sh2Impl.RM(memReadOpcode)] + ((memReadOpcode & 0xF) << bpd.memLoadTargetSize.ordinal());
        } else if ((memReadOpcode & 0xFF00) == 52224) {
            bpd.memLoadTarget = r[0] + sh2Context.GBR;
            bpd.memLoadTargetSize = Size.BYTE;
        } else if ((memReadOpcode & 0xF0FF) == 16411) {
            bpd.memLoadTarget = r[Sh2Impl.RN(memReadOpcode)];
            bpd.memLoadTargetSize = Size.BYTE;
        }
        if (bpd.memLoadTargetSize != null) {
            bpd.memLoadTargetEnd = bpd.memLoadTarget + (bpd.memLoadTargetSize.getByteSize() - 1);
        }
    }

    private static PollerCtx addPollMaybe(PollerCtx pctx, Sh2Block block) {
        boolean supported = false;
        boolean log = false;
        BlockPollData bpd = pctx.blockPollData;
        PollerCtx toSet = NO_POLLER;
        if (bpd.isPoller) {
            block.pollType = Ow2DrcOptimizer.getAccessType(bpd.memLoadTarget);
            log |= bpd.branchDestPc == bpd.pc;
            if (block.pollType != PollType.UNKNOWN) {
                pctx.event = PollSysEventManager.SysEvent.valueOf(block.pollType.name());
                log = true;
                if (block.pollType.supported) {
                    supported = true;
                    toSet = pctx;
                }
            }
            log |= bpd.memLoadTargetSize == null && block.pollType != PollType.UNKNOWN;
        } else if (bpd.isBusyLoop) {
            LOG.info("{} BusyLoop detected: {}\n{}", new Object[]{block.drcContext.cpu, Util.th((int)block.prefetchPc), Sh2Helper.toListOfInst(block)});
            block.pollType = PollType.BUSY_LOOP;
            pctx.event = PollSysEventManager.SysEvent.INT;
            toSet = pctx;
        }
        if (block.pollType == PollType.UNKNOWN) {
            block.pollType = PollType.NONE;
        }
        assert (block.pollType != PollType.UNKNOWN);
        assert (toSet != null);
        return toSet;
    }

    private static void logPollBlock(Sh2Block block, BlockPollData bpd, boolean supported) {
        LOG.makeLoggingEventBuilder(supported ? Level.INFO : Level.ERROR).log("{} Poll {} at PC {}: {} {}\n{}", new Object[]{block.drcContext.cpu, supported ? "detected" : "ignored", Util.th((int)block.prefetchPc), Util.th((int)bpd.memLoadTarget), block.pollType, Sh2Helper.toListOfInst(block)});
    }

    private static void detectDelayLoop(BlockPollData bpd) {
        int decreaseOpPos = -1;
        for (int i = 0; i < bpd.words.length; ++i) {
            if ((bpd.words[i] & 0xF0FF) != 16400) continue;
            decreaseOpPos = i;
        }
        if (decreaseOpPos > 0 && bpd.memLoadPos < 0 && bpd.branchPos >= 0 && bpd.branchDestPc == bpd.pc) {
            boolean match;
            String instList = Sh2Helper.toListOfInst(bpd.block).toString();
            boolean bl = match = !instList.contains("mov");
            if (match) {
                LOG.error("{} Delay Loop?? at PC {}: {} {}\n{}", new Object[]{bpd.block.drcContext.cpu, Util.th((int)bpd.block.prefetchPc), Util.th((int)bpd.memLoadTarget), bpd.block.pollType, instList});
            }
        }
    }

    public static PollType getAccessType(int address) {
        switch (address >>> 24) {
            case 6: 
            case 38: {
                return PollType.SDRAM;
            }
            case 4: 
            case 36: {
                return PollType.FRAMEBUFFER;
            }
            case 0: 
            case 32: {
                PollType pt = ptMap.get((Object)S32xDict.getRegSpec((S32xUtil.CpuDeviceAccess)S32xUtil.CpuDeviceAccess.MASTER, (int)address).deviceType);
                return pt == null ? PollType.NONE : pt;
            }
        }
        LOG.error("{} Unexpected {} access type for polling: {}", new Object[]{Md32xRuntimeData.getAccessTypeExt(), PollType.NONE, Util.th((int)address)});
        return PollType.NONE;
    }

    public static final void handlePoll(Sh2Block block) {
        S32xUtil.CpuDeviceAccess cpu = block.getCpu();
        if (!block.isPollingBlock()) {
            PollerCtx current = PollSysEventManager.instance.getPoller(cpu);
            assert (current != UNKNOWN_POLLER);
            if (current != NO_POLLER && block.pollType == PollType.BUSY_LOOP) {
                PollSysEventManager.instance.resetPoller(current.cpu);
            }
            return;
        }
        PollerCtx currentPoller = PollSysEventManager.instance.getPoller(cpu);
        PollerCtx blockPoller = block.poller;
        assert (blockPoller == Sh2Helper.get((int)block.prefetchPc, (S32xUtil.CpuDeviceAccess)cpu).block.poller);
        if (currentPoller == NO_POLLER) {
            PollType pollType = block.pollType;
            assert (blockPoller != UNKNOWN_POLLER);
            if (blockPoller != NO_POLLER) {
                PollSysEventManager.instance.setPoller(cpu, blockPoller);
            } else {
                assert (!pollType.supported) : block + "\n" + blockPoller;
                pollType = PollType.NONE;
            }
        } else if (!currentPoller.isPollingActive()) {
            if (blockPoller != currentPoller) {
                PollSysEventManager.instance.resetPoller(cpu);
                return;
            }
            Ow2DrcOptimizer.startPollingMaybe(blockPoller, block.pollType);
        } else if (currentPoller.isPollingActive()) {
            assert (blockPoller == currentPoller);
        } else {
            throw new RuntimeException("Unexpected, poller: " + currentPoller);
        }
    }

    private static void startPollingMaybe(PollerCtx blockPoller, PollType pollType) {
        if (blockPoller.spinCount < 3) {
            if (blockPoller.spinCount == 2) {
                Ow2DrcOptimizer.parseMemLoad(blockPoller.blockPollData);
                blockPoller.pollValue = PollSysEventManager.readPollValue(blockPoller);
            }
            return;
        }
        if (!Ow2DrcOptimizer.checkPollValueStable(blockPoller, pollType)) {
            return;
        }
        blockPoller.pollState = PollState.ACTIVE_POLL;
        PollSysEventManager.instance.fireSysEvent(blockPoller.cpu, PollSysEventManager.SysEvent.START_POLLING);
    }

    private static boolean checkPollValueStable(PollerCtx blockPoller, PollType pollType) {
        boolean res;
        int pollValue = PollSysEventManager.readPollValue(blockPoller);
        boolean bl = res = pollValue == blockPoller.pollValue;
        if (!res) {
            blockPoller.spinCount = 0;
            blockPoller.pollValue = 0;
        }
        return res;
    }

    public static void checkOptBlock(Sh2Block block) {
        int[] ops = block.prefetchWords;
        for (int i = 0; i < block.prefetchLenWords - 1; i += 2) {
            if (isMoviuExtu.test(ops[i] << 16 | ops[i + 1])) {
                System.out.println(Sh2Helper.toListOfInst(block.prefetchPc, ops[i], ops[i + 1]));
                continue;
            }
            if (!isExtOpcode.test(ops[i + 1]) || (ops[i + 1] >> 8 & 0xF) != (ops[i + 1] >> 4 & 0xF)) continue;
            System.out.println("Check:\n" + Sh2Helper.toListOfInst(block.prefetchPc, ops[i], ops[i + 1]));
        }
    }

    public static class PollerCtx {
        public S32xUtil.CpuDeviceAccess cpu;
        public int pc;
        public PollSysEventManager.SysEvent event;
        public PollState pollState = PollState.NO_POLL;
        public int spinCount = 0;
        public int pollValue = 0;
        public BlockPollData blockPollData;
        public Sh2Helper.Sh2PcInfoWrapper piw;

        public static PollerCtx create(Sh2Helper.Sh2PcInfoWrapper piw) {
            PollerCtx ctx = new PollerCtx();
            Sh2Block block = piw.block;
            ctx.piw = piw;
            ctx.pc = block.prefetchPc;
            assert (block.drcContext != null) : piw;
            ctx.cpu = block.drcContext.cpu;
            ctx.event = PollSysEventManager.SysEvent.NONE;
            ctx.blockPollData = new BlockPollData(block, block.drcContext.sh2Ctx, ctx.pc, block.prefetchWords);
            return ctx;
        }

        public boolean isPollingActive() {
            return this.pollState != PollState.NO_POLL;
        }

        public boolean isPollingBusyLoop() {
            return this.piw.block.pollType == PollType.BUSY_LOOP;
        }

        public void stopPolling() {
            this.pollState = PollState.NO_POLL;
            this.spinCount = 0;
        }

        public String toString() {
            return new StringJoiner(", ", PollerCtx.class.getSimpleName() + "[", "]").add("cpu=" + this.cpu).add("pc=" + Util.th((int)this.pc)).add("event=" + this.event).add("pollState=" + this.pollState).add("spinCount=" + this.spinCount).add("blockPollData=" + this.blockPollData).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PollerCtx pollerCtx = (PollerCtx)o;
            return this.pc == pollerCtx.pc && this.spinCount == pollerCtx.spinCount && this.cpu == pollerCtx.cpu && this.event == pollerCtx.event && this.pollState == pollerCtx.pollState && Objects.equal((Object)this.blockPollData, (Object)pollerCtx.blockPollData);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.cpu, this.pc, this.event, this.pollState, this.spinCount, this.blockPollData});
        }

        public void invalidate() {
            this.event = PollSysEventManager.SysEvent.NONE;
        }
    }

    public static enum PollType {
        UNKNOWN,
        NONE,
        BUSY_LOOP(true),
        SDRAM(true),
        FRAMEBUFFER,
        COMM(true),
        DMA,
        PWM,
        SYS(true),
        VDP(true);

        public final boolean supported;

        private PollType() {
            this(false);
        }

        private PollType(boolean supported) {
            this.supported = supported;
        }
    }

    public static class BlockPollData {
        public int memLoadPos = -1;
        public int memLoadOpcode;
        public int cmpPos = -1;
        public int cmpOpcode;
        public int branchPos = -1;
        public int branchOpcode;
        public int branchPc;
        public int branchDestPc;
        public int pc;
        public int memLoadTarget = 0;
        public int memLoadTargetEnd;
        public int numNops;
        public int numRegOnly;
        public Size memLoadTargetSize;
        public final int[] words;
        public final Sh2Context ctx;
        public final Sh2Block block;
        public boolean isPoller;
        public boolean isBusyLoop;
        private int activeInstLen = 0;

        public BlockPollData(Sh2Block block, Sh2Context ctx, int pc, int[] prefetchWords) {
            this.words = prefetchWords;
            this.pc = pc;
            this.ctx = ctx;
            this.block = block;
        }

        public void init() {
            this.numNops = (int)Arrays.stream(this.words).filter(op -> 9 == op).count();
            int nonNopsLen = this.words.length - this.numNops;
            this.detect(nonNopsLen);
        }

        private void detect(int nonNopsLen) {
            int memLoads = 0;
            for (int i = 0; i < this.words.length; ++i) {
                int opcode = this.words[i];
                if (isMemLoadOpcode.test(opcode)) {
                    this.memLoadPos = i;
                    this.memLoadOpcode = opcode;
                    ++this.activeInstLen;
                    ++memLoads;
                    continue;
                }
                if (isCmpTstOpcode.test(opcode) || isFlagOpcode.test(opcode)) {
                    this.cmpPos = i;
                    this.cmpOpcode = opcode;
                    ++this.activeInstLen;
                    continue;
                }
                if (!Sh2Debug.isBranchOpcode.test(opcode)) continue;
                this.branchPos = i;
                this.branchOpcode = opcode;
                this.branchPc = this.pc + (this.branchPos << 1);
                ++this.activeInstLen;
            }
            if (this.memLoadPos >= 0) {
                Ow2DrcOptimizer.parseMemLoad(this, this.ctx, this.memLoadOpcode);
            }
            if (this.branchPos >= 0) {
                this.branchDestPc = Ow2DrcOptimizer.getBranchDestination(this.branchOpcode, this.branchPc);
            }
            if (nonNopsLen == 2 && this.cmpPos >= 0 && this.branchPos >= 0 && this.branchDestPc == this.pc) {
                Ow2DrcOptimizer.parseMemLoad(this, this.ctx, this.cmpOpcode);
                this.memLoadPos = this.cmpPos;
                ++memLoads;
            }
            if (nonNopsLen == 1) {
                int endPc = this.pc + (this.words.length - 1 << 1);
                if (this.branchPos >= 0 && this.branchDestPc >= this.pc && this.branchDestPc <= endPc) {
                    this.isBusyLoop = true;
                }
            }
            this.numRegOnly = (int)Arrays.stream(this.words).filter(isRegOnlyOpcode::test).count();
            if (memLoads == 1) {
                this.isPollerRecalc();
            }
            if (this.isPoller && this.memLoadTarget == 0) {
                LOG.warn("Busy Loop?\n{}\n{}\n{}", new Object[]{Sh2Helper.toListOfInst(this.block), this.block, this});
                this.isPoller = false;
                this.isBusyLoop = true;
            }
        }

        private boolean isPollerRecalc() {
            int len = this.words.length;
            boolean okLen = this.activeInstLen + this.numNops + this.numRegOnly == len;
            this.isPoller = !(this.activeInstLen > 2 && this.cmpPos < 0 || this.activeInstLen > 1 && this.memLoadPos < 0 || this.branchPos < 0 || this.branchDestPc != this.pc || !okLen);
            return this.isPoller;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockPollData that = (BlockPollData)o;
            return this.memLoadPos == that.memLoadPos && this.memLoadOpcode == that.memLoadOpcode && this.cmpPos == that.cmpPos && this.cmpOpcode == that.cmpOpcode && this.branchPos == that.branchPos && this.branchOpcode == that.branchOpcode && this.branchPc == that.branchPc && this.branchDestPc == that.branchDestPc && this.pc == that.pc && this.memLoadTarget == that.memLoadTarget && this.isPoller == that.isPoller && this.memLoadTargetSize == that.memLoadTargetSize && Objects.equal((Object)this.words, (Object)that.words) && Objects.equal((Object)this.ctx, (Object)that.ctx);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.memLoadPos, this.memLoadOpcode, this.cmpPos, this.cmpOpcode, this.branchPos, this.branchOpcode, this.branchPc, this.branchDestPc, this.pc, this.memLoadTarget, this.memLoadTargetSize, this.words, this.ctx, this.isPoller});
        }

        public String toString() {
            return new StringJoiner(", ", BlockPollData.class.getSimpleName() + "[", "]").add("memLoadPos=" + Util.th((int)this.memLoadPos)).add("memLoadOpcode=" + Util.th((int)this.memLoadOpcode)).add("cmpPos=" + Util.th((int)this.cmpPos)).add("cmpOpcode=" + Util.th((int)this.cmpOpcode)).add("branchPos=" + Util.th((int)this.branchPos)).add("branchOpcode=" + Util.th((int)this.branchOpcode)).add("branchPc=" + Util.th((int)this.branchPc)).add("branchDestPc=" + Util.th((int)this.branchDestPc)).add("pc=" + Util.th((int)this.pc)).add("memLoadTarget=" + Util.th((int)this.memLoadTarget)).add("memLoadTargetSize=" + this.memLoadTargetSize).add("isPoller=" + this.isPoller).toString();
        }
    }

    public static enum PollState {
        NO_POLL,
        ACTIVE_POLL;

    }
}

