/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2.drc;

import java.util.HashSet;
import java.util.Set;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.LocalVariablesSorter;
import org.slf4j.Logger;
import s32x.bus.Sh2BusImpl;
import s32x.sh2.Sh2Context;
import s32x.sh2.Sh2Helper;
import s32x.sh2.Sh2Impl;
import s32x.sh2.Sh2Instructions;
import s32x.sh2.drc.Ow2Sh2BlockRecompiler;
import s32x.sh2.drc.Ow2Sh2Helper;
import s32x.sh2.prefetch.Sh2Prefetch;

public class Ow2Sh2Bytecode {
    private static final Logger LOG = LogHelper.getLogger((String)Ow2Sh2Bytecode.class.getSimpleName());
    public static final boolean addPrintStuff = false;
    public static final boolean printMissingOpcodes = true;
    private static final Set<String> instSet = new HashSet<String>();

    public static void ADD(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.opRegToReg(ctx, 96);
    }

    public static final void ADDC(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.sumWithCarry(ctx, true);
    }

    private static final void sumWithCarry(Sh2Prefetch.BytecodeContext ctx, boolean add) {
        int n = Sh2Impl.RN(ctx.opcode);
        int m = Sh2Impl.RM(ctx.opcode);
        int tmp0Idx = ctx.mv.newLocal(Type.LONG_TYPE);
        int tmp1Idx = ctx.mv.newLocal(Type.LONG_TYPE);
        int regNIdx = ctx.mv.newLocal(Type.LONG_TYPE);
        int tbIdx = ctx.mv.newLocal(Type.BOOLEAN_TYPE);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(133);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, 0xFFFFFFFFL);
        ctx.mv.visitInsn(127);
        ctx.mv.visitVarInsn(55, tmp0Idx);
        ctx.mv.visitVarInsn(22, tmp0Idx);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(133);
        ctx.mv.visitInsn(add ? 97 : 101);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, 0xFFFFFFFFL);
        ctx.mv.visitInsn(127);
        ctx.mv.visitVarInsn(55, tmp1Idx);
        ctx.mv.visitVarInsn(22, tmp1Idx);
        Ow2Sh2Helper.pushSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.SR.name());
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitInsn(126);
        ctx.mv.visitInsn(133);
        ctx.mv.visitInsn(add ? 97 : 101);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, 0xFFFFFFFFL);
        ctx.mv.visitInsn(127);
        ctx.mv.visitVarInsn(55, regNIdx);
        Label trueLabel = new Label();
        Label falseLabel = new Label();
        Label doneLabel = new Label();
        ctx.mv.visitVarInsn(22, tmp0Idx);
        ctx.mv.visitVarInsn(22, tmp1Idx);
        ctx.mv.visitInsn(148);
        ctx.mv.visitJumpInsn(add ? 157 : 155, trueLabel);
        ctx.mv.visitVarInsn(22, tmp1Idx);
        ctx.mv.visitVarInsn(22, regNIdx);
        ctx.mv.visitInsn(148);
        ctx.mv.visitJumpInsn(add ? 158 : 156, falseLabel);
        ctx.mv.visitLabel(trueLabel);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitJumpInsn(167, doneLabel);
        ctx.mv.visitLabel(falseLabel);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 0);
        ctx.mv.visitLabel(doneLabel);
        ctx.mv.visitVarInsn(54, tbIdx);
        Ow2Sh2Bytecode.clearSrFlag(ctx, 1);
        Ow2Sh2Helper.pushSh2Context(ctx);
        ctx.mv.visitInsn(89);
        Ow2Sh2Helper.pushSR(ctx);
        ctx.mv.visitVarInsn(21, tbIdx);
        ctx.mv.visitInsn(128);
        Ow2Sh2Helper.popSR(ctx);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitVarInsn(22, regNIdx);
        ctx.mv.visitInsn(136);
        ctx.mv.visitInsn(79);
    }

    public static void ADDI(Sh2Prefetch.BytecodeContext ctx) {
        int n = Sh2Impl.RN(ctx.opcode);
        byte b = (byte)(ctx.opcode & 0xFF);
        Ow2Sh2Bytecode.opRegImm(ctx, 96, n, b);
    }

    public static final void ADDV(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.sumWithOverflow(ctx, true);
    }

    public static void AND(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.opRegToReg(ctx, 126);
    }

    public static void ANDI(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.opReg0Imm(ctx, 126, ctx.opcode >> 0 & 0xFF);
    }

    public static void ANDM(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.opReg0Mem(ctx, 126);
    }

    public static void BF(Sh2Prefetch.BytecodeContext ctx) {
        int d = (byte)(ctx.opcode & 0xFF) << 1;
        int newPcJump = ctx.pc + 4 + d;
        Ow2Sh2Bytecode.branchInternal(ctx, newPcJump, true, false);
    }

    public static void BT(Sh2Prefetch.BytecodeContext ctx) {
        int d = (byte)(ctx.opcode & 0xFF) << 1;
        int newPcJump = ctx.pc + 4 + d;
        Ow2Sh2Bytecode.branchInternal(ctx, newPcJump, false, false);
    }

    private static void branchInternal(Sh2Prefetch.BytecodeContext ctx, int pcJump, boolean isBF, boolean isDelaySlot) {
        Label elseLbl = new Label();
        Label doneLbl = new Label();
        Ow2Sh2Helper.pushSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.SR.name());
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitInsn(126);
        ctx.mv.visitJumpInsn(isBF ? 154 : 153, elseLbl);
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, pcJump);
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.PC.name());
        Ow2Sh2Bytecode.subCyclesExt(ctx, ctx.sh2Inst.cyclesBranch);
        if (isDelaySlot) {
            Ow2Sh2Bytecode.delaySlot(ctx, pcJump);
        }
        ctx.mv.visitJumpInsn(167, doneLbl);
        ctx.mv.visitLabel(elseLbl);
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, ctx.pc + 2);
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.PC.name());
        Ow2Sh2Bytecode.subCyclesExt(ctx, ctx.sh2Inst.cycles);
        ctx.mv.visitLabel(doneLbl);
    }

    public static void BFS(Sh2Prefetch.BytecodeContext ctx) {
        int d = (byte)(ctx.opcode & 0xFF) << 1;
        int newPcJump = ctx.pc + 4 + d;
        Ow2Sh2Bytecode.branchInternal(ctx, newPcJump, true, true);
    }

    public static void BRA(Sh2Prefetch.BytecodeContext ctx) {
        int disp = (ctx.opcode & 0x800) == 0 ? 0xFFF & ctx.opcode : 0xFFFFF000 | ctx.opcode;
        int d = 4 + (disp << 1);
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, ctx.pc + d);
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.PC.name());
        Ow2Sh2Bytecode.subCyclesExt(ctx, ctx.sh2Inst.cycles);
        Ow2Sh2Bytecode.delaySlot(ctx, ctx.pc + d);
    }

    public static void BRAF(Sh2Prefetch.BytecodeContext ctx) {
        int n = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, ctx.pc + 4);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(96);
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.PC.name());
        Ow2Sh2Bytecode.subCyclesExt(ctx, ctx.sh2Inst.cycles);
        Ow2Sh2Bytecode.delaySlot(ctx);
    }

    public static void BSR(Sh2Prefetch.BytecodeContext ctx) {
        int disp = 0;
        disp = (ctx.opcode & 0x800) == 0 ? 0xFFF & ctx.opcode : 0xFFFFF000 | ctx.opcode;
        int d = (disp << 1) + 4;
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, ctx.pc + 4);
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.PR.name());
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, ctx.pc + d);
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.PC.name());
        Ow2Sh2Bytecode.subCyclesExt(ctx, ctx.sh2Inst.cycles);
        Ow2Sh2Bytecode.delaySlot(ctx, ctx.pc + d);
    }

    public static void BSRF(Sh2Prefetch.BytecodeContext ctx) {
        int n = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, ctx.pc + 4);
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.PR.name());
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, ctx.pc + 4);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(96);
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.PC.name());
        Ow2Sh2Bytecode.subCyclesExt(ctx, ctx.sh2Inst.cycles);
        Ow2Sh2Bytecode.delaySlot(ctx);
    }

    public static void BTS(Sh2Prefetch.BytecodeContext ctx) {
        int d = (byte)(ctx.opcode & 0xFF) << 1;
        int newPcJump = ctx.pc + 4 + d;
        Ow2Sh2Bytecode.branchInternal(ctx, newPcJump, false, true);
    }

    public static void CLRMAC(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 0);
        ctx.mv.visitInsn(90);
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACH.name());
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACL.name());
    }

    public static void CLRT(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.clearSrFlag(ctx, 1);
    }

    public static final void CMPEQ(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.cmpRegToReg(ctx, 160);
    }

    public static final void CMPGE(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.cmpRegToReg(ctx, 161);
    }

    public static final void CMPGT(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.cmpRegToReg(ctx, 164);
    }

    public static final void CMPHS(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.cmpRegToRegUnsigned(ctx, 155);
    }

    public static final void CMPHI(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.cmpRegToRegUnsigned(ctx, 158);
    }

    public static final void CMPIM(Sh2Prefetch.BytecodeContext ctx) {
        byte i = (byte)(ctx.opcode & 0xFF);
        Ow2Sh2Bytecode.pushRegStack(ctx, 0);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitPushConstToStack(ctx, i);
        Ow2Sh2Bytecode.cmpInternal(ctx, 160);
    }

    public static final void CMPPL(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.cmpRegToZero(ctx, Sh2Impl.RN(ctx.opcode), 158);
    }

    public static final void CMPPZ(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.cmpRegToZero(ctx, Sh2Impl.RN(ctx.opcode), 155);
    }

    public static final void CMPSTR(Sh2Prefetch.BytecodeContext ctx) {
        int n = Sh2Impl.RN(ctx.opcode);
        int m = Sh2Impl.RM(ctx.opcode);
        int tmpIdx = ctx.mv.newLocal(Type.INT_TYPE);
        int hhIdx = ctx.mv.newLocal(Type.INT_TYPE);
        int hlIdx = ctx.mv.newLocal(Type.INT_TYPE);
        int lhIdx = ctx.mv.newLocal(Type.INT_TYPE);
        int llIdx = ctx.mv.newLocal(Type.INT_TYPE);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(130);
        ctx.mv.visitVarInsn(54, tmpIdx);
        ctx.mv.visitVarInsn(21, tmpIdx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 24);
        ctx.mv.visitInsn(124);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 255);
        ctx.mv.visitInsn(126);
        ctx.mv.visitVarInsn(54, hhIdx);
        ctx.mv.visitVarInsn(21, tmpIdx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 16);
        ctx.mv.visitInsn(124);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 255);
        ctx.mv.visitInsn(126);
        ctx.mv.visitVarInsn(54, hlIdx);
        ctx.mv.visitVarInsn(21, tmpIdx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 8);
        ctx.mv.visitInsn(124);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 255);
        ctx.mv.visitInsn(126);
        ctx.mv.visitVarInsn(54, lhIdx);
        ctx.mv.visitVarInsn(21, tmpIdx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 255);
        ctx.mv.visitInsn(126);
        ctx.mv.visitVarInsn(54, llIdx);
        Ow2Sh2Bytecode.clearSrFlag(ctx, 1);
        Label endLabel = new Label();
        ctx.mv.visitVarInsn(21, hhIdx);
        ctx.mv.visitVarInsn(21, hlIdx);
        ctx.mv.visitInsn(126);
        ctx.mv.visitVarInsn(21, lhIdx);
        ctx.mv.visitInsn(126);
        ctx.mv.visitVarInsn(21, llIdx);
        ctx.mv.visitInsn(126);
        ctx.mv.visitJumpInsn(154, endLabel);
        Ow2Sh2Bytecode.setSrFlag(ctx, 1);
        ctx.mv.visitLabel(endLabel);
    }

    public static void cmpRegToZero(Sh2Prefetch.BytecodeContext ctx, int reg, int cmpOpcode) {
        Ow2Sh2Bytecode.pushRegStack(ctx, reg);
        ctx.mv.visitInsn(46);
        Ow2Sh2Bytecode.cmpInternal(ctx, cmpOpcode);
    }

    public static void cmpRegToReg(Sh2Prefetch.BytecodeContext ctx, int cmpOpcode) {
        int n = Sh2Impl.RN(ctx.opcode);
        int m = Sh2Impl.RM(ctx.opcode);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        Ow2Sh2Bytecode.cmpInternal(ctx, cmpOpcode);
    }

    public static void cmpRegToRegUnsigned(Sh2Prefetch.BytecodeContext ctx, int cmpOpcode) {
        int n = Sh2Impl.RN(ctx.opcode);
        int m = Sh2Impl.RM(ctx.opcode);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(133);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, 0xFFFFFFFFL);
        ctx.mv.visitInsn(127);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(133);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, 0xFFFFFFFFL);
        ctx.mv.visitInsn(127);
        ctx.mv.visitInsn(148);
        Ow2Sh2Bytecode.cmpInternal(ctx, cmpOpcode);
    }

    public static void cmpInternal(Sh2Prefetch.BytecodeContext ctx, int cmpOpcode) {
        Label elseLabel = new Label();
        Label endLabel = new Label();
        ctx.mv.visitJumpInsn(cmpOpcode, elseLabel);
        Ow2Sh2Bytecode.setSrFlag(ctx, 1);
        ctx.mv.visitJumpInsn(167, endLabel);
        ctx.mv.visitLabel(elseLabel);
        Ow2Sh2Bytecode.clearSrFlag(ctx, 1);
        ctx.mv.visitLabel(endLabel);
    }

    private static void setSrFlag(Sh2Prefetch.BytecodeContext ctx, int flag) {
        Ow2Sh2Helper.pushSh2Context(ctx);
        ctx.mv.visitInsn(89);
        Ow2Sh2Helper.pushSR(ctx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, flag);
        ctx.mv.visitInsn(128);
        Ow2Sh2Helper.popSR(ctx);
    }

    private static void clearSrFlag(Sh2Prefetch.BytecodeContext ctx, int flag) {
        Ow2Sh2Bytecode.clearSrFlag(ctx, flag, true);
    }

    private static void clearSrFlag(Sh2Prefetch.BytecodeContext ctx, int flag, boolean popSr) {
        Ow2Sh2Helper.pushSh2Context(ctx);
        ctx.mv.visitInsn(89);
        Ow2Sh2Helper.pushSR(ctx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, ~flag);
        ctx.mv.visitInsn(126);
        if (popSr) {
            Ow2Sh2Helper.popSR(ctx);
        }
    }

    public static void DIV0S(Sh2Prefetch.BytecodeContext ctx) {
        int m = Sh2Impl.RM(ctx.opcode);
        int n = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Bytecode.clearSrFlag(ctx, 769);
        Ow2Sh2Helper.pushSh2Context(ctx);
        ctx.mv.visitInsn(89);
        Ow2Sh2Helper.pushSR(ctx);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 31);
        ctx.mv.visitInsn(124);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 8);
        ctx.mv.visitInsn(120);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 31);
        ctx.mv.visitInsn(124);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 9);
        ctx.mv.visitInsn(120);
        ctx.mv.visitInsn(128);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(130);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 31);
        ctx.mv.visitInsn(124);
        ctx.mv.visitInsn(128);
        ctx.mv.visitInsn(128);
        Ow2Sh2Helper.popSR(ctx);
    }

    public static void DIV1(Sh2Prefetch.BytecodeContext ctx) {
        int dvd = Sh2Impl.RN(ctx.opcode);
        int dvsr = Sh2Impl.RM(ctx.opcode);
        int udvdIdx = ctx.mv.newLocal(Type.LONG_TYPE);
        int udvsrIdx = ctx.mv.newLocal(Type.LONG_TYPE);
        int rIdx = ctx.mv.newLocal(Type.LONG_TYPE);
        int oldQIdx = ctx.mv.newLocal(Type.INT_TYPE);
        int qmIdx = ctx.mv.newLocal(Type.INT_TYPE);
        int qIdx = ctx.mv.newLocal(Type.INT_TYPE);
        Ow2Sh2Bytecode.pushRegStack(ctx, dvd);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(133);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, 0xFFFFFFFFL);
        ctx.mv.visitInsn(127);
        ctx.mv.visitVarInsn(55, udvdIdx);
        Ow2Sh2Bytecode.pushRegStack(ctx, dvsr);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(133);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, 0xFFFFFFFFL);
        ctx.mv.visitInsn(127);
        ctx.mv.visitVarInsn(55, udvsrIdx);
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Helper.pushSR(ctx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 8);
        ctx.mv.visitInsn(122);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitInsn(126);
        ctx.mv.visitVarInsn(54, oldQIdx);
        Ow2Sh2Bytecode.clearSrFlag(ctx, 256);
        Ow2Sh2Helper.pushSh2Context(ctx);
        ctx.mv.visitInsn(89);
        Ow2Sh2Helper.pushSR(ctx);
        ctx.mv.visitVarInsn(22, udvdIdx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 31);
        ctx.mv.visitInsn(123);
        ctx.mv.visitInsn(136);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitInsn(126);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 8);
        ctx.mv.visitInsn(120);
        ctx.mv.visitInsn(128);
        Ow2Sh2Helper.popSR(ctx);
        ctx.mv.visitVarInsn(22, udvdIdx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitInsn(121);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, 0xFFFFFFFFL);
        ctx.mv.visitInsn(127);
        ctx.mv.visitVarInsn(55, rIdx);
        ctx.mv.visitVarInsn(22, rIdx);
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Helper.pushSR(ctx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitInsn(126);
        ctx.mv.visitInsn(133);
        ctx.mv.visitInsn(129);
        ctx.mv.visitVarInsn(55, rIdx);
        Label elseLabel = new Label();
        Label endLabel = new Label();
        ctx.mv.visitVarInsn(21, oldQIdx);
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Helper.pushSR(ctx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 9);
        ctx.mv.visitInsn(122);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitInsn(126);
        ctx.mv.visitJumpInsn(160, elseLabel);
        ctx.mv.visitVarInsn(22, rIdx);
        ctx.mv.visitVarInsn(22, udvsrIdx);
        ctx.mv.visitInsn(101);
        ctx.mv.visitVarInsn(55, rIdx);
        ctx.mv.visitJumpInsn(167, endLabel);
        ctx.mv.visitLabel(elseLabel);
        ctx.mv.visitVarInsn(22, rIdx);
        ctx.mv.visitVarInsn(22, udvsrIdx);
        ctx.mv.visitInsn(97);
        ctx.mv.visitVarInsn(55, rIdx);
        ctx.mv.visitLabel(endLabel);
        Ow2Sh2Bytecode.pushRegStack(ctx, dvd);
        ctx.mv.visitVarInsn(22, rIdx);
        ctx.mv.visitInsn(136);
        ctx.mv.visitInsn(79);
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Helper.pushSR(ctx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 8);
        ctx.mv.visitInsn(122);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitInsn(126);
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Helper.pushSR(ctx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 9);
        ctx.mv.visitInsn(122);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitInsn(126);
        ctx.mv.visitInsn(130);
        ctx.mv.visitVarInsn(54, qmIdx);
        ctx.mv.visitVarInsn(21, qmIdx);
        ctx.mv.visitVarInsn(22, rIdx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 32);
        ctx.mv.visitInsn(123);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, 1L);
        ctx.mv.visitInsn(127);
        ctx.mv.visitInsn(136);
        ctx.mv.visitInsn(130);
        ctx.mv.visitVarInsn(54, qIdx);
        ctx.mv.visitVarInsn(21, qIdx);
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Helper.pushSR(ctx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 9);
        ctx.mv.visitInsn(122);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitInsn(126);
        ctx.mv.visitInsn(130);
        ctx.mv.visitVarInsn(54, qmIdx);
        Ow2Sh2Bytecode.clearSrFlag(ctx, 257);
        Ow2Sh2Helper.pushSh2Context(ctx);
        ctx.mv.visitInsn(89);
        Ow2Sh2Helper.pushSR(ctx);
        ctx.mv.visitVarInsn(21, qIdx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 8);
        ctx.mv.visitInsn(120);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitVarInsn(21, qmIdx);
        ctx.mv.visitInsn(100);
        ctx.mv.visitInsn(128);
        ctx.mv.visitInsn(128);
        Ow2Sh2Helper.popSR(ctx);
    }

    public static void DIV0U(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.clearSrFlag(ctx, 769);
    }

    public static void DMULS(Sh2Prefetch.BytecodeContext ctx) {
        assert (LocalVariablesSorter.class.isInstance(ctx.mv));
        int longVarIdx = ctx.mv.newLocal(Type.LONG_TYPE);
        int m = Sh2Impl.RM(ctx.opcode);
        int n = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(133);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(133);
        ctx.mv.visitInsn(105);
        ctx.mv.visitVarInsn(55, longVarIdx);
        Ow2Sh2Bytecode.storeToMAC(ctx, longVarIdx);
    }

    public static void DMULU(Sh2Prefetch.BytecodeContext ctx) {
        assert (LocalVariablesSorter.class.isInstance(ctx.mv));
        int longVarIdx = ctx.mv.newLocal(Type.LONG_TYPE);
        int m = Sh2Impl.RM(ctx.opcode);
        int n = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(133);
        ctx.mv.visitLdcInsn((Object)0xFFFFFFFFL);
        ctx.mv.visitInsn(127);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(133);
        ctx.mv.visitLdcInsn((Object)0xFFFFFFFFL);
        ctx.mv.visitInsn(127);
        ctx.mv.visitInsn(105);
        ctx.mv.visitVarInsn(55, longVarIdx);
        Ow2Sh2Bytecode.storeToMAC(ctx, longVarIdx);
    }

    public static void DT(Sh2Prefetch.BytecodeContext ctx) {
        int n = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Bytecode.decReg(ctx, n, 1);
        Ow2Sh2Bytecode.cmpRegToZero(ctx, n, 154);
    }

    public static void EXTSB(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.extSigned(ctx, Size.BYTE);
    }

    public static void EXTSW(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.extSigned(ctx, Size.WORD);
    }

    public static void EXTUB(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.extUnsigned(ctx, Size.BYTE);
    }

    public static void EXTUW(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.extUnsigned(ctx, Size.WORD);
    }

    public static void ILLEGAL(Sh2Prefetch.BytecodeContext ctx) {
        LOG.error("{} illegal instruction: {}\n{}", new Object[]{ctx.drcCtx.sh2Ctx.cpuAccess, Util.th((int)ctx.opcode), Sh2Helper.toDebuggingString(ctx.drcCtx.sh2Ctx)});
        Ow2Sh2Helper.pushSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.PC.name());
        Ow2Sh2Helper.pushSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.PC.name());
        Ow2Sh2Helper.pushSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.SR.name());
        Ow2Sh2Helper.sh2PushReg15(ctx);
        Ow2Sh2Helper.sh2PushReg15(ctx);
        Ow2Sh2Helper.pushSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.VBR.name());
        Ow2Sh2Helper.emitPushConstToStack(ctx, 16);
        ctx.mv.visitInsn(96);
        Ow2Sh2Bytecode.readMem(ctx, Size.LONG);
        ctx.mv.visitFieldInsn(181, Type.getInternalName(Sh2Context.class), Ow2Sh2Helper.SH2CTX_CLASS_FIELD.PC.name(), Ow2Sh2BlockRecompiler.intDesc);
    }

    public static void JMP(Sh2Prefetch.BytecodeContext ctx) {
        int n = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.PC.name());
        Ow2Sh2Bytecode.subCyclesExt(ctx, ctx.sh2Inst.cycles);
        Ow2Sh2Bytecode.delaySlot(ctx);
    }

    public static void JSR(Sh2Prefetch.BytecodeContext ctx) {
        int n = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, ctx.pc + 4);
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.PR.name());
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.PC.name());
        Ow2Sh2Bytecode.subCyclesExt(ctx, ctx.sh2Inst.cycles);
        Ow2Sh2Bytecode.delaySlot(ctx);
    }

    public static void LDCGBR(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.ldcReg(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.GBR.name(), -1, 1);
    }

    public static void LDCSR(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.ldcReg(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.SR.name(), 1011, 1);
    }

    public static void LDCVBR(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.ldcReg(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.VBR.name(), -1, 1);
    }

    public static final void LDCMGBR(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.ldcmReg(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.GBR.name(), -1, 3);
    }

    public static final void LDCMSR(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.ldcmReg(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.SR.name(), 1011, 3);
    }

    public static final void LDCMVBR(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.ldcmReg(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.VBR.name(), -1, 3);
    }

    public static void LDSMACH(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.ldcReg(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACH.name(), -1, 2);
    }

    public static void LDSMACL(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.ldcReg(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACL.name(), -1, 2);
    }

    public static void LDSPR(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.ldcReg(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.PR.name(), -1, 1);
    }

    public static final void LDSMMACH(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.ldcmReg(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACH.name(), -1, 1);
    }

    public static final void LDSMMACL(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.ldcmReg(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACL.name(), -1, 1);
    }

    public static final void LDSMPR(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.ldcmReg(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.PR.name(), -1, 1);
    }

    public static final void MACL(Sh2Prefetch.BytecodeContext ctx) {
        int n = Sh2Impl.RN(ctx.opcode);
        int m = Sh2Impl.RM(ctx.opcode);
        int regNIdx = ctx.mv.newLocal(Type.LONG_TYPE);
        int regMIdx = ctx.mv.newLocal(Type.LONG_TYPE);
        int resIdx = ctx.mv.newLocal(Type.LONG_TYPE);
        Ow2Sh2Helper.pushMemory(ctx);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        Ow2Sh2Bytecode.readMem(ctx, Size.LONG);
        ctx.mv.visitInsn(133);
        ctx.mv.visitVarInsn(55, regNIdx);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(92);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 4);
        ctx.mv.visitInsn(96);
        ctx.mv.visitInsn(79);
        Ow2Sh2Helper.pushMemory(ctx);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        Ow2Sh2Bytecode.readMem(ctx, Size.LONG);
        ctx.mv.visitInsn(133);
        ctx.mv.visitVarInsn(55, regMIdx);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(92);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 4);
        ctx.mv.visitInsn(96);
        ctx.mv.visitInsn(79);
        ctx.mv.visitVarInsn(22, regMIdx);
        ctx.mv.visitVarInsn(22, regNIdx);
        ctx.mv.visitInsn(105);
        ctx.mv.visitVarInsn(55, resIdx);
        ctx.mv.visitVarInsn(22, resIdx);
        Ow2Sh2Helper.pushSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACH.name());
        ctx.mv.visitInsn(133);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, 0xFFFFFFFFL);
        ctx.mv.visitInsn(127);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 32);
        ctx.mv.visitInsn(121);
        Ow2Sh2Helper.pushSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACL.name());
        ctx.mv.visitInsn(133);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, 0xFFFFFFFFL);
        ctx.mv.visitInsn(127);
        ctx.mv.visitInsn(97);
        ctx.mv.visitInsn(97);
        ctx.mv.visitVarInsn(55, resIdx);
        Label endLabel = new Label();
        Label elseIfLabel = new Label();
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Helper.pushSR(ctx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 2);
        ctx.mv.visitInsn(126);
        ctx.mv.visitJumpInsn(158, endLabel);
        ctx.mv.visitVarInsn(22, resIdx);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, 0x7FFFFFFFFFFFL);
        ctx.mv.visitInsn(148);
        ctx.mv.visitJumpInsn(158, elseIfLabel);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, 0x7FFFFFFFFFFFL);
        ctx.mv.visitVarInsn(55, resIdx);
        ctx.mv.visitJumpInsn(167, endLabel);
        ctx.mv.visitLabel(elseIfLabel);
        ctx.mv.visitVarInsn(22, resIdx);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, -140737488355328L);
        ctx.mv.visitInsn(148);
        ctx.mv.visitJumpInsn(156, endLabel);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, -140737488355328L);
        ctx.mv.visitVarInsn(55, resIdx);
        ctx.mv.visitLabel(endLabel);
        Ow2Sh2Helper.pushSh2Context(ctx);
        ctx.mv.visitVarInsn(22, resIdx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 32);
        ctx.mv.visitInsn(123);
        ctx.mv.visitInsn(136);
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACH.name());
        Ow2Sh2Helper.pushSh2Context(ctx);
        ctx.mv.visitVarInsn(22, resIdx);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, -1L);
        ctx.mv.visitInsn(127);
        ctx.mv.visitInsn(136);
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACL.name());
    }

    public static final void MACW(Sh2Prefetch.BytecodeContext ctx) {
        int n = Sh2Impl.RN(ctx.opcode);
        int m = Sh2Impl.RM(ctx.opcode);
        int regNIdx = ctx.mv.newLocal(Type.SHORT_TYPE);
        int regMIdx = ctx.mv.newLocal(Type.SHORT_TYPE);
        Label returnLabel = new Label();
        Ow2Sh2Helper.pushMemory(ctx);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        Ow2Sh2Bytecode.readMem(ctx, Size.WORD);
        ctx.mv.visitInsn(147);
        ctx.mv.visitVarInsn(54, regNIdx);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(92);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 2);
        ctx.mv.visitInsn(96);
        ctx.mv.visitInsn(79);
        Ow2Sh2Helper.pushMemory(ctx);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        Ow2Sh2Bytecode.readMem(ctx, Size.WORD);
        ctx.mv.visitInsn(147);
        ctx.mv.visitVarInsn(54, regMIdx);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(92);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 2);
        ctx.mv.visitInsn(96);
        ctx.mv.visitInsn(79);
        Label macw64Label = new Label();
        Ow2Sh2Helper.pushSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.SR.name());
        Ow2Sh2Helper.emitPushConstToStack(ctx, 2);
        ctx.mv.visitInsn(126);
        ctx.mv.visitJumpInsn(158, macw64Label);
        Ow2Sh2Bytecode.macw32Block(ctx, regNIdx, regMIdx, returnLabel);
        Ow2Sh2Bytecode.macw64Block(ctx, regNIdx, regMIdx, macw64Label, returnLabel);
        ctx.mv.visitLabel(returnLabel);
    }

    private static void macw32Block(Sh2Prefetch.BytecodeContext ctx, int regNIdx, int regMIdx, Label returnLabel) {
        int resIdx = ctx.mv.newLocal(Type.LONG_TYPE);
        Label elseIfLabel = new Label();
        Label endLabel = new Label();
        ctx.mv.visitVarInsn(21, regMIdx);
        ctx.mv.visitVarInsn(21, regNIdx);
        ctx.mv.visitInsn(104);
        ctx.mv.visitInsn(133);
        Ow2Sh2Helper.pushSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACL.name());
        ctx.mv.visitInsn(133);
        ctx.mv.visitInsn(97);
        ctx.mv.visitVarInsn(55, resIdx);
        ctx.mv.visitVarInsn(22, resIdx);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, Integer.MAX_VALUE);
        ctx.mv.visitInsn(148);
        ctx.mv.visitJumpInsn(158, elseIfLabel);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, Integer.MAX_VALUE);
        ctx.mv.visitVarInsn(55, resIdx);
        Ow2Sh2Helper.pushSh2Context(ctx);
        ctx.mv.visitInsn(89);
        Ow2Sh2Helper.pushField(ctx, Sh2Context.class, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACH.name(), Integer.TYPE);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitInsn(128);
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACH.name());
        ctx.mv.visitJumpInsn(167, endLabel);
        ctx.mv.visitLabel(elseIfLabel);
        ctx.mv.visitVarInsn(22, resIdx);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, Integer.MIN_VALUE);
        ctx.mv.visitInsn(148);
        ctx.mv.visitJumpInsn(156, endLabel);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, Integer.MIN_VALUE);
        ctx.mv.visitVarInsn(55, resIdx);
        Ow2Sh2Helper.pushSh2Context(ctx);
        ctx.mv.visitInsn(89);
        Ow2Sh2Helper.pushField(ctx, Sh2Context.class, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACH.name(), Integer.TYPE);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitInsn(128);
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACH.name());
        ctx.mv.visitJumpInsn(167, endLabel);
        ctx.mv.visitLabel(endLabel);
        Ow2Sh2Helper.pushSh2Context(ctx);
        ctx.mv.visitVarInsn(22, resIdx);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, -1L);
        ctx.mv.visitInsn(127);
        ctx.mv.visitInsn(136);
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACL.name());
        ctx.mv.visitJumpInsn(167, returnLabel);
    }

    private static void macw64Block(Sh2Prefetch.BytecodeContext ctx, int regNIdx, int regMIdx, Label macw64Label, Label returnLabel) {
        int prodIdx = ctx.mv.newLocal(Type.LONG_TYPE);
        int macIdx = ctx.mv.newLocal(Type.LONG_TYPE);
        int resIdx = ctx.mv.newLocal(Type.LONG_TYPE);
        ctx.mv.visitLabel(macw64Label);
        ctx.mv.visitVarInsn(21, regMIdx);
        ctx.mv.visitVarInsn(21, regNIdx);
        ctx.mv.visitInsn(104);
        ctx.mv.visitInsn(133);
        ctx.mv.visitVarInsn(55, prodIdx);
        Ow2Sh2Helper.pushSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACH.name());
        ctx.mv.visitInsn(133);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, 0xFFFFFFFFL);
        ctx.mv.visitInsn(127);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 32);
        ctx.mv.visitInsn(121);
        Ow2Sh2Helper.pushSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACL.name());
        ctx.mv.visitInsn(133);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, 0xFFFFFFFFL);
        ctx.mv.visitInsn(127);
        ctx.mv.visitInsn(97);
        ctx.mv.visitVarInsn(55, macIdx);
        ctx.mv.visitVarInsn(22, prodIdx);
        ctx.mv.visitVarInsn(22, macIdx);
        ctx.mv.visitInsn(97);
        ctx.mv.visitVarInsn(55, resIdx);
        Ow2Sh2Helper.pushSh2Context(ctx);
        ctx.mv.visitVarInsn(22, resIdx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 32);
        ctx.mv.visitInsn(123);
        ctx.mv.visitInsn(136);
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACH.name());
        Ow2Sh2Helper.pushSh2Context(ctx);
        ctx.mv.visitVarInsn(22, resIdx);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, -1L);
        ctx.mv.visitInsn(127);
        ctx.mv.visitInsn(136);
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACL.name());
        Label ifLabel64 = new Label();
        Label orSecondPartLabel = new Label();
        ctx.mv.visitVarInsn(22, prodIdx);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, 0L);
        ctx.mv.visitInsn(148);
        ctx.mv.visitJumpInsn(158, orSecondPartLabel);
        ctx.mv.visitVarInsn(22, macIdx);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, 0L);
        ctx.mv.visitInsn(148);
        ctx.mv.visitJumpInsn(158, orSecondPartLabel);
        ctx.mv.visitVarInsn(22, resIdx);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, 0L);
        ctx.mv.visitInsn(148);
        ctx.mv.visitJumpInsn(155, ifLabel64);
        ctx.mv.visitLabel(orSecondPartLabel);
        ctx.mv.visitVarInsn(22, macIdx);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, 0L);
        ctx.mv.visitInsn(148);
        ctx.mv.visitJumpInsn(156, returnLabel);
        ctx.mv.visitVarInsn(22, prodIdx);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, 0L);
        ctx.mv.visitInsn(148);
        ctx.mv.visitJumpInsn(156, returnLabel);
        ctx.mv.visitVarInsn(22, resIdx);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, 0L);
        ctx.mv.visitInsn(148);
        ctx.mv.visitJumpInsn(158, returnLabel);
        ctx.mv.visitLabel(ifLabel64);
        Ow2Sh2Helper.pushSh2Context(ctx);
        ctx.mv.visitInsn(89);
        Ow2Sh2Helper.pushField(ctx, Sh2Context.class, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACH.name(), Integer.TYPE);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitInsn(128);
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACH.name());
    }

    public static void MOV(Sh2Prefetch.BytecodeContext ctx) {
        int n = Sh2Impl.RN(ctx.opcode);
        int m = Sh2Impl.RM(ctx.opcode);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(79);
    }

    public static void MOVA(Sh2Prefetch.BytecodeContext ctx) {
        int pcBase = ctx.pc + 4;
        int d = ctx.opcode & 0xFF;
        if (ctx.delaySlot) {
            LOG.warn("MOVA delaySlot at PC: {}, branchPc: {}", (Object)Util.th((int)ctx.pc), (Object)Util.th((int)ctx.branchPc));
            System.out.println("MOVA delaySlot");
            assert (ctx.branchPc != 0);
            pcBase = ctx.branchPc + 2;
        }
        int memAddr = (pcBase & 0xFFFFFFFC) + (d << 2);
        Ow2Sh2Bytecode.pushRegStack(ctx, 0);
        Ow2Sh2Helper.emitPushConstToStack(ctx, memAddr);
        ctx.mv.visitInsn(79);
    }

    public static final void MOVBL(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movMemToReg(ctx, Size.BYTE);
    }

    public static final void MOVWL(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movMemToReg(ctx, Size.WORD);
    }

    public static final void MOVLL(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movMemToReg(ctx, Size.LONG);
    }

    public static final void MOVBL0(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movMemWithReg0ShiftToReg(ctx, Size.BYTE);
    }

    public static final void MOVWL0(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movMemWithReg0ShiftToReg(ctx, Size.WORD);
    }

    public static final void MOVLL0(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movMemWithReg0ShiftToReg(ctx, Size.LONG);
    }

    public static final void MOVBL4(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movMemToRegShift(ctx, Size.BYTE);
    }

    public static final void MOVWL4(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movMemToRegShift(ctx, Size.WORD);
    }

    public static final void MOVLL4(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movMemToRegShift(ctx, Size.LONG);
    }

    public static final void MOVBLG(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movMemWithGBRShiftToReg0(ctx, Size.BYTE);
    }

    public static final void MOVWLG(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movMemWithGBRShiftToReg0(ctx, Size.WORD);
    }

    public static final void MOVLLG(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movMemWithGBRShiftToReg0(ctx, Size.LONG);
    }

    public static final void MOVBP(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movMemToRegPostInc(ctx, Size.BYTE);
    }

    public static final void MOVWP(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movMemToRegPostInc(ctx, Size.WORD);
    }

    public static final void MOVLP(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movMemToRegPostInc(ctx, Size.LONG);
    }

    public static final void MOVBM(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movRegPredecToMem(ctx, Size.BYTE);
    }

    public static final void MOVWM(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movRegPredecToMem(ctx, Size.WORD);
    }

    public static final void MOVLM(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movRegPredecToMem(ctx, Size.LONG);
    }

    public static final void MOVBS(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movRegToReg(ctx, Size.BYTE);
    }

    public static final void MOVWS(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movRegToReg(ctx, Size.WORD);
    }

    public static final void MOVLS(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movRegToReg(ctx, Size.LONG);
    }

    public static final void MOVBS0(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movRegToMemWithReg0Shift(ctx, Size.BYTE);
    }

    public static final void MOVWS0(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movRegToMemWithReg0Shift(ctx, Size.WORD);
    }

    public static final void MOVLS0(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movRegToMemWithReg0Shift(ctx, Size.LONG);
    }

    public static final void MOVBS4(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movRegToRegShift(ctx, Size.BYTE);
    }

    public static final void MOVWS4(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movRegToRegShift(ctx, Size.WORD);
    }

    public static final void MOVLS4(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movRegToRegShift(ctx, Size.LONG);
    }

    public static final void MOVBSG(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movGBRShiftToReg0(ctx, Size.BYTE);
    }

    public static final void MOVWSG(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movGBRShiftToReg0(ctx, Size.WORD);
    }

    public static final void MOVLSG(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movGBRShiftToReg0(ctx, Size.LONG);
    }

    public static void MOVI(Sh2Prefetch.BytecodeContext ctx) {
        int reg = ctx.opcode >> 8 & 0xF;
        Ow2Sh2Bytecode.storeToReg(ctx, reg, ctx.opcode, Size.BYTE);
    }

    public static void MOVT(Sh2Prefetch.BytecodeContext ctx) {
        int n = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        Ow2Sh2Helper.pushSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.SR.name());
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitInsn(126);
        ctx.mv.visitInsn(79);
    }

    public static final void MOVWI(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movMemWithPcOffsetToReg(ctx, Size.WORD);
    }

    public static final void MOVLI(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.movMemWithPcOffsetToReg(ctx, Size.LONG);
    }

    public static void MULL(Sh2Prefetch.BytecodeContext ctx) {
        int m = Sh2Impl.RM(ctx.opcode);
        int n = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(104);
        ctx.mv.visitInsn(2);
        ctx.mv.visitInsn(126);
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACL.name());
    }

    public static void MULSW(Sh2Prefetch.BytecodeContext ctx) {
        int m = Sh2Impl.RM(ctx.opcode);
        int n = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(147);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(147);
        ctx.mv.visitInsn(104);
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACL.name());
    }

    public static void MULSU(Sh2Prefetch.BytecodeContext ctx) {
        int m = Sh2Impl.RM(ctx.opcode);
        int n = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        ctx.mv.visitLdcInsn((Object)65535);
        ctx.mv.visitInsn(126);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        ctx.mv.visitLdcInsn((Object)65535);
        ctx.mv.visitInsn(126);
        ctx.mv.visitInsn(104);
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACL.name());
    }

    public static void NEG(Sh2Prefetch.BytecodeContext ctx) {
        int m = Sh2Impl.RM(ctx.opcode);
        int n = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(3);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(100);
        ctx.mv.visitInsn(79);
    }

    public static void NEGC(Sh2Prefetch.BytecodeContext ctx) {
        int m = Sh2Impl.RM(ctx.opcode);
        int n = Sh2Impl.RN(ctx.opcode);
        int temp0Idx = ctx.mv.newLocal(Type.LONG_TYPE);
        int regNIdx = ctx.mv.newLocal(Type.LONG_TYPE);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 0);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(100);
        ctx.mv.visitInsn(133);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, 0xFFFFFFFFL);
        ctx.mv.visitInsn(127);
        ctx.mv.visitVarInsn(55, temp0Idx);
        ctx.mv.visitVarInsn(22, temp0Idx);
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Helper.pushSR(ctx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitInsn(126);
        ctx.mv.visitInsn(133);
        ctx.mv.visitInsn(101);
        Ow2Sh2Helper.emitPushLongConstToStack(ctx, 0xFFFFFFFFL);
        ctx.mv.visitInsn(127);
        ctx.mv.visitVarInsn(55, regNIdx);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitVarInsn(22, regNIdx);
        ctx.mv.visitInsn(136);
        ctx.mv.visitInsn(79);
        Ow2Sh2Bytecode.clearSrFlag(ctx, 1);
        Label endLabel = new Label();
        Label ifLabel = new Label();
        ctx.mv.visitVarInsn(22, temp0Idx);
        ctx.mv.visitInsn(9);
        ctx.mv.visitInsn(148);
        ctx.mv.visitJumpInsn(157, ifLabel);
        ctx.mv.visitVarInsn(22, temp0Idx);
        ctx.mv.visitVarInsn(22, regNIdx);
        ctx.mv.visitInsn(148);
        ctx.mv.visitJumpInsn(156, endLabel);
        ctx.mv.visitLabel(ifLabel);
        Ow2Sh2Bytecode.setSrFlag(ctx, 1);
        ctx.mv.visitLabel(endLabel);
    }

    public static void NOP(Sh2Prefetch.BytecodeContext ctx) {
    }

    public static void NOT(Sh2Prefetch.BytecodeContext ctx) {
        int m = Sh2Impl.RM(ctx.opcode);
        int n = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(2);
        ctx.mv.visitInsn(130);
        ctx.mv.visitInsn(79);
    }

    public static void OR(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.opRegToReg(ctx, 128);
    }

    public static void ORI(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.opReg0Imm(ctx, 128, ctx.opcode >> 0 & 0xFF);
    }

    public static void ORM(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.opReg0Mem(ctx, 128);
    }

    public static final void ROTCL(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.rotateRegWithCarry(ctx, true);
    }

    public static final void ROTCR(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.rotateRegWithCarry(ctx, false);
    }

    public static final void ROTL(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.rotateReg(ctx, true);
    }

    public static final void ROTR(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.rotateReg(ctx, false);
    }

    public static final void RTE(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Helper.sh2PopReg15(ctx);
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.PC.name());
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Helper.sh2PopReg15(ctx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1011);
        ctx.mv.visitInsn(126);
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.SR.name());
        Ow2Sh2Bytecode.subCyclesExt(ctx, ctx.sh2Inst.cycles);
        Ow2Sh2Bytecode.delaySlot(ctx);
    }

    public static final void RTS(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Helper.pushSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.PR.name());
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.PC.name());
        Ow2Sh2Bytecode.subCyclesExt(ctx, ctx.sh2Inst.cycles);
        Ow2Sh2Bytecode.delaySlot(ctx);
    }

    private static void delaySlot(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.delaySlot(ctx, 0);
    }

    private static void delaySlot(Sh2Prefetch.BytecodeContext ctx, int branchPc) {
        assert (ctx.delaySlotCtx != null && ctx.delaySlotCtx.delaySlot && !ctx.delaySlot);
        assert (ctx.drcCtx.sh2Ctx == ctx.delaySlotCtx.drcCtx.sh2Ctx);
        ctx.delaySlotCtx.branchPc = branchPc;
        Ow2Sh2Helper.createInst(ctx.delaySlotCtx);
    }

    public static final void SETT(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.setSrFlag(ctx, 1);
    }

    public static final void SLEEP(Sh2Prefetch.BytecodeContext ctx) {
        LOG.warn("SLEEP");
        System.out.println("SLEEP");
    }

    public static final void STCSR(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.stsToReg(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.SR.name(), 2);
    }

    public static void STCVBR(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.stsToReg(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.VBR.name(), 2);
    }

    public static void STCGBR(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.stsToReg(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.GBR.name(), 2);
    }

    public static final void STCMGBR(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.stsMem(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.GBR.name(), 2);
    }

    public static final void STCMSR(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.stsMem(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.SR.name(), 2);
    }

    public static final void STCMVBR(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.stsMem(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.VBR.name(), 2);
    }

    public static final void STSMMACH(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.stsMem(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACH.name(), 1);
    }

    public static final void STSMMACL(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.stsMem(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACL.name(), 1);
    }

    public static final void STSMPR(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.stsMem(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.PR.name(), 1);
    }

    public static void STSMACH(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.stsToReg(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACH.name(), 1);
    }

    public static void STSMACL(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.stsToReg(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACL.name(), 1);
    }

    public static void STSPR(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.stsToReg(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.PR.name(), 2);
    }

    public static void SUB(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.opRegToReg(ctx, 100);
    }

    public static void SUBC(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.sumWithCarry(ctx, false);
    }

    public static void SUBV(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.sumWithOverflow(ctx, false);
    }

    private static void sumWithOverflow(Sh2Prefetch.BytecodeContext ctx, boolean add) {
        int n = Sh2Impl.RN(ctx.opcode);
        int m = Sh2Impl.RM(ctx.opcode);
        int dIdx = ctx.mv.newLocal(Type.INT_TYPE);
        int sIdx = ctx.mv.newLocal(Type.INT_TYPE);
        int rIdx = ctx.mv.newLocal(Type.INT_TYPE);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 31);
        ctx.mv.visitInsn(122);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitInsn(126);
        ctx.mv.visitVarInsn(54, dIdx);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 31);
        ctx.mv.visitInsn(122);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitInsn(126);
        ctx.mv.visitVarInsn(21, dIdx);
        ctx.mv.visitInsn(96);
        ctx.mv.visitVarInsn(54, sIdx);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(92);
        ctx.mv.visitInsn(46);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(add ? 96 : 100);
        ctx.mv.visitInsn(79);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 31);
        ctx.mv.visitInsn(122);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitInsn(126);
        ctx.mv.visitVarInsn(21, dIdx);
        ctx.mv.visitInsn(96);
        ctx.mv.visitVarInsn(54, rIdx);
        Ow2Sh2Bytecode.clearSrFlag(ctx, 1);
        Ow2Sh2Helper.pushSh2Context(ctx);
        ctx.mv.visitInsn(89);
        Ow2Sh2Helper.pushSR(ctx);
        ctx.mv.visitVarInsn(21, rIdx);
        ctx.mv.visitVarInsn(21, sIdx);
        if (add) {
            Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
            ctx.mv.visitInsn(96);
        }
        ctx.mv.visitInsn(126);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitInsn(126);
        ctx.mv.visitInsn(128);
        Ow2Sh2Helper.popSR(ctx);
    }

    public static final void SHAL(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.shiftArithmetic(ctx, true);
    }

    public static final void SHAR(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.shiftArithmetic(ctx, false);
    }

    public static final void SHLL(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.shiftLogical(ctx, true);
    }

    public static final void SHLR(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.shiftLogical(ctx, false);
    }

    public static void SHLL2(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.shiftConst(ctx, 120, 2);
    }

    public static void SHLL8(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.shiftConst(ctx, 120, 8);
    }

    public static void SHLL16(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.shiftConst(ctx, 120, 16);
    }

    public static void SHLR2(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.shiftConst(ctx, 124, 2);
    }

    public static void SHLR8(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.shiftConst(ctx, 124, 8);
    }

    public static void SHLR16(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.shiftConst(ctx, 124, 16);
    }

    public static void SWAPB(Sh2Prefetch.BytecodeContext ctx) {
        int m = Sh2Impl.RM(ctx.opcode);
        int n = Sh2Impl.RN(ctx.opcode);
        int temp0Idx = ctx.mv.newLocal(Type.INT_TYPE);
        int temp1Idx = ctx.mv.newLocal(Type.INT_TYPE);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitPushConstToStack(ctx, -65536);
        ctx.mv.visitInsn(126);
        ctx.mv.visitVarInsn(54, temp0Idx);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 255);
        ctx.mv.visitInsn(126);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 8);
        ctx.mv.visitInsn(120);
        ctx.mv.visitVarInsn(54, temp1Idx);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 65280);
        ctx.mv.visitInsn(126);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 8);
        ctx.mv.visitInsn(122);
        ctx.mv.visitInsn(79);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        ctx.mv.visitVarInsn(21, temp1Idx);
        ctx.mv.visitInsn(128);
        ctx.mv.visitVarInsn(21, temp0Idx);
        ctx.mv.visitInsn(128);
        ctx.mv.visitInsn(79);
    }

    public static void SWAPW(Sh2Prefetch.BytecodeContext ctx) {
        int m = Sh2Impl.RM(ctx.opcode);
        int n = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 16);
        ctx.mv.visitInsn(120);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 16);
        ctx.mv.visitInsn(124);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 65535);
        ctx.mv.visitInsn(126);
        ctx.mv.visitInsn(128);
        ctx.mv.visitInsn(79);
    }

    public static void TAS(Sh2Prefetch.BytecodeContext ctx) {
        int n = Sh2Impl.RN(ctx.opcode);
        int valIdx = ctx.mv.newLocal(Type.INT_TYPE);
        Ow2Sh2Helper.pushMemory(ctx);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 0x20000000);
        ctx.mv.visitInsn(128);
        Ow2Sh2Bytecode.readMem(ctx, Size.BYTE);
        ctx.mv.visitInsn(89);
        ctx.mv.visitVarInsn(54, valIdx);
        Ow2Sh2Bytecode.cmpInternal(ctx, 154);
        Ow2Sh2Helper.pushMemory(ctx);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        ctx.mv.visitVarInsn(21, valIdx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 128);
        ctx.mv.visitInsn(128);
        ctx.mv.visitInsn(145);
        Ow2Sh2Bytecode.writeMem(ctx, Size.BYTE);
    }

    public static void TRAPA(Sh2Prefetch.BytecodeContext ctx) {
        int imm = 0xFF & ctx.opcode;
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Helper.pushSR(ctx);
        Ow2Sh2Helper.sh2PushReg15(ctx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, ctx.pc + 2);
        Ow2Sh2Helper.sh2PushReg15(ctx);
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Helper.pushMemory(ctx);
        Ow2Sh2Helper.pushSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.VBR.name());
        Ow2Sh2Helper.emitPushConstToStack(ctx, imm << 2);
        ctx.mv.visitInsn(96);
        Ow2Sh2Bytecode.readMem(ctx, Size.LONG);
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.PC.name());
    }

    public static void TST(Sh2Prefetch.BytecodeContext ctx) {
        int m = Sh2Impl.RM(ctx.opcode);
        int n = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(126);
        Ow2Sh2Bytecode.cmpInternal(ctx, 154);
    }

    public static void TSTI(Sh2Prefetch.BytecodeContext ctx) {
        int i = ctx.opcode >> 0 & 0xFF;
        Ow2Sh2Bytecode.pushRegStack(ctx, 0);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitPushConstToStack(ctx, i);
        ctx.mv.visitInsn(126);
        Ow2Sh2Bytecode.cmpInternal(ctx, 154);
    }

    public static void TSTM(Sh2Prefetch.BytecodeContext ctx) {
        int i = ctx.opcode >> 0 & 0xFF;
        Ow2Sh2Helper.pushMemory(ctx);
        Ow2Sh2Helper.pushSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.GBR.name());
        Ow2Sh2Bytecode.pushRegStack(ctx, 0);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(96);
        Ow2Sh2Bytecode.readMem(ctx, Size.BYTE);
        Ow2Sh2Helper.emitPushConstToStack(ctx, i);
        ctx.mv.visitInsn(126);
        Ow2Sh2Bytecode.cmpInternal(ctx, 154);
    }

    public static void XOR(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.opRegToReg(ctx, 130);
    }

    public static void XORI(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.opReg0Imm(ctx, 130, ctx.opcode >> 0 & 0xFF);
    }

    public static void XORM(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Bytecode.opReg0Mem(ctx, 130);
    }

    public static void XTRCT(Sh2Prefetch.BytecodeContext ctx) {
        int m = Sh2Impl.RM(ctx.opcode);
        int n = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitPushConstToStack(ctx, -65536);
        ctx.mv.visitInsn(126);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 16);
        ctx.mv.visitInsn(124);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 65535);
        ctx.mv.visitInsn(126);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 16);
        ctx.mv.visitInsn(120);
        ctx.mv.visitInsn(128);
        ctx.mv.visitInsn(79);
    }

    public static void fallback(Sh2Prefetch.BytecodeContext ctx) {
        System.out.println("Fallback block: " + Util.th((int)ctx.drcCtx.sh2Ctx.PC) + "," + ctx.sh2Inst);
        if (instSet.add(ctx.sh2Inst.name())) {
            LOG.warn("DRC unimplemented: {},{}", (Object)ctx.sh2Inst, (Object)ctx.opcode);
            System.out.println("DRC unimplemented: " + ctx.sh2Inst + "," + ctx.opcode);
        }
        assert (!ctx.delaySlot);
        Ow2Sh2Bytecode.setContextPc(ctx);
        ctx.mv.visitFieldInsn(178, Type.getInternalName(Sh2Instructions.class), "instOpcodeMap", Type.getDescriptor(Sh2Instructions.Sh2InstructionWrapper[].class));
        ctx.mv.visitLdcInsn((Object)ctx.opcode);
        ctx.mv.visitInsn(50);
        ctx.mv.visitFieldInsn(180, Type.getInternalName(Sh2Instructions.Sh2InstructionWrapper.class), "runnable", Type.getDescriptor(Runnable.class));
        ctx.mv.visitMethodInsn(185, Type.getInternalName(Runnable.class), "run", "()V");
    }

    public static void shiftConst(Sh2Prefetch.BytecodeContext ctx, int shiftBytecode, int shift) {
        int n = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(92);
        ctx.mv.visitInsn(46);
        switch (shift) {
            case 2: {
                ctx.mv.visitInsn(5);
                break;
            }
            case 8: {
                ctx.mv.visitIntInsn(16, 8);
                break;
            }
            case 16: {
                ctx.mv.visitIntInsn(16, 16);
            }
        }
        ctx.mv.visitInsn(shiftBytecode);
        ctx.mv.visitInsn(79);
    }

    public static void opRegToReg(Sh2Prefetch.BytecodeContext ctx, int opBytecode) {
        int m = Sh2Impl.RM(ctx.opcode);
        int n = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(92);
        ctx.mv.visitInsn(46);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(opBytecode);
        ctx.mv.visitInsn(79);
    }

    public static void opReg0Imm(Sh2Prefetch.BytecodeContext ctx, int opBytecode, int i) {
        Ow2Sh2Bytecode.opRegImm(ctx, opBytecode, 0, i);
    }

    public static void opRegImm(Sh2Prefetch.BytecodeContext ctx, int opBytecode, int reg, int i) {
        Ow2Sh2Bytecode.pushRegStack(ctx, reg);
        ctx.mv.visitInsn(92);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitPushConstToStack(ctx, i);
        ctx.mv.visitInsn(opBytecode);
        ctx.mv.visitInsn(79);
    }

    public static void opReg0Mem(Sh2Prefetch.BytecodeContext ctx, int opBytecode) {
        byte i = (byte)(ctx.opcode >> 0 & 0xFF);
        int memValIdx = ctx.mv.newLocal(Type.INT_TYPE);
        int memAddrIdx = ctx.mv.newLocal(Type.INT_TYPE);
        Ow2Sh2Helper.pushSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.GBR.name());
        Ow2Sh2Bytecode.pushRegStack(ctx, 0);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(96);
        ctx.mv.visitVarInsn(54, memAddrIdx);
        Ow2Sh2Helper.pushMemory(ctx);
        ctx.mv.visitVarInsn(21, memAddrIdx);
        Ow2Sh2Bytecode.readMem(ctx, Size.BYTE);
        Ow2Sh2Helper.emitCastIntToSize(ctx, Size.BYTE);
        ctx.mv.visitVarInsn(54, memValIdx);
        Ow2Sh2Helper.pushMemory(ctx);
        ctx.mv.visitVarInsn(21, memAddrIdx);
        ctx.mv.visitVarInsn(21, memValIdx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, i);
        ctx.mv.visitInsn(opBytecode);
        Ow2Sh2Bytecode.writeMem(ctx, Size.BYTE);
    }

    public static void stsToReg(Sh2Prefetch.BytecodeContext ctx, String source, int cycles) {
        Ow2Sh2Bytecode.pushRegStack(ctx, Sh2Impl.RN(ctx.opcode));
        Ow2Sh2Helper.pushSh2ContextIntField(ctx, source);
        ctx.mv.visitInsn(79);
    }

    public static void stsMem(Sh2Prefetch.BytecodeContext ctx, String source, int cycles) {
        int n = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Bytecode.decReg(ctx, n, 4);
        Ow2Sh2Helper.pushMemory(ctx);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.pushSh2ContextIntField(ctx, source);
        Ow2Sh2Bytecode.writeMem(ctx, Size.LONG);
    }

    public static void ldcReg(Sh2Prefetch.BytecodeContext ctx, String dest, int mask, int cycles) {
        Ow2Sh2Helper.pushSh2Context(ctx);
        int m = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        if (mask > 0) {
            Ow2Sh2Helper.emitPushConstToStack(ctx, 1011);
            ctx.mv.visitInsn(126);
        }
        Ow2Sh2Helper.popSh2ContextIntField(ctx, dest);
    }

    public static void ldcmReg(Sh2Prefetch.BytecodeContext ctx, String src, int mask, int cycles) {
        int m = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Helper.pushMemory(ctx);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        Ow2Sh2Bytecode.readMem(ctx, Size.LONG);
        if (mask > 0) {
            Ow2Sh2Helper.emitPushConstToStack(ctx, mask);
            ctx.mv.visitInsn(126);
        }
        Ow2Sh2Helper.popSh2ContextIntField(ctx, src);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(92);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(7);
        ctx.mv.visitInsn(96);
        ctx.mv.visitInsn(79);
    }

    public static void rotateReg(Sh2Prefetch.BytecodeContext ctx, boolean left) {
        int n = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Bytecode.clearSrFlag(ctx, 1, false);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        if (left) {
            Ow2Sh2Helper.emitPushConstToStack(ctx, 31);
            ctx.mv.visitInsn(124);
        }
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitInsn(126);
        ctx.mv.visitInsn(128);
        Ow2Sh2Helper.popSR(ctx);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitInsn(left ? 120 : 124);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 31);
        ctx.mv.visitInsn(left ? 124 : 120);
        ctx.mv.visitInsn(128);
        ctx.mv.visitInsn(79);
    }

    public static void rotateRegWithCarry(Sh2Prefetch.BytecodeContext ctx, boolean left) {
        int n = Sh2Impl.RN(ctx.opcode);
        int highLowBit = ctx.mv.newLocal(Type.INT_TYPE);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        if (left) {
            Ow2Sh2Helper.emitPushConstToStack(ctx, 31);
            ctx.mv.visitInsn(124);
        }
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitInsn(126);
        ctx.mv.visitVarInsn(54, highLowBit);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitInsn(left ? 120 : 124);
        Ow2Sh2Helper.pushSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.SR.name());
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitInsn(126);
        if (!left) {
            Ow2Sh2Helper.emitPushConstToStack(ctx, 31);
            ctx.mv.visitInsn(120);
        }
        ctx.mv.visitInsn(128);
        ctx.mv.visitInsn(79);
        Ow2Sh2Bytecode.clearSrFlag(ctx, 1, false);
        ctx.mv.visitVarInsn(21, highLowBit);
        ctx.mv.visitInsn(128);
        Ow2Sh2Helper.popSR(ctx);
    }

    public static void shiftArithmetic(Sh2Prefetch.BytecodeContext ctx, boolean left) {
        int n = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Bytecode.clearSrFlag(ctx, 1, false);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        if (left) {
            Ow2Sh2Helper.emitPushConstToStack(ctx, 31);
            ctx.mv.visitInsn(124);
        }
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitInsn(126);
        ctx.mv.visitInsn(128);
        Ow2Sh2Helper.popSR(ctx);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitInsn(left ? 120 : 122);
        ctx.mv.visitInsn(79);
    }

    public static void shiftLogical(Sh2Prefetch.BytecodeContext ctx, boolean left) {
        int n = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Helper.pushSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.SR.name());
        Ow2Sh2Helper.emitPushConstToStack(ctx, -2);
        ctx.mv.visitInsn(126);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        if (left) {
            Ow2Sh2Helper.emitPushConstToStack(ctx, 31);
            ctx.mv.visitInsn(124);
        }
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitInsn(126);
        ctx.mv.visitInsn(128);
        Ow2Sh2Helper.popSR(ctx);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(92);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 1);
        ctx.mv.visitInsn(left ? 120 : 124);
        ctx.mv.visitInsn(79);
    }

    public static void extSigned(Sh2Prefetch.BytecodeContext ctx, Size size) {
        assert (size != Size.LONG);
        int m = Sh2Impl.RM(ctx.opcode);
        int n = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitCastIntToSize(ctx, size);
        ctx.mv.visitInsn(79);
    }

    public static void extUnsigned(Sh2Prefetch.BytecodeContext ctx, Size size) {
        int m = Sh2Impl.RM(ctx.opcode);
        int n = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        ctx.mv.visitLdcInsn((Object)size.getMask());
        ctx.mv.visitInsn(126);
        ctx.mv.visitInsn(79);
    }

    public static void movMemToReg(Sh2Prefetch.BytecodeContext ctx, Size size) {
        int m = Sh2Impl.RM(ctx.opcode);
        int n = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        Ow2Sh2Helper.pushMemory(ctx);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        Ow2Sh2Bytecode.readMem(ctx, size);
        Ow2Sh2Helper.emitCastIntToSize(ctx, size);
        ctx.mv.visitInsn(79);
    }

    public static void movMemToRegShift(Sh2Prefetch.BytecodeContext ctx, Size size) {
        int d = ctx.opcode >> 0 & 0xF;
        int n = size == Size.LONG ? Sh2Impl.RN(ctx.opcode) : 0;
        int m = Sh2Impl.RM(ctx.opcode);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        Ow2Sh2Helper.pushMemory(ctx);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitPushConstToStack(ctx, d << size.ordinal());
        ctx.mv.visitInsn(96);
        Ow2Sh2Bytecode.readMem(ctx, size);
        Ow2Sh2Helper.emitCastIntToSize(ctx, size);
        ctx.mv.visitInsn(79);
    }

    public static void movRegToReg(Sh2Prefetch.BytecodeContext ctx, Size size) {
        int m = Sh2Impl.RM(ctx.opcode);
        int n = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Helper.pushMemory(ctx);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        Ow2Sh2Bytecode.writeMem(ctx, size);
    }

    public static void movRegToRegShift(Sh2Prefetch.BytecodeContext ctx, Size size) {
        int d = ctx.opcode >> 0 & 0xF;
        int n = size == Size.LONG ? Sh2Impl.RN(ctx.opcode) : Sh2Impl.RM(ctx.opcode);
        int m = size == Size.LONG ? Sh2Impl.RM(ctx.opcode) : 0;
        Ow2Sh2Helper.pushMemory(ctx);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitPushConstToStack(ctx, d << size.ordinal());
        ctx.mv.visitInsn(96);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        Ow2Sh2Bytecode.writeMem(ctx, size);
    }

    public static void movRegToMemWithReg0Shift(Sh2Prefetch.BytecodeContext ctx, Size size) {
        int m = Sh2Impl.RM(ctx.opcode);
        int n = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Helper.pushMemory(ctx);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        Ow2Sh2Bytecode.pushRegStack(ctx, 0);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(96);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitCastIntToSize(ctx, size);
        Ow2Sh2Bytecode.writeMem(ctx, size);
    }

    public static void movMemWithReg0ShiftToReg(Sh2Prefetch.BytecodeContext ctx, Size size) {
        int m = Sh2Impl.RM(ctx.opcode);
        int n = Sh2Impl.RN(ctx.opcode);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        Ow2Sh2Helper.pushMemory(ctx);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        Ow2Sh2Bytecode.pushRegStack(ctx, 0);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(96);
        Ow2Sh2Bytecode.readMem(ctx, size);
        Ow2Sh2Helper.emitCastIntToSize(ctx, size);
        ctx.mv.visitInsn(79);
    }

    public static void movMemWithPcOffsetToReg(Sh2Prefetch.BytecodeContext ctx, Size size) {
        assert (size != Size.BYTE);
        int d = ctx.opcode & 0xFF;
        int n = ctx.opcode >> 8 & 0xF;
        int pcBase = ctx.pc + 4;
        if (ctx.delaySlot) {
            assert (ctx.branchPc != 0);
            pcBase = ctx.branchPc + 2;
        }
        int memAddr = size == Size.WORD ? pcBase + (d << 1) : (pcBase & 0xFFFFFFFC) + (d << 2);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        Ow2Sh2Helper.pushMemory(ctx);
        Ow2Sh2Helper.emitPushConstToStack(ctx, memAddr);
        Ow2Sh2Bytecode.readMem(ctx, size);
        Ow2Sh2Helper.emitCastIntToSize(ctx, size);
        ctx.mv.visitInsn(79);
    }

    public static void movRegPredecToMem(Sh2Prefetch.BytecodeContext ctx, Size size) {
        int m = Sh2Impl.RM(ctx.opcode);
        int n = Sh2Impl.RN(ctx.opcode);
        int predecVal = size.getByteSize();
        Ow2Sh2Bytecode.decReg(ctx, n, predecVal);
        Ow2Sh2Helper.pushMemory(ctx);
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        ctx.mv.visitInsn(46);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        Ow2Sh2Bytecode.writeMem(ctx, size);
    }

    public static void movMemToRegPostInc(Sh2Prefetch.BytecodeContext ctx, Size size) {
        int m = Sh2Impl.RM(ctx.opcode);
        int n = Sh2Impl.RN(ctx.opcode);
        int postIncVal = size.getByteSize();
        Ow2Sh2Bytecode.pushRegStack(ctx, n);
        Ow2Sh2Helper.pushMemory(ctx);
        Ow2Sh2Bytecode.pushRegStack(ctx, m);
        ctx.mv.visitInsn(46);
        Ow2Sh2Bytecode.readMem(ctx, size);
        Ow2Sh2Helper.emitCastIntToSize(ctx, size);
        ctx.mv.visitInsn(79);
        if (n != m) {
            Ow2Sh2Bytecode.pushRegStack(ctx, m);
            ctx.mv.visitInsn(92);
            ctx.mv.visitInsn(46);
            Ow2Sh2Helper.emitPushConstToStack(ctx, postIncVal);
            ctx.mv.visitInsn(96);
            ctx.mv.visitInsn(79);
        }
    }

    public static void movMemWithGBRShiftToReg0(Sh2Prefetch.BytecodeContext ctx, Size size) {
        int d = ctx.opcode >> 0 & 0xFF;
        int addVal = d << size.ordinal();
        Ow2Sh2Bytecode.pushRegStack(ctx, 0);
        Ow2Sh2Helper.pushMemory(ctx);
        Ow2Sh2Helper.pushSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.GBR.name());
        Ow2Sh2Helper.emitPushConstToStack(ctx, addVal);
        ctx.mv.visitInsn(96);
        Ow2Sh2Bytecode.readMem(ctx, size);
        Ow2Sh2Helper.emitCastIntToSize(ctx, size);
        ctx.mv.visitInsn(79);
    }

    public static void movGBRShiftToReg0(Sh2Prefetch.BytecodeContext ctx, Size size) {
        int v = size.ordinal();
        int gbrOffset = (ctx.opcode & 0xFF) << v;
        Ow2Sh2Helper.pushMemory(ctx);
        Ow2Sh2Helper.pushSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.GBR.name());
        Ow2Sh2Helper.emitPushConstToStack(ctx, gbrOffset);
        ctx.mv.visitInsn(96);
        Ow2Sh2Bytecode.pushRegStack(ctx, 0);
        ctx.mv.visitInsn(46);
        Ow2Sh2Bytecode.writeMem(ctx, size);
    }

    public static void writeMem(Sh2Prefetch.BytecodeContext ctx, Size size) {
        ctx.mv.visitFieldInsn(178, Type.getInternalName(Size.class), size.name(), Type.getDescriptor(Size.class));
        int invoke = Ow2Sh2BlockRecompiler.memoryClass.isInterface() ? 185 : 182;
        ctx.mv.visitMethodInsn(invoke, Type.getInternalName(Sh2BusImpl.class), Ow2Sh2Helper.SH2MEMORY_METHOD.write.name(), Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE, Type.INT_TYPE, Type.getType(Size.class)}));
    }

    public static void readMem(Sh2Prefetch.BytecodeContext ctx, Size size) {
        ctx.mv.visitFieldInsn(178, Type.getInternalName(Size.class), size.name(), Type.getDescriptor(Size.class));
        int invoke = Ow2Sh2BlockRecompiler.memoryClass.isInterface() ? 185 : 182;
        ctx.mv.visitMethodInsn(invoke, Type.getInternalName(Sh2BusImpl.class), Ow2Sh2Helper.SH2MEMORY_METHOD.read.name(), Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.INT_TYPE, Type.getType(Size.class)}));
    }

    public static void decReg(Sh2Prefetch.BytecodeContext ctx, int reg, int val) {
        Ow2Sh2Bytecode.pushRegStack(ctx, reg);
        ctx.mv.visitInsn(92);
        ctx.mv.visitInsn(46);
        Ow2Sh2Helper.emitPushConstToStack(ctx, val);
        ctx.mv.visitInsn(100);
        ctx.mv.visitInsn(79);
    }

    public static void pushRegStack(Sh2Prefetch.BytecodeContext ctx, int reg) {
        ctx.mv.visitVarInsn(25, 0);
        ctx.mv.visitFieldInsn(180, ctx.classDesc, Ow2Sh2Helper.DRC_CLASS_FIELD.regs.name(), Ow2Sh2BlockRecompiler.intArrayDesc);
        Ow2Sh2Helper.emitPushConstToStack(ctx, reg);
    }

    public static void storeToReg(Sh2Prefetch.BytecodeContext ctx, int reg, int val, Size size) {
        Ow2Sh2Bytecode.pushRegStack(ctx, reg);
        switch (size) {
            case BYTE: {
                ctx.mv.visitIntInsn(16, val);
                break;
            }
            case WORD: 
            case LONG: {
                ctx.mv.visitLdcInsn((Object)val);
            }
        }
        ctx.mv.visitInsn(79);
    }

    public static void storeToMAC(Sh2Prefetch.BytecodeContext ctx, int varIndex) {
        Ow2Sh2Helper.pushSh2Context(ctx);
        ctx.mv.visitVarInsn(22, varIndex);
        ctx.mv.visitLdcInsn((Object)-1L);
        ctx.mv.visitInsn(127);
        ctx.mv.visitInsn(136);
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACL.name());
        Ow2Sh2Helper.pushSh2Context(ctx);
        ctx.mv.visitVarInsn(22, varIndex);
        Ow2Sh2Helper.emitPushConstToStack(ctx, 32);
        ctx.mv.visitInsn(125);
        ctx.mv.visitLdcInsn((Object)-1L);
        ctx.mv.visitInsn(127);
        ctx.mv.visitInsn(136);
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.MACH.name());
    }

    public static void setContextPc(Sh2Prefetch.BytecodeContext ctx) {
        assert (ctx.pc != 0);
        Ow2Sh2Helper.pushSh2Context(ctx);
        ctx.mv.visitLdcInsn((Object)ctx.pc);
        ctx.mv.visitFieldInsn(181, Type.getInternalName(Sh2Context.class), Ow2Sh2Helper.SH2CTX_CLASS_FIELD.PC.name(), Ow2Sh2BlockRecompiler.intDesc);
    }

    public static void subCyclesExt(Sh2Prefetch.BytecodeContext ctx, int cycles) {
        Ow2Sh2Helper.pushSh2Context(ctx);
        ctx.mv.visitInsn(89);
        ctx.mv.visitFieldInsn(180, Type.getInternalName(Sh2Context.class), Ow2Sh2Helper.SH2CTX_CLASS_FIELD.cycles.name(), Ow2Sh2BlockRecompiler.intDesc);
        Ow2Sh2Helper.emitPushConstToStack(ctx, cycles);
        ctx.mv.visitInsn(100);
        Ow2Sh2Helper.popSh2ContextIntField(ctx, Ow2Sh2Helper.SH2CTX_CLASS_FIELD.cycles.name());
    }

    public static void setPcExt(Sh2Prefetch.BytecodeContext ctx, int pc) {
        Ow2Sh2Helper.pushSh2Context(ctx);
        ctx.mv.visitLdcInsn((Object)pc);
        ctx.mv.visitFieldInsn(181, Type.getInternalName(Sh2Context.class), Ow2Sh2Helper.SH2CTX_CLASS_FIELD.PC.name(), Ow2Sh2BlockRecompiler.intDesc);
    }

    @Deprecated
    public static void deviceStepFor(Sh2Prefetch.BytecodeContext ctx, int limit) {
    }

    @Deprecated
    private static void deviceStep(Sh2Prefetch.BytecodeContext ctx) {
    }
}

