/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2.drc;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.StringJoiner;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.Sh2MMREG;
import s32x.sh2.Sh2;
import s32x.sh2.Sh2Context;
import s32x.sh2.drc.Ow2DrcOptimizer;
import s32x.sh2.drc.Ow2Sh2BlockRecompiler;
import s32x.sh2.prefetch.Sh2Prefetch;
import s32x.sh2.prefetch.Sh2Prefetcher;
import s32x.util.Md32xRuntimeData;
import s32x.util.S32xUtil;

public class Sh2Block {
    private static final Logger LOG = LogHelper.getLogger((String)Sh2Block.class.getSimpleName());
    private static final int OPT_THRESHOLD2 = Integer.parseInt(System.getProperty("helios.32x.sh2.drc.stage2.hits", "31"));
    public static final Sh2Block INVALID_BLOCK = new Sh2Block(-1, S32xUtil.CpuDeviceAccess.MASTER);
    public static final int SH2_DRC_MAX_BLOCK_LEN_BYTES = Integer.parseInt(System.getProperty("helios.32x.sh2.drc.maxBlockLen", "32"));
    public static final int MAX_INST_LEN = SH2_DRC_MAX_BLOCK_LEN_BYTES >> 1;
    public static final int CPU_FLAG = 1;
    public static final int CACHE_FETCH_FLAG = 2;
    public static final int NO_JUMP_FLAG = 4;
    public static final int VALID_FLAG = 8;
    public Sh2Prefetcher.Sh2BlockUnit[] inst;
    public Sh2Prefetcher.Sh2BlockUnit curr;
    public int[] prefetchWords;
    public int prefetchPc;
    public int hits;
    public int start;
    public int end;
    public int pcMasked;
    public int prefetchLenWords;
    public int fetchMemAccessDelay;
    public int cyclesConsumed;
    public ByteBuffer fetchBuffer;
    public Sh2Block nextBlock = INVALID_BLOCK;
    public Sh2Prefetch.Sh2DrcContext drcContext;
    public Ow2DrcOptimizer.PollerCtx poller = Ow2DrcOptimizer.UNKNOWN_POLLER;
    public int blockFlags;
    public Ow2DrcOptimizer.PollType pollType = Ow2DrcOptimizer.PollType.UNKNOWN;
    public Runnable stage2Drc;
    public int hashCodeWords;
    private static final boolean verbose = false;

    public Sh2Block(int pc, S32xUtil.CpuDeviceAccess cpu) {
        this.prefetchPc = pc;
        this.blockFlags = cpu.ordinal() | 8;
    }

    public final void runBlock(Sh2 sh2, Sh2MMREG sm) {
        assert (this.prefetchPc != -1);
        assert ((this.blockFlags & 8) > 0);
        if (this.stage2Drc != null) {
            this.stage2Drc.run();
            return;
        }
        this.runInterpreter(sh2, sm, this.drcContext.sh2Ctx);
    }

    protected final void runInterpreter(Sh2 sh2, Sh2MMREG sm, Sh2Context ctx) {
        Sh2Prefetcher.Sh2BlockUnit prev = this.curr;
        this.addHit();
        int startCycle = ctx.cycles;
        while (true) {
            sh2.printDebugMaybe(this.curr.opcode);
            this.curr.runnable.run();
            if (this.curr.inst.isBranchDelaySlot || this.curr.next == null) break;
            this.curr = this.curr.next;
        }
        this.cyclesConsumed = startCycle - ctx.cycles + Md32xRuntimeData.getCpuDelayExt();
        this.curr = prev;
    }

    public void addHit() {
        ++this.hits;
        if (this.stage2Drc == null && (this.hits + 1 & OPT_THRESHOLD2) == 0) {
            assert (this.inst != null);
            this.stage2();
            if (Sh2.Sh2Config.get().pollDetectEn) {
                Ow2DrcOptimizer.pollDetector(this);
            }
        }
    }

    public void stage1(Sh2Prefetcher.Sh2BlockUnit[] ic) {
        assert (this.inst == null);
        this.inst = ic;
        this.inst[0].next = this.inst.length > 1 ? this.inst[1] : null;
        this.inst[0].pc = this.prefetchPc;
        int lastIdx = ic.length - 1;
        for (int i = 1; i < this.inst.length - 1; ++i) {
            this.inst[i].next = this.inst[i + 1];
            this.inst[i].pc = this.prefetchPc + (i << 1);
            assert (!this.inst[i].inst.isBranch || this.inst[i].inst.isBranchDelaySlot);
        }
        Sh2Prefetcher.Sh2BlockUnit sbu = this.inst[lastIdx];
        sbu.pc = this.prefetchPc + (lastIdx << 1);
        this.curr = this.inst[0];
        assert (sbu.pc != 0);
        assert (this.inst.length >= MAX_INST_LEN - 1 || sbu.inst.isBranch || this.inst[Math.max((int)0, (int)(lastIdx - 1))].inst.isBranchDelaySlot && !sbu.inst.isBranch || sbu.inst.isIllegal) : Util.th((int)sbu.pc) + "," + this.inst.length + "\n" + this;
    }

    public void stage2() {
        if (Sh2.Sh2Config.get().drcEn) {
            assert (this.drcContext != null);
            this.stage2Drc = Ow2Sh2BlockRecompiler.getInstance().createDrcClass(this, this.drcContext);
        }
    }

    public boolean isPollingBlock() {
        return this.pollType.ordinal() > Ow2DrcOptimizer.PollType.NONE.ordinal();
    }

    public void setCacheFetch(boolean val) {
        this.setFlag(2, val);
    }

    public void setNoJump(boolean val) {
        this.setFlag(4, val);
    }

    public boolean isValid() {
        return (this.blockFlags & 8) > 0;
    }

    private void setFlag(int flag, boolean val) {
        this.blockFlags &= ~flag;
        this.blockFlags |= val ? flag : 0;
    }

    public boolean isNoJump() {
        return (this.blockFlags & 4) > 0;
    }

    public boolean isCacheFetch() {
        return (this.blockFlags & 2) > 0;
    }

    public void invalidate() {
        this.blockFlags &= 0xFFFFFFF7;
        this.prefetchPc |= 1;
    }

    public void setValid() {
        this.blockFlags |= 8;
        this.prefetchPc &= 0xFFFFFFFE;
    }

    public S32xUtil.CpuDeviceAccess getCpu() {
        return S32xUtil.CpuDeviceAccess.cdaValues[this.blockFlags & 1];
    }

    public String toString() {
        return new StringJoiner(", ", Sh2Block.class.getSimpleName() + "[", "]").add("inst=" + Arrays.toString(this.inst)).add("curr=" + this.curr).add("prefetchWords=" + Arrays.toString(this.prefetchWords)).add("prefetchPc=" + Util.th((int)this.prefetchPc)).add("hits=" + this.hits).add("start=" + Util.th((int)this.start)).add("end=" + Util.th((int)this.end)).add("pcMasked=" + Util.th((int)this.pcMasked)).add("prefetchLenWords=" + this.prefetchLenWords).add("fetchMemAccessDelay=" + this.fetchMemAccessDelay).add("cyclesConsumed=" + this.cyclesConsumed).add("fetchBuffer=" + this.fetchBuffer).add("drcContext=" + this.drcContext).add("blockFlags=" + this.blockFlags).add("pollType=" + this.pollType).add("stage2Drc=" + this.stage2Drc).toString();
    }

    static {
        S32xUtil.assertPowerOf2Minus1("OPT_THRESHOLD2", OPT_THRESHOLD2);
        INVALID_BLOCK.setFlag(8, false);
    }
}

