/*
 * Decompiled with CFR 0.152.
 */
package s32x.util;

import java.nio.ByteBuffer;
import java.nio.file.Path;
import omegadrive.util.FileUtil;
import omegadrive.util.Size;
import omegadrive.util.Util;
import s32x.util.S32xUtil;

public class BiosHolder {
    private static final byte[] EMPTY = new byte[1];
    public static final BiosHolder NO_BIOS = new BiosHolder(new BiosData[]{new BiosData(EMPTY), new BiosData(EMPTY), new BiosData(EMPTY)});
    private BiosData[] biosData = new BiosData[S32xUtil.CpuDeviceAccess.values().length];
    private Path sh2m;
    private Path sh2s;
    private Path m68k;

    public BiosHolder(Path sh2m, Path sh2s, Path m68k) {
        this.sh2m = sh2m;
        this.sh2s = sh2s;
        this.m68k = m68k;
        this.init();
    }

    public BiosHolder(BiosData[] biosData) {
        this.biosData = biosData;
    }

    private void init() {
        assert (this.sh2m.toFile().exists());
        assert (this.sh2s.toFile().exists());
        assert (this.m68k.toFile().exists());
        this.biosData[S32xUtil.CpuDeviceAccess.MASTER.ordinal()] = new BiosData(FileUtil.readFileSafe((Path)this.sh2m));
        this.biosData[S32xUtil.CpuDeviceAccess.SLAVE.ordinal()] = new BiosData(FileUtil.readFileSafe((Path)this.sh2s));
        this.biosData[S32xUtil.CpuDeviceAccess.M68K.ordinal()] = new BiosData(FileUtil.readFileSafe((Path)this.m68k));
        assert (this.biosData[S32xUtil.CpuDeviceAccess.MASTER.ordinal()].buffer.capacity() > 0);
        assert (this.biosData[S32xUtil.CpuDeviceAccess.SLAVE.ordinal()].buffer.capacity() > 0);
        assert (this.biosData[S32xUtil.CpuDeviceAccess.M68K.ordinal()].buffer.capacity() > 0);
    }

    public BiosData getBiosData(S32xUtil.CpuDeviceAccess type) {
        return this.biosData[type.ordinal()];
    }

    public static class BiosData {
        public ByteBuffer buffer;
        public int rawSize;
        public int padMask;

        public BiosData(byte[] b) {
            this.rawSize = b.length;
            this.padMask = Util.getRomMask((int)this.rawSize);
            this.buffer = ByteBuffer.wrap(b);
        }

        public int readBuffer(int address, Size size) {
            return S32xUtil.readBuffer(this.buffer, address & this.padMask, size);
        }
    }
}

