/*
 * Decompiled with CFR 0.152.
 */
package s32x.util;

import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import omegadrive.Device;
import omegadrive.util.LogHelper;
import omegadrive.util.RomHolder;
import org.slf4j.Logger;
import s32x.DmaFifo68k;
import s32x.Md32x;
import s32x.S32XMMREG;
import s32x.bus.S32xBus;
import s32x.bus.Sh2Bus;
import s32x.bus.Sh2BusImpl;
import s32x.bus.Sh2MemoryParallel;
import s32x.pwm.Pwm;
import s32x.sh2.Sh2;
import s32x.sh2.Sh2Context;
import s32x.sh2.Sh2Debug;
import s32x.sh2.Sh2Impl;
import s32x.sh2.device.Sh2DeviceHelper;
import s32x.sh2.prefetch.Sh2Prefetch;
import s32x.util.BiosHolder;
import s32x.util.S32xUtil;
import s32x.vdp.MarsVdp;

public class MarsLauncherHelper {
    private static final Logger LOG = LogHelper.getLogger((String)MarsLauncherHelper.class.getSimpleName());
    static final boolean masterDebug = Boolean.parseBoolean(System.getProperty("sh2.master.debug", "false"));
    static final boolean slaveDebug = Boolean.parseBoolean(System.getProperty("sh2.slave.debug", "false"));
    static final boolean homebrewBios = Boolean.parseBoolean(System.getProperty("32x.use.homebrew.bios", "true"));
    static String biosBasePath = "res/bios/";
    static String masterBiosName = "32x_bios_m.bin";
    static String slaveBiosName = "32x_bios_s.bin";
    static String mdBiosName = "32x_bios_g.bin";
    static String hb_masterBiosName = "32x_hbrew_bios_m.bin";
    static String hb_slaveBiosName = "32x_hbrew_bios_s.bin";
    static String hb_mdBiosName = "32x_hbrew_bios_g.bin";

    public static BiosHolder initBios() {
        BiosHolder bh = MarsLauncherHelper.doInit(homebrewBios);
        if (bh == BiosHolder.NO_BIOS && !homebrewBios) {
            System.out.println("Unable to find official bios files, attempting to use homebrew bios");
            bh = MarsLauncherHelper.doInit(true);
        }
        if (bh == BiosHolder.NO_BIOS) {
            LOG.error("Unable to find bios files");
            System.err.println("Unable to find bios files");
        }
        return bh;
    }

    private static BiosHolder doInit(boolean isHb) {
        BiosHolder biosHolder;
        block3: {
            if (isHb) {
                LOG.info("Using homebrew bios: {}, {}, {}", new Object[]{hb_masterBiosName, hb_slaveBiosName, hb_mdBiosName});
                masterBiosName = hb_masterBiosName;
                slaveBiosName = hb_slaveBiosName;
                mdBiosName = hb_mdBiosName;
            }
            biosHolder = BiosHolder.NO_BIOS;
            try {
                Path biosMasterPath = Paths.get(biosBasePath, masterBiosName);
                Path biosSlavePath = Paths.get(biosBasePath, slaveBiosName);
                Path biosM68kPath = Paths.get(biosBasePath, mdBiosName);
                biosHolder = new BiosHolder(biosMasterPath, biosSlavePath, biosM68kPath);
            }
            catch (Error | Exception e) {
                biosHolder = BiosHolder.NO_BIOS;
                if (!isHb) break block3;
                e.printStackTrace();
            }
        }
        return biosHolder;
    }

    public static Sh2LaunchContext setupRom(S32xBus bus, RomHolder romHolder) {
        return MarsLauncherHelper.setupRom(bus, romHolder, MarsLauncherHelper.initBios());
    }

    public static Sh2LaunchContext setupRom(S32xBus bus, RomHolder romHolder, BiosHolder biosHolder) {
        Sh2LaunchContext ctx = new Sh2LaunchContext();
        ctx.masterCtx = new Sh2Context(S32xUtil.CpuDeviceAccess.MASTER, masterDebug);
        ctx.slaveCtx = new Sh2Context(S32xUtil.CpuDeviceAccess.SLAVE, slaveDebug);
        ctx.biosHolder = biosHolder;
        ctx.bus = bus;
        ctx.rom = ByteBuffer.wrap(romHolder.data);
        ctx.s32XMMREG = new S32XMMREG();
        ctx.dmaFifo68k = new DmaFifo68k(ctx.s32XMMREG.regContext);
        Sh2Prefetch.Sh2DrcContext mDrcCtx = new Sh2Prefetch.Sh2DrcContext();
        Sh2Prefetch.Sh2DrcContext sDrcCtx = new Sh2Prefetch.Sh2DrcContext();
        mDrcCtx.sh2Ctx = ctx.masterCtx;
        sDrcCtx.sh2Ctx = ctx.slaveCtx;
        mDrcCtx.cpu = ctx.masterCtx.cpuAccess;
        sDrcCtx.cpu = ctx.slaveCtx.cpuAccess;
        Sh2BusImpl memory = new Sh2BusImpl(ctx.s32XMMREG, ctx.rom, biosHolder, bus, mDrcCtx, sDrcCtx);
        ctx.memory = Md32x.SH2_DEBUG_DRC ? new Sh2MemoryParallel(memory) : memory;
        ctx.mDevCtx = Sh2DeviceHelper.createDevices(S32xUtil.CpuDeviceAccess.MASTER, ctx);
        ctx.sDevCtx = Sh2DeviceHelper.createDevices(S32xUtil.CpuDeviceAccess.SLAVE, ctx);
        ctx.mDevCtx.sci.setOther(ctx.sDevCtx.sci);
        ctx.sh2 = ctx.masterCtx.debug || ctx.slaveCtx.debug ? new Sh2Debug(ctx.memory) : new Sh2Impl(ctx.memory);
        mDrcCtx.sh2 = sDrcCtx.sh2 = (Sh2Impl)ctx.sh2;
        mDrcCtx.memory = sDrcCtx.memory = ctx.memory;
        ctx.pwm = new Pwm(ctx.s32XMMREG.regContext);
        ctx.masterCtx.devices = ctx.mDevCtx;
        ctx.slaveCtx.devices = ctx.sDevCtx;
        ctx.initContext();
        return ctx;
    }

    public static class Sh2LaunchContext {
        public Sh2Context masterCtx;
        public Sh2Context slaveCtx;
        public Sh2DeviceHelper.Sh2DeviceContext mDevCtx;
        public Sh2DeviceHelper.Sh2DeviceContext sDevCtx;
        public S32xBus bus;
        public BiosHolder biosHolder;
        public Sh2Bus memory;
        public Sh2 sh2;
        public DmaFifo68k dmaFifo68k;
        public S32XMMREG s32XMMREG;
        public ByteBuffer rom;
        public MarsVdp marsVdp;
        public Pwm pwm;

        public void initContext() {
            this.bus.attachDevice(this.sh2).attachDevice((Device)this.s32XMMREG);
            this.memory.getSh2MMREGS(S32xUtil.CpuDeviceAccess.MASTER).init(this.mDevCtx);
            this.memory.getSh2MMREGS(S32xUtil.CpuDeviceAccess.SLAVE).init(this.sDevCtx);
            this.s32XMMREG.setInterruptControl(this.mDevCtx.intC, this.sDevCtx.intC);
            this.s32XMMREG.setDmaControl(this.dmaFifo68k);
            this.s32XMMREG.setPwm(this.pwm);
            this.pwm.setIntControls(this.mDevCtx.intC, this.sDevCtx.intC);
            this.pwm.setDmac(this.mDevCtx.dmaC, this.sDevCtx.dmaC);
            this.dmaFifo68k.setDmac(this.mDevCtx.dmaC, this.sDevCtx.dmaC);
            this.bus.setBios68k(this.biosHolder.getBiosData(S32xUtil.CpuDeviceAccess.M68K));
            this.bus.setRom(this.rom);
            this.bus.masterCtx = this.masterCtx;
            this.bus.slaveCtx = this.slaveCtx;
            this.sh2.reset(this.masterCtx);
            this.sh2.reset(this.slaveCtx);
            this.marsVdp = this.bus.getMarsVdp();
        }
    }
}

