/*
 * Decompiled with CFR 0.152.
 */
package s32x.util;

import omegadrive.util.LogHelper;
import org.slf4j.Logger;
import s32x.Md32x;
import s32x.sh2.Sh2;
import s32x.util.S32xUtil;

public class Md32xRuntimeData {
    private static final Logger LOG = LogHelper.getLogger((String)Md32x.class.getSimpleName());
    private S32xUtil.CpuDeviceAccess accessType = S32xUtil.CpuDeviceAccess.MASTER;
    private int accType = this.accessType.ordinal();
    private final int[] cpuDelay = new int[S32xUtil.CpuDeviceAccess.cdaValues.length];
    private final boolean ignoreDelays;
    private static Md32xRuntimeData rt;

    private Md32xRuntimeData() {
        this.ignoreDelays = Sh2.Sh2Config.get().ignoreDelays;
    }

    public static Md32xRuntimeData newInstance() {
        Md32xRuntimeData mrt;
        if (rt != null) {
            LOG.error("Previous instance has not been released! {}", (Object)rt);
        }
        rt = mrt = new Md32xRuntimeData();
        return mrt;
    }

    public static Md32xRuntimeData releaseInstance() {
        Md32xRuntimeData m = rt;
        rt = null;
        return m;
    }

    public final void addCpuDelay(int delay) {
        int n = this.accType;
        this.cpuDelay[n] = this.cpuDelay[n] + delay;
    }

    public final int resetCpuDelay() {
        int res = this.cpuDelay[this.accType];
        this.cpuDelay[this.accType] = 0;
        return res;
    }

    public void setAccessType(S32xUtil.CpuDeviceAccess accessType) {
        this.accessType = accessType;
        this.accType = accessType.ordinal();
    }

    protected S32xUtil.CpuDeviceAccess getAccessType() {
        return this.accessType;
    }

    public static void addCpuDelayExt(int delay) {
        rt.addCpuDelay(delay);
    }

    public static void addCpuDelayExt(int[][] delays, int deviceType) {
        rt.addCpuDelay(delays[Md32xRuntimeData.rt.accType][deviceType]);
    }

    public static void setAccessTypeExt(S32xUtil.CpuDeviceAccess accessType) {
        Md32xRuntimeData.rt.accessType = accessType;
        Md32xRuntimeData.rt.accType = accessType.ordinal();
    }

    public static int resetCpuDelayExt(int value) {
        int res = Md32xRuntimeData.rt.cpuDelay[Md32xRuntimeData.rt.accType];
        Md32xRuntimeData.rt.cpuDelay[Md32xRuntimeData.rt.accType] = value;
        return Md32xRuntimeData.rt.ignoreDelays ? 0 : res;
    }

    public static void resetCpuDelayExt(S32xUtil.CpuDeviceAccess cpu, int value) {
        Md32xRuntimeData.rt.cpuDelay[cpu.ordinal()] = value;
    }

    public static int resetCpuDelayExt() {
        return Md32xRuntimeData.resetCpuDelayExt(0);
    }

    public static int getCpuDelayExt() {
        return Md32xRuntimeData.rt.cpuDelay[Md32xRuntimeData.rt.accType];
    }

    public static int getCpuDelayExt(S32xUtil.CpuDeviceAccess cpu) {
        return Md32xRuntimeData.rt.cpuDelay[cpu.ordinal()];
    }

    public static S32xUtil.CpuDeviceAccess getAccessTypeExt() {
        return Md32xRuntimeData.rt.accessType;
    }
}

