/*
 * Decompiled with CFR 0.152.
 */
package s32x.vdp;

import java.awt.Dimension;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import omegadrive.Device;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import omegadrive.util.VideoMode;
import omegadrive.vdp.util.UpdatableViewer;
import org.slf4j.Logger;
import s32x.dict.S32xDict;

public interface MarsVdp
extends Device {
    public static final Logger LOG = LogHelper.getLogger((String)MarsVdp.class.getSimpleName());
    public static final int PANEL_TEXT_HEIGHT = 20;
    public static final int PANEL_HEIGHT = 276;
    public static final int PANEL_WIDTH = 320;
    public static final Dimension layerDim = new Dimension(320, 276);
    public static final int DIRECT_COLOR_LINES = 204;
    public static final int LINE_TABLE_WORDS = 256;
    public static final int LINE_TABLE_BYTES = 512;
    public static final int[] bgr5toRgb8Mapper = new int[65536];
    public static final int NUM_FB = 2;

    public void write(int var1, int var2, Size var3);

    public int read(int var1, Size var2);

    public boolean vdpRegWrite(S32xDict.RegSpecS32x var1, int var2, int var3, Size var4);

    public void draw(MarsVdpContext var1);

    public void updateVideoMode(VideoMode var1);

    public MarsVdpRenderContext getMarsVdpRenderContext();

    public void updateDebugView(UpdatableViewer var1);

    public int[] doCompositeRendering(VideoMode var1, int[] var2, MarsVdpRenderContext var3);

    default public void dumpMarsData() {
        throw new UnsupportedOperationException();
    }

    public void setHBlank(boolean var1, int var2);

    public void setVBlank(boolean var1);

    public static void initBgrMapper() {
        for (int i = 0; i < bgr5toRgb8Mapper.length; ++i) {
            int b = (i >> 10 & 0x1F) << 3;
            int g = (i >> 5 & 0x1F) << 3;
            int r = (i >> 0 & 0x1F) << 3;
            MarsVdp.bgr5toRgb8Mapper[i] = r << 16 | g << 8 | b;
        }
    }

    public static void storeMarsData(DebugMarsVdpRenderContext ctx) {
        try {
            Path f = Files.createTempFile("mvrc_", ".dat", new FileAttribute[0]);
            Files.write(f, Util.serializeObject((Serializable)ctx), StandardOpenOption.WRITE);
            LOG.info("File written: {}", (Object)f.toAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class DebugMarsVdpRenderContext
    implements Serializable {
        private static final long serialVersionUID = 6600715540292231809L;
        public MarsVdpRenderContext renderContext;
        public short[] frameBuffer0;
        public short[] frameBuffer1;
        public short[] palette;
    }

    public static class MarsVdpRenderContext
    implements Serializable {
        private static final long serialVersionUID = 6079468834587022465L;
        public int[] screen;
        public MarsVdpContext vdpContext;
    }

    public static class MarsVdpContext
    implements Serializable {
        private static final long serialVersionUID = -5808119960311023889L;
        public BitmapMode bitmapMode = BitmapMode.BLANK;
        public VdpPriority priority = VdpPriority.MD;
        public int screenShift = 0;
        public VideoMode videoMode = VideoMode.NTSCJ_H20_V18;
        public int fsLatch = 0;
        public int frameBufferDisplay = 0;
        public int frameBufferWritable = 1;
        public boolean hBlankOn;
        public boolean vBlankOn = true;
        public int hCount = 0;

        public String toString() {
            return "MarsVdpContext{bitmapMode=" + this.bitmapMode + ", priority=" + this.priority + ", screenShift=" + this.screenShift + ", videoMode=" + this.videoMode + ", fsLatch=" + this.fsLatch + ", frameBufferDisplay=" + this.frameBufferDisplay + ", frameBufferWritable=" + this.frameBufferWritable + ", hBlankOn=" + this.hBlankOn + ", vBlankOn=" + this.vBlankOn + ", hCount=" + this.hCount + "}";
        }
    }

    public static enum BitmapMode {
        BLANK,
        PACKED_PX,
        DIRECT_COL,
        RUN_LEN;

        public static BitmapMode[] vals;

        static {
            vals = BitmapMode.values();
        }
    }

    public static enum VdpPriority {
        MD,
        S32X;

    }
}

