/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.audioservers.javasound;

class TimeFilter {
    double tper;
    double b;
    double c;
    double e2;
    double t0;
    double t1;
    double filter_time;
    double system_time;
    double device_time;
    double filter_period_error;
    double system_period_error;
    long ncycles;

    TimeFilter(double period, double bandwidth) {
        this.tper = period;
        double o = Math.PI * 2 * bandwidth * this.tper;
        this.b = Math.sqrt(2.0 * o);
        this.c = o * o;
        this.t0 = 0.0;
    }

    double update(double time) {
        if (this.t0 == 0.0) {
            this.e2 = this.tper;
            this.t0 = time;
            this.t1 = this.t0 + this.e2;
            this.device_time = time;
            this.filter_period_error = 0.0;
            this.system_period_error = 0.0;
            this.ncycles = 0L;
        } else {
            double e = time - this.t1;
            this.t0 = this.t1;
            this.t1 += this.b * e + this.e2;
            this.e2 += this.c * e;
            this.filter_period_error = this.t0 - this.filter_time - this.tper;
            this.system_period_error = time - this.system_time - this.tper;
            this.device_time += this.tper;
            ++this.ncycles;
        }
        this.system_time = time;
        this.filter_time = this.t0;
        return this.filter_time;
    }
}

