/*
 * Decompiled with CFR 0.152.
 */
package z80core;

public interface IMemIoOps {
    public int fetchOpcode(int var1);

    public int peek8(int var1);

    public void poke8(int var1, int var2);

    default public int peek16(int address) {
        int lsb = this.peek8(address);
        int msb = this.peek8(address + 1);
        return msb << 8 | lsb;
    }

    default public void poke16(int address, int word) {
        this.poke8(address, word);
        this.poke8(address + 1, word >>> 8);
    }

    public int inPort(int var1);

    public void outPort(int var1, int var2);

    public void addressOnBus(int var1, int var2);

    default public int getAddressOnBus() {
        return 255;
    }

    public void interruptHandlingTime(int var1);

    public boolean isActiveINT();

    public boolean setActiveINT(boolean var1);

    public long getTstates();

    public void reset();

    default public int getPcUpperLimit() {
        return 65535;
    }
}

