/*
 * Decompiled with CFR 0.152.
 */
package s32x;

import java.io.Serializable;
import java.nio.ByteBuffer;
import omegadrive.Device;
import omegadrive.util.Fifo;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.S32XMMREG;
import s32x.dict.S32xDict;
import s32x.savestate.Gs32xStateHandler;
import s32x.sh2.device.DmaC;
import s32x.util.Md32xRuntimeData;
import s32x.util.S32xUtil;

public class DmaFifo68k
implements Device {
    private static final Logger LOG = LogHelper.getLogger((String)DmaFifo68k.class.getSimpleName());
    public static final int M68K_FIFO_FULL_BIT = 7;
    public static final int M68K_68S_BIT_POS = 2;
    public static final int SH2_FIFO_FULL_BIT = 15;
    public static final int SH2_FIFO_EMPTY_BIT = 14;
    public static final int DREQ0_CHANNEL = 0;
    public static final int DMA_FIFO_SIZE = 8;
    public static final int M68K_DMA_FIFO_LEN_MASK = 65532;
    private final ByteBuffer sysRegsMd;
    private final ByteBuffer sysRegsSh2;
    private DmaC[] dmac;
    private DmaFifo68kContext ctx;
    public static boolean rv = false;
    private static final boolean verbose = false;

    public DmaFifo68k(S32XMMREG.RegContext regContext) {
        this.sysRegsMd = regContext.sysRegsMd;
        this.sysRegsSh2 = regContext.sysRegsSh2;
        this.ctx = new DmaFifo68kContext();
        Gs32xStateHandler.addDevice(this);
        this.ctx.rv = rv;
    }

    public int read(S32xDict.RegSpecS32x regSpec, S32xUtil.CpuDeviceAccess cpu, int address, Size size) {
        int res = switch (cpu.regSide) {
            default -> throw new IncompatibleClassChangeError();
            case S32xUtil.S32xRegSide.MD -> this.readMd(address, size);
            case S32xUtil.S32xRegSide.SH2 -> this.readSh2(regSpec, address, size);
        };
        return res;
    }

    public void write(S32xDict.RegSpecS32x regSpec, S32xUtil.CpuDeviceAccess cpu, int address, int value, Size size) {
        switch (cpu.regSide) {
            case MD: {
                this.writeMd(regSpec, address, value, size);
                break;
            }
            default: {
                LOG.error("Invalid {} DMA write {}: {} {}", new Object[]{cpu, regSpec.getName(), Util.th((int)value), size});
            }
        }
    }

    private void writeMd(S32xDict.RegSpecS32x regSpec, int address, int value, Size size) {
        assert (size != Size.LONG);
        switch (regSpec) {
            case MD_DMAC_CTRL: {
                this.handleDreqCtlWriteMd(address, value, size);
                break;
            }
            case MD_FIFO_REG: {
                assert (Md32xRuntimeData.getAccessTypeExt() != S32xUtil.CpuDeviceAccess.Z80);
                this.handleFifoRegWriteMd(value, size);
                S32xUtil.writeBufferRaw(this.sysRegsMd, address, value, size);
                break;
            }
            case MD_DREQ_LEN: {
                value &= 0xFFFC;
            }
            case MD_DREQ_DEST_ADDR_H: 
            case MD_DREQ_DEST_ADDR_L: 
            case MD_DREQ_SRC_ADDR_H: 
            case MD_DREQ_SRC_ADDR_L: {
                assert (Md32xRuntimeData.getAccessTypeExt() != S32xUtil.CpuDeviceAccess.Z80);
                S32xUtil.writeBufferRaw(this.sysRegsMd, address, value, size);
                S32xUtil.writeBufferRaw(this.sysRegsSh2, address, value, size);
                break;
            }
            default: {
                LOG.error("{} check DMA write {}: {} {}", new Object[]{S32xUtil.CpuDeviceAccess.M68K, regSpec.getName(), Util.th((int)value), size});
            }
        }
    }

    private void handleDreqCtlWriteMd(int reg, int value, Size size) {
        assert (size != Size.LONG);
        boolean changed = S32xDict.RegSpecS32x.MD_DMAC_CTRL.regSpec.write(this.sysRegsMd, reg, value, size);
        if (changed) {
            int res = Util.readBufferWord((ByteBuffer)this.sysRegsMd, (int)S32xDict.RegSpecS32x.MD_DMAC_CTRL.addr);
            boolean wasDmaOn = this.ctx.m68S;
            this.ctx.m68S = (res & 4) > 0;
            rv = (res & 1) > 0;
            S32xUtil.writeBufferRaw(this.sysRegsSh2, S32xDict.RegSpecS32x.SH2_DREQ_CTRL.addr + 1, res & S32xDict.RegSpecS32x.MD_DMAC_CTRL.regSpec.writableBitMask, Size.BYTE);
            if (wasDmaOn && !this.ctx.m68S) {
                LOG.info("{} Setting 68S = 0, stops DMA while running", (Object)Md32xRuntimeData.getAccessTypeExt());
                this.dmaEnd();
            }
            this.updateFifoState();
        }
    }

    private void handleFifoRegWriteMd(int value, Size size) {
        assert (size == Size.WORD);
        if (this.ctx.m68S) {
            if (!this.ctx.fifo.isFull()) {
                this.ctx.fifo.push((Object)Util.getFromIntegerCache((int)value));
                this.updateFifoState();
            } else {
                LOG.error("DMA Fifo full, discarding data");
            }
        } else {
            LOG.error("DMA off, ignoring FIFO write: {}", (Object)Util.th((int)value));
        }
    }

    public void dmaEnd() {
        this.ctx.fifo.clear();
        this.updateFifoState();
        this.evaluateDreqTrigger(true);
        S32xUtil.setBit(this.sysRegsMd, this.sysRegsSh2, S32xDict.RegSpecS32x.SH2_DREQ_CTRL.addr + 1, 2, 0, Size.BYTE);
        this.ctx.m68S = false;
    }

    public void updateFifoState() {
        boolean changed = S32xUtil.setBitRegFromWord(this.sysRegsMd, S32xDict.RegSpecS32x.MD_DMAC_CTRL, 7, this.ctx.fifo.isFullBit());
        if (changed) {
            S32xUtil.setBit(this.sysRegsSh2, S32xDict.RegSpecS32x.SH2_DREQ_CTRL.addr, 15, this.ctx.fifo.isFull() ? 1 : 0, Size.WORD);
        }
        if (changed = S32xUtil.setBitRegFromWord(this.sysRegsSh2, S32xDict.RegSpecS32x.SH2_DREQ_CTRL, 14, this.ctx.fifo.isEmptyBit())) {
            // empty if block
        }
        this.evaluateDreqTrigger(this.ctx.m68S);
    }

    private void evaluateDreqTrigger(boolean pm68S) {
        int lev = this.ctx.fifo.getLevel();
        if (pm68S && (lev & 3) == 0) {
            boolean enable = lev > 0;
            this.dmac[S32xUtil.CpuDeviceAccess.MASTER.ordinal()].dmaReqTrigger(0, enable);
            this.dmac[S32xUtil.CpuDeviceAccess.SLAVE.ordinal()].dmaReqTrigger(0, enable);
        }
    }

    private int readMd(int reg, Size size) {
        return S32xUtil.readBuffer(this.sysRegsMd, reg, size);
    }

    private int readSh2(S32xDict.RegSpecS32x regSpec, int address, Size size) {
        if (regSpec == S32xDict.RegSpecS32x.SH2_DREQ_CTRL) {
            return S32xUtil.readBuffer(this.sysRegsSh2, address, size);
        }
        if (regSpec == S32xDict.RegSpecS32x.SH2_FIFO_REG) {
            assert (size == Size.WORD);
            int res = 0;
            if (this.ctx.m68S && !this.ctx.fifo.isEmpty()) {
                res = (Integer)this.ctx.fifo.pop();
                this.updateFifoState();
            } else {
                LOG.error("Dreq0: {}, ctx.fifoEmpty: {}", (Object)this.ctx.m68S, (Object)this.ctx.fifo.isEmpty());
            }
            return res;
        }
        return S32xUtil.readBuffer(this.sysRegsMd, address, size);
    }

    public void saveContext(ByteBuffer buffer) {
        super.saveContext(buffer);
        this.ctx.rv = rv;
        buffer.put(Util.serializeObject((Serializable)this.ctx));
    }

    public void loadContext(ByteBuffer buffer) {
        super.loadContext(buffer);
        Serializable s = Util.deserializeObject((byte[])buffer.array(), (int)0, (int)buffer.capacity());
        assert (s instanceof DmaFifo68kContext);
        this.ctx = (DmaFifo68kContext)s;
        rv = this.ctx.rv;
    }

    public void setDmac(DmaC ... dmac) {
        this.dmac = dmac;
    }

    public DmaC[] getDmac() {
        return this.dmac;
    }

    static class DmaFifo68kContext
    implements Serializable {
        private final Fifo<Integer> fifo = Fifo.createIntegerFixedSizeFifo((int)8);
        private boolean m68S = false;
        private boolean rv = false;

        DmaFifo68kContext() {
        }
    }
}

