/*
 * Decompiled with CFR 0.152.
 */
package s32x;

import java.nio.file.Path;
import java.util.Optional;
import omegadrive.Device;
import omegadrive.SystemLoader;
import omegadrive.bus.model.GenesisBusProvider;
import omegadrive.sound.PwmProvider;
import omegadrive.system.Genesis;
import omegadrive.system.SystemProvider;
import omegadrive.ui.DisplayWindow;
import omegadrive.util.LogHelper;
import omegadrive.util.Sleeper;
import omegadrive.util.VideoMode;
import omegadrive.vdp.md.GenesisVdp;
import omegadrive.vdp.util.UpdatableViewer;
import org.slf4j.Logger;
import s32x.StaticBootstrapSupport;
import s32x.bus.S32xBus;
import s32x.event.PollSysEventManager;
import s32x.pwm.Pwm;
import s32x.sh2.Sh2;
import s32x.sh2.Sh2Context;
import s32x.sh2.drc.Ow2DrcOptimizer;
import s32x.util.MarsLauncherHelper;
import s32x.util.Md32xRuntimeData;
import s32x.util.S32xMemView;
import s32x.util.S32xUtil;
import s32x.vdp.MarsVdp;
import s32x.vdp.debug.DebugVideoRenderContext;

public class Md32x
extends Genesis
implements PollSysEventManager.SysEventListener {
    private static final Logger LOG = LogHelper.getLogger((String)Md32x.class.getSimpleName());
    private static final boolean ENABLE_FM;
    private static final boolean ENABLE_PWM;
    public static final boolean SH2_DEBUG_DRC;
    protected static final int SH2_CYCLES_PER_STEP;
    protected static final int SH2_CYCLE_RATIO = 3;
    private static final double SH2_CYCLE_DIV;
    private static final int CYCLE_TABLE_LEN_MASK = 255;
    private static final int[] sh2CycleTable;
    private static final Sh2.Sh2Config sh2Config;
    public static final int SH2_SLEEP_VALUE = -10000;
    public int nextMSh2Cycle = 0;
    public int nextSSh2Cycle = 0;
    private Md32xRuntimeData rt;
    private MarsLauncherHelper.Sh2LaunchContext launchCtx;
    private Sh2 sh2;
    private Sh2Context masterCtx;
    private Sh2Context slaveCtx;
    private MarsVdp marsVdp;
    private long slowFramesAcc;

    public Md32x(DisplayWindow emuFrame) {
        super(emuFrame);
        this.systemType = SystemLoader.SystemType.S32X;
    }

    @Override
    protected void initAfterRomLoad() {
        this.launchCtx = MarsLauncherHelper.setupRom((S32xBus)this.bus, this.memory.getRomHolder());
        this.masterCtx = this.launchCtx.masterCtx;
        this.slaveCtx = this.launchCtx.slaveCtx;
        this.sh2 = this.launchCtx.sh2;
        this.marsVdp = this.launchCtx.marsVdp;
        this.nextSSh2Cycle = this.nextMSh2Cycle = this.launchCtx.s32XMMREG.aden & 1;
        this.marsVdp.updateDebugView(((GenesisVdp)this.vdp).getDebugViewer());
        super.initAfterRomLoad();
        this.launchCtx.pwm.setPwmProvider(ENABLE_PWM ? this.sound.getPwm() : PwmProvider.NO_SOUND);
        this.sound.setEnabled((Device)this.sound.getFm(), ENABLE_FM);
        this.sound.setEnabled((Device)this.sound.getPwm(), !Pwm.PWM_USE_BLIP);
    }

    public static SystemProvider createNewInstance32x(DisplayWindow emuFrame, boolean debugPerf) {
        return debugPerf ? null : new Md32x(emuFrame);
    }

    @Override
    protected void loop() {
        this.updateVideoMode(true);
        assert (this.cycleCounter == 1);
        do {
            this.run68k();
            this.runZ80();
            this.runFM();
            this.runSh2();
            this.runDevices();
            this.runVdp();
            ++this.cycleCounter;
        } while (!this.futureDoneFlag);
    }

    protected final void runSh2() {
        if (this.nextMSh2Cycle == this.cycleCounter) {
            assert (!PollSysEventManager.currentPollers[0].isPollingActive()) : PollSysEventManager.currentPollers[0];
            this.rt.setAccessType(S32xUtil.CpuDeviceAccess.MASTER);
            this.sh2.run(this.masterCtx);
            assert ((this.masterCtx.cycles_ran & 0xFF) == this.masterCtx.cycles_ran) : this.masterCtx.cycles_ran;
            assert (Md32xRuntimeData.resetCpuDelayExt() == 0);
            this.nextMSh2Cycle += sh2CycleTable[this.masterCtx.cycles_ran];
        }
        if (this.nextSSh2Cycle == this.cycleCounter) {
            assert (!PollSysEventManager.currentPollers[1].isPollingActive()) : PollSysEventManager.currentPollers[1];
            this.rt.setAccessType(S32xUtil.CpuDeviceAccess.SLAVE);
            this.sh2.run(this.slaveCtx);
            assert ((this.slaveCtx.cycles_ran & 0xFF) == this.slaveCtx.cycles_ran) : this.slaveCtx.cycles_ran;
            assert (Md32xRuntimeData.resetCpuDelayExt() == 0);
            this.nextSSh2Cycle += sh2CycleTable[this.slaveCtx.cycles_ran];
        }
    }

    private void runDevices() {
        assert (Md32xRuntimeData.getCpuDelayExt() == 0);
        this.launchCtx.pwm.step(3);
        this.launchCtx.mDevCtx.sh2MMREG.deviceStepSh2Rate(3);
        this.launchCtx.sDevCtx.sh2MMREG.deviceStepSh2Rate(3);
        assert (Md32xRuntimeData.getCpuDelayExt() == 0);
    }

    @Override
    protected GenesisBusProvider createBus() {
        return new S32xBus();
    }

    protected void doRendering(VideoMode mdVideoMode, int[] data, Optional<String> stats) {
        MarsVdp.MarsVdpRenderContext ctx = this.marsVdp.getMarsVdpRenderContext();
        boolean dumpComposite = false;
        boolean dumpMars = false;
        if (dumpComposite) {
            DebugVideoRenderContext.dumpCompositeData(ctx, data, mdVideoMode);
        }
        if (dumpMars) {
            this.marsVdp.dumpMarsData();
        }
        int[] fg = this.marsVdp.doCompositeRendering(mdVideoMode, data, ctx);
        super.doRendering(ctx.vdpContext.videoMode, fg, stats);
    }

    @Override
    protected void resetCycleCounters(int counter) {
        super.resetCycleCounters(counter);
        assert (counter >= 0);
        if (this.nextMSh2Cycle >= 0) {
            this.nextMSh2Cycle = Math.max(this.launchCtx.s32XMMREG.aden & 1, this.nextMSh2Cycle - counter);
        }
        if (this.nextSSh2Cycle >= 0) {
            this.nextSSh2Cycle = Math.max(this.launchCtx.s32XMMREG.aden & 1, this.nextSSh2Cycle - counter);
        }
        this.launchCtx.pwm.newFrame();
        this.launchCtx.mDevCtx.sh2MMREG.newFrame();
        this.launchCtx.sDevCtx.sh2MMREG.newFrame();
        this.launchCtx.memory.newFrame();
        if (this.telemetry.getFrameCounter() % (long)this.getRegion().getFps() == 0L) {
            this.slowFramesAcc = 0L;
        }
    }

    protected long syncCycle(long startCycle) {
        long now = System.nanoTime();
        if (fullThrottle) {
            return now;
        }
        long baseRemainingNs = startCycle + this.targetNs;
        long remainingNs = baseRemainingNs - now;
        this.slowFramesAcc += remainingNs;
        if (this.slowFramesAcc > 0L) {
            remainingNs = this.slowFramesAcc;
            this.slowFramesAcc = 0L;
        }
        if (remainingNs > 0L) {
            Sleeper.parkFuzzy((long)remainingNs);
            remainingNs = baseRemainingNs - System.nanoTime();
        }
        return System.nanoTime();
    }

    @Override
    protected UpdatableViewer createMemView() {
        return S32xMemView.createInstance((GenesisBusProvider)this.bus, this.launchCtx.memory, this.vdp.getVdpMemory());
    }

    protected void handleCloseRom() {
        super.handleCloseRom();
        Optional.ofNullable(this.marsVdp).ifPresent(Device::reset);
        this.launchCtx.pwm.reset();
        Md32xRuntimeData.releaseInstance();
    }

    public void handleNewRom(Path file) {
        super.handleNewRom(file);
        this.rt = Md32xRuntimeData.newInstance();
        StaticBootstrapSupport.initStatic(this);
    }

    @Override
    public void onSysEvent(S32xUtil.CpuDeviceAccess cpu, PollSysEventManager.SysEvent event) {
        switch (event) {
            case START_POLLING: {
                Ow2DrcOptimizer.PollerCtx pc = PollSysEventManager.instance.getPoller(cpu);
                assert (pc.isPollingActive()) : event + "," + pc;
                this.setNextCycle(cpu, -10000);
                Md32xRuntimeData.resetCpuDelayExt(cpu, 0);
                break;
            }
            case SH2_RESET_ON: {
                this.setNextCycle(S32xUtil.CpuDeviceAccess.MASTER, -10000);
                this.setNextCycle(S32xUtil.CpuDeviceAccess.SLAVE, -10000);
                break;
            }
            case SH2_RESET_OFF: {
                this.setNextCycle(S32xUtil.CpuDeviceAccess.MASTER, this.cycleCounter + 1);
                this.setNextCycle(S32xUtil.CpuDeviceAccess.SLAVE, this.cycleCounter + 2);
                Md32xRuntimeData.resetCpuDelayExt(S32xUtil.CpuDeviceAccess.MASTER, 0);
                Md32xRuntimeData.resetCpuDelayExt(S32xUtil.CpuDeviceAccess.SLAVE, 0);
                break;
            }
            default: {
                Ow2DrcOptimizer.PollerCtx pc = PollSysEventManager.instance.getPoller(cpu);
                this.stopPolling(cpu, event, pc);
            }
        }
    }

    private void stopPolling(S32xUtil.CpuDeviceAccess cpu, PollSysEventManager.SysEvent event, Ow2DrcOptimizer.PollerCtx pctx) {
        boolean stopOk;
        boolean bl = stopOk = event == pctx.event || event == PollSysEventManager.SysEvent.INT;
        if (stopOk) {
            this.setNextCycle(cpu, this.cycleCounter + 1);
            assert (PollSysEventManager.pollValueCheck(cpu, event, pctx));
            PollSysEventManager.instance.resetPoller(cpu);
        } else {
            LOG.warn("{} {} ignore stop polling: {}", new Object[]{cpu, event, pctx});
        }
    }

    public void setNextCycle(S32xUtil.CpuDeviceAccess cpu, int value) {
        if (cpu == S32xUtil.CpuDeviceAccess.MASTER) {
            this.nextMSh2Cycle = value;
        } else {
            assert (cpu == S32xUtil.CpuDeviceAccess.SLAVE);
            this.nextSSh2Cycle = value;
        }
    }

    static {
        SH2_CYCLE_DIV = 1.0 / Double.parseDouble(System.getProperty("helios.32x.sh2.cycle.div", "3.0"));
        sh2CycleTable = new int[256];
        boolean prefEn = Boolean.parseBoolean(System.getProperty("helios.32x.sh2.prefetch", "true"));
        boolean drcEn = Boolean.parseBoolean(System.getProperty("helios.32x.sh2.drc", "true"));
        boolean pollEn = Boolean.parseBoolean(System.getProperty("helios.32x.sh2.poll.detect", "true"));
        boolean ignoreDelays = Boolean.parseBoolean(System.getProperty("helios.32x.sh2.ignore.delays", "false"));
        sh2Config = new Sh2.Sh2Config(prefEn, drcEn, pollEn, ignoreDelays);
        Pwm.PWM_USE_BLIP = Boolean.parseBoolean(System.getProperty("helios.32x.pwm.use.blip", "false"));
        SH2_DEBUG_DRC = Boolean.parseBoolean(System.getProperty("helios.32x.sh2.drc.debug", "false"));
        ENABLE_FM = Boolean.parseBoolean(System.getProperty("helios.32x.fm.enable", "true"));
        ENABLE_PWM = Boolean.parseBoolean(System.getProperty("helios.32x.pwm.enable", "true"));
        Sh2Context.burstCycles = SH2_CYCLES_PER_STEP = Integer.parseInt(System.getProperty("helios.32x.sh2.cycles", "32"));
        LOG.info("Enable FM: {}, Enable PWM: {}, Sh2Cycles: {}", new Object[]{ENABLE_FM, ENABLE_PWM, SH2_CYCLES_PER_STEP});
        for (int i = 0; i < sh2CycleTable.length; ++i) {
            Md32x.sh2CycleTable[i] = Math.max(1, (int)Math.round((double)i * SH2_CYCLE_DIV));
        }
        S32xUtil.assertPowerOf2Minus1("CYCLE_TABLE_LEN_MASK", 255);
    }
}

