/*
 * Decompiled with CFR 0.152.
 */
package s32x.event;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import omegadrive.Device;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.bus.Sh2Bus;
import s32x.sh2.drc.Ow2DrcOptimizer;
import s32x.util.Md32xRuntimeData;
import s32x.util.S32xUtil;

public interface PollSysEventManager
extends Device {
    public static final Logger LOG;
    public static final PollSysEventManager instance;
    public static final Ow2DrcOptimizer.PollerCtx[] currentPollers;
    public static final AtomicInteger pollerActiveMask;

    public void fireSysEvent(S32xUtil.CpuDeviceAccess var1, SysEvent var2);

    public boolean addSysEventListener(S32xUtil.CpuDeviceAccess var1, String var2, SysEventListener var3);

    public boolean removeSysEventListener(S32xUtil.CpuDeviceAccess var1, String var2, SysEventListener var3);

    default public boolean addSysEventListener(String name, SysEventListener l) {
        this.addSysEventListener(S32xUtil.CpuDeviceAccess.MASTER, name, l);
        this.addSysEventListener(S32xUtil.CpuDeviceAccess.SLAVE, name, l);
        return true;
    }

    default public int removeSysEventListener(String name, SysEventListener l) {
        int num = 0;
        boolean s1 = this.removeSysEventListener(S32xUtil.CpuDeviceAccess.MASTER, name, l);
        boolean s2 = this.removeSysEventListener(S32xUtil.CpuDeviceAccess.SLAVE, name, l);
        return num += (s1 ? 1 : 0) + (s2 ? 1 : 0);
    }

    default public void resetPoller(S32xUtil.CpuDeviceAccess cpu) {
        Ow2DrcOptimizer.PollerCtx pctx = currentPollers[cpu.ordinal()];
        if (pctx != Ow2DrcOptimizer.NO_POLLER) {
            pctx.stopPolling();
            PollSysEventManager.currentPollers[cpu.ordinal()] = Ow2DrcOptimizer.NO_POLLER;
            pollerActiveMask.set(pollerActiveMask.get() & ~(cpu.ordinal() + 1));
        }
    }

    default public void setPoller(S32xUtil.CpuDeviceAccess cpu, Ow2DrcOptimizer.PollerCtx ctx) {
        if (!1.$assertionsDisabled && currentPollers[cpu.ordinal()] != Ow2DrcOptimizer.NO_POLLER) {
            throw new AssertionError();
        }
        PollSysEventManager.currentPollers[cpu.ordinal()] = ctx;
        pollerActiveMask.set(pollerActiveMask.get() | cpu.ordinal() + 1);
    }

    default public Ow2DrcOptimizer.PollerCtx getPoller(S32xUtil.CpuDeviceAccess cpu) {
        return currentPollers[cpu.ordinal()];
    }

    default public int anyPollerActive() {
        return pollerActiveMask.get();
    }

    public static int readPollValue(Ow2DrcOptimizer.PollerCtx blockPoller) {
        if (blockPoller.isPollingBusyLoop()) {
            return 0;
        }
        if (!blockPoller.piw.block.isValid()) {
            LOG.warn("Unexpected state, block is invalid?\n{}", (Object)blockPoller);
            return 0;
        }
        Sh2Bus memory = blockPoller.piw.block.drcContext.memory;
        return memory.readMemoryUncachedNoDelay(blockPoller.blockPollData.memLoadTarget, blockPoller.blockPollData.memLoadTargetSize);
    }

    public static boolean pollValueCheck(S32xUtil.CpuDeviceAccess cpu, SysEvent event, Ow2DrcOptimizer.PollerCtx pctx) {
        if (event == SysEvent.INT) {
            return true;
        }
        if (!1.$assertionsDisabled && Md32xRuntimeData.getCpuDelayExt(cpu) != 0) {
            throw new AssertionError();
        }
        int value = PollSysEventManager.readPollValue(pctx);
        if (value == pctx.pollValue) {
            System.out.println("?? Poll stop but value unchanged: " + Util.th((int)pctx.pollValue) + "," + Util.th((int)value));
        }
        if (!1.$assertionsDisabled && value == pctx.pollValue) {
            throw new AssertionError();
        }
        return true;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        LOG = LogHelper.getLogger((String)PollSysEventManager.class.getSimpleName());
        instance = new SysEventManagerImpl();
        currentPollers = new Ow2DrcOptimizer.PollerCtx[]{Ow2DrcOptimizer.NO_POLLER, Ow2DrcOptimizer.NO_POLLER};
        pollerActiveMask = new AtomicInteger();
    }

    public static interface SysEventListener {
        public void onSysEvent(S32xUtil.CpuDeviceAccess var1, SysEvent var2);
    }

    public static enum SysEvent {
        NONE,
        INT,
        SYS,
        SDRAM,
        FRAMEBUFFER,
        COMM,
        DMA,
        PWM,
        VDP,
        START_POLLING,
        SH2_RESET_ON,
        SH2_RESET_OFF;

    }

    public static class SysEventManagerImpl
    implements PollSysEventManager {
        private final Map<String, SysEventListener> listenerMapMaster = new HashMap<String, SysEventListener>();
        private final Map<String, SysEventListener> listenerMapSlave = new HashMap<String, SysEventListener>();
        private final SysEventListener[][] listenerArr = new SysEventListener[2][0];

        @Override
        public boolean addSysEventListener(S32xUtil.CpuDeviceAccess cpu, String name, SysEventListener l) {
            Map<String, SysEventListener> map = cpu == S32xUtil.CpuDeviceAccess.MASTER ? this.listenerMapMaster : this.listenerMapSlave;
            SysEventListener s = map.put(name, l);
            assert (s == null);
            this.listenerArr[cpu.ordinal()] = map.values().toArray(new SysEventListener[0]);
            assert (this.listenerArr[cpu.ordinal()].length == map.size());
            return true;
        }

        @Override
        public boolean removeSysEventListener(S32xUtil.CpuDeviceAccess cpu, String name, SysEventListener l) {
            Map<String, SysEventListener> map = cpu == S32xUtil.CpuDeviceAccess.MASTER ? this.listenerMapMaster : this.listenerMapSlave;
            SysEventListener s = map.remove(name);
            this.listenerArr[cpu.ordinal()] = map.values().toArray(new SysEventListener[0]);
            assert (this.listenerArr[cpu.ordinal()].length == map.size());
            return s != null;
        }

        @Override
        public void fireSysEvent(S32xUtil.CpuDeviceAccess cpu, SysEvent event) {
            assert (cpu.ordinal() < 2);
            SysEventListener[] a = this.listenerArr[cpu.ordinal()];
            for (int i = 0; i < a.length; ++i) {
                a[i].onSysEvent(cpu, event);
            }
        }

        public void reset() {
            this.listenerMapMaster.clear();
            this.listenerMapSlave.clear();
            this.listenerArr[0] = new SysEventListener[0];
            this.listenerArr[1] = new SysEventListener[0];
            SysEventManagerImpl.currentPollers[0] = SysEventManagerImpl.currentPollers[1] = Ow2DrcOptimizer.NO_POLLER;
            pollerActiveMask.set(0);
        }
    }
}

