/*
 * Decompiled with CFR 0.152.
 */
package s32x.pwm;

import javax.sound.sampled.AudioFormat;
import omegadrive.sound.javasound.AbstractSoundManager;
import omegadrive.util.Fifo;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;
import s32x.util.S32xUtil;

public class PwmUtil {
    private static final Logger LOG = LogHelper.getLogger((String)PwmUtil.class.getSimpleName());
    public static final Fifo<Integer> EMPTY_FIFO = Fifo.createIntegerFixedSizeFifo((int)0);
    public static final Warmup NO_WARMUP = new Warmup();
    public static final Warmup WARMUP = new Warmup();
    public static AudioFormat pwmAudioFormat = AbstractSoundManager.audioFormat;
    private static final double alpha = 0.95;

    public static void setSigned16LE(short value, byte[] data, int startIndex) {
        data[startIndex] = (byte)value;
        data[startIndex + 1] = (byte)(value >> 8);
    }

    public static void dcBlockerLpf(int[] in, int[] out, int[] prevLR, int len) {
        out[0] = prevLR[0];
        out[1] = prevLR[1];
        for (int i = 2; i < len; i += 2) {
            out[i] = (int)((double)(in[i] - in[i - 2]) + (double)out[i - 2] * 0.95);
            out[i + 1] = (int)((double)(in[i + 1] - in[i - 1]) + (double)out[i - 1] * 0.95);
            out[i] = out[i] + out[i - 2] >> 1;
            out[i + 1] = out[i + 1] + out[i - 1] >> 1;
        }
        prevLR[0] = out[len - 2];
        prevLR[1] = out[len - 1];
    }

    public static int dcBlockerLpfMono(int[] in, int[] out, int prevSample, int len) {
        out[0] = prevSample;
        for (int i = 1; i < len; ++i) {
            out[i] = (int)((double)(in[i] - in[i - 1]) + (double)out[i - 1] * 0.95);
            out[i] = out[i] + out[i - 1] >> 1;
        }
        return out[len - 1];
    }

    public static class Warmup {
        static final int stepSamples = 2047;
        static final double stepFactor = 0.02;
        boolean isWarmup;
        int currentSamples;
        double currentFactor = 0.0;

        public int doWarmup(int sample) {
            if (this.isWarmup) {
                int res = (int)((double)sample * this.currentFactor);
                this.addSampleCount(1);
                return res;
            }
            return sample;
        }

        private void addSampleCount(int add) {
            int start = this.currentSamples & 0x7FF;
            this.currentSamples += add;
            if ((this.currentSamples & 0x7FF) < start) {
                this.currentFactor += 0.02;
                if (this.currentFactor >= 1.0) {
                    this.reset();
                    LOG.info("PWM warmup done");
                }
            }
        }

        public void doWarmup(int[] out, int len) {
            if (this.isWarmup) {
                int start = this.currentSamples & 0x7FF;
                for (int i = 2; i < len; i += 2) {
                    int n = i;
                    out[n] = (int)((double)out[n] * this.currentFactor);
                    int n2 = i + 1;
                    out[n2] = (int)((double)out[n2] * this.currentFactor);
                }
                this.addSampleCount(len);
            }
        }

        public void reset() {
            this.isWarmup = false;
            this.currentSamples = 0;
            this.currentFactor = 0.0;
        }

        static {
            S32xUtil.assertPowerOf2Minus1("pwmStepSamples", 2047);
        }
    }

    static class PwmStats {
        public static final PwmStats NO_STATS = new PwmStats();
        public int monoSamplesFiller = 0;
        public int monoSamplesPull = 0;
        public int monoSamplesPush = 0;
        public int monoSamplesDiscard = 0;
        public int monoSamplesDiscardHalf = 0;

        PwmStats() {
        }

        public void print(int monoLen) {
            LOG.info("Pwm frame monoSamples, push: {} (discard: {}, discardHalf: {}), pop: {}, filler: {}, tot: {}, monoQLen: {}", new Object[]{this.monoSamplesPush, this.monoSamplesDiscard, this.monoSamplesDiscardHalf, this.monoSamplesPull, this.monoSamplesFiller, this.monoSamplesPull + this.monoSamplesFiller, monoLen});
        }

        public void reset() {
            this.monoSamplesDiscardHalf = 0;
            this.monoSamplesDiscard = 0;
            this.monoSamplesPush = 0;
            this.monoSamplesPull = 0;
            this.monoSamplesFiller = 0;
        }
    }
}

