/*
 * Decompiled with CFR 0.152.
 */
package s32x.savestate;

import com.google.common.primitives.Bytes;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import omegadrive.Device;
import omegadrive.savestate.BaseStateHandler;
import omegadrive.savestate.GshStateHandler;
import omegadrive.savestate.StateUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.StaticBootstrapSupport;
import s32x.event.PollSysEventManager;
import s32x.sh2.Sh2Context;
import s32x.sh2.Sh2Helper;
import s32x.sh2.cache.Sh2Cache;
import s32x.util.S32xUtil;

public class Gs32xStateHandler
extends GshStateHandler {
    private static final Logger LOG = LogHelper.getLogger((String)Gs32xStateHandler.class.getSimpleName());
    protected static final String MAGIC_WORD_32X = "G32";
    protected static final String START_32X_TOKEN = "START_GS32X";
    protected static final String END_32X_TOKEN = "END_GS32X";
    protected static final String fileExtension32x = "gs32x";
    private static final Map<String, Device> s32xDeviceSet = new WeakHashMap<String, Device>();
    private static final Sh2ContextWrap wrap = new Sh2ContextWrap();

    public static BaseStateHandler createInstance(String fileName, BaseStateHandler.Type type, Set<Device> deviceSet) {
        Gs32xStateHandler h = new Gs32xStateHandler();
        h.type = type;
        h.init(fileName);
        h.setDevicesWithContext(deviceSet);
        return h;
    }

    protected Gs32xStateHandler() {
    }

    protected static String handleFileExtension(String fileName) {
        boolean hasExtension = fileName.toLowerCase().contains(".gs32x");
        return fileName + (!hasExtension ? ".gs32x" : "");
    }

    protected void init(String fileNameEx) {
        this.fileName = Gs32xStateHandler.handleFileExtension(fileNameEx);
        if (this.type == BaseStateHandler.Type.SAVE) {
            this.buffer = ByteBuffer.allocate(140408);
            this.buffer.put(MAGIC_WORD_32X.getBytes());
        } else {
            this.buffer = StateUtil.loadStateFile((String)this.fileName, (String[])new String[]{".gs"});
            this.detectStateFileType();
        }
    }

    protected BaseStateHandler detectStateFileType() {
        byte[] magicWord = new byte[MAGIC_WORD_32X.length()];
        this.buffer.get(magicWord);
        String fileType = Util.toStringValue((byte[])magicWord);
        boolean isSupported = MAGIC_WORD_32X.equalsIgnoreCase(fileType);
        if (!isSupported || this.buffer.capacity() < 140408) {
            LOG.error("Unable to load save state of type: {}, size: {}", (Object)fileType, (Object)this.buffer.capacity());
            return BaseStateHandler.EMPTY_STATE;
        }
        this.version = this.buffer.get(80) & 0xFF;
        this.softwareId = this.buffer.get(81) & 0xFF;
        LOG.info("Savestate type {}, version: {}, softwareId: {}", new Object[]{fileType, this.version, this.softwareId});
        return this;
    }

    public static void addDevice(Device d) {
        if (d instanceof Sh2Context) {
            Sh2Context s;
            Gs32xStateHandler.wrap.sh2Ctx[s.cpuAccess.ordinal()] = s = (Sh2Context)d;
            return;
        }
        if (d instanceof Sh2Cache) {
            Sh2Cache s;
            Gs32xStateHandler.wrap.sh2Cache[s.getCacheContext().cpu.ordinal()] = s = (Sh2Cache)d;
            return;
        }
        s32xDeviceSet.put(d.getClass().getSimpleName(), d);
    }

    public void processState() {
        super.processState();
        ByteBuffer b = ByteBuffer.allocate(2246528);
        assert (!s32xDeviceSet.isEmpty());
        if (this.type == BaseStateHandler.Type.SAVE) {
            S32xContainer container = new S32xContainer();
            for (int i = 0; i < 2; ++i) {
                b.rewind();
                Gs32xStateHandler.wrap.sh2Cache[i].saveContext(b);
                Gs32xStateHandler.wrap.sh2CacheCtx[i] = new byte[b.position()];
                b.rewind().get(Gs32xStateHandler.wrap.sh2CacheCtx[i]).rewind();
            }
            byte[] dt = Util.serializeObject((Serializable)wrap);
            container.dataMap.put(wrap.getClass().getSimpleName(), dt);
            for (Device d : s32xDeviceSet.values()) {
                d.saveContext(b);
                byte[] data = new byte[b.position()];
                b.rewind().get(data).rewind();
                container.dataMap.put(d.getClass().getSimpleName(), data);
            }
            this.buffer = Gs32xStateHandler.storeSerializedData(START_32X_TOKEN, END_32X_TOKEN, container, this.buffer);
        } else {
            int s32xStart = Bytes.indexOf((byte[])this.buffer.array(), (byte[])START_32X_TOKEN.getBytes()) + START_32X_TOKEN.length();
            int s32xEnd = Bytes.indexOf((byte[])this.buffer.array(), (byte[])END_32X_TOKEN.getBytes());
            if (s32xStart > 0 && s32xEnd > 0) {
                Serializable s = Util.deserializeObject((byte[])this.buffer.array(), (int)s32xStart, (int)s32xEnd);
                assert (s instanceof S32xContainer);
                S32xContainer container = (S32xContainer)s;
                byte[] data = container.dataMap.get(Sh2ContextWrap.class.getSimpleName());
                s = Util.deserializeObject((byte[])data, (int)0, (int)data.length);
                assert (s instanceof Sh2ContextWrap);
                Sh2ContextWrap w = (Sh2ContextWrap)s;
                for (int i = 0; i < 2; ++i) {
                    Gs32xStateHandler.wrap.sh2Ctx[i].loadContext(w.sh2Ctx[i]);
                    Gs32xStateHandler.wrap.sh2Cache[i].loadContext(ByteBuffer.wrap(w.sh2CacheCtx[i]));
                }
                for (Device d : s32xDeviceSet.values()) {
                    data = container.dataMap.get(d.getClass().getSimpleName());
                    d.loadContext(ByteBuffer.wrap(data));
                }
            }
            PollSysEventManager.instance.resetPoller(S32xUtil.CpuDeviceAccess.MASTER);
            PollSysEventManager.instance.resetPoller(S32xUtil.CpuDeviceAccess.SLAVE);
            Sh2Helper.clear();
            StaticBootstrapSupport.setNextCycleExt(S32xUtil.CpuDeviceAccess.MASTER, 0);
            StaticBootstrapSupport.setNextCycleExt(S32xUtil.CpuDeviceAccess.SLAVE, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static ByteBuffer storeSerializedData(String magicWordStart, String magicWordEnd, Serializable object, ByteBuffer buffer) {
        int prevPos = buffer.position();
        int len = magicWordStart.length() + magicWordEnd.length();
        byte[] data = Util.serializeObject((Serializable)object);
        buffer = StateUtil.extendBuffer((ByteBuffer)buffer, (int)(data.length + len));
        try {
            buffer.put(magicWordStart.getBytes());
            buffer.put(data);
            buffer.put(magicWordEnd.getBytes());
        }
        catch (Exception var10) {
            LOG.error("Unable to save {} data", (Object)magicWordStart);
        }
        finally {
            buffer.position(prevPos);
        }
        return buffer;
    }

    public static class Sh2ContextWrap
    implements Serializable {
        public Sh2Context[] sh2Ctx = new Sh2Context[2];
        public byte[][] sh2CacheCtx = new byte[2][];
        public transient Sh2Cache[] sh2Cache = new Sh2Cache[2];
    }

    static class S32xContainer
    implements Serializable {
        public Map<String, byte[]> dataMap = new LinkedHashMap<String, byte[]>();

        S32xContainer() {
        }
    }
}

