/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2.device;

import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import org.slf4j.Logger;
import s32x.dict.S32xDict;

public class DmaHelper {
    private static final Logger LOG = LogHelper.getLogger((String)DmaHelper.class.getSimpleName());
    private static final int FIFO_REG_SH2 = 0x20004000 + S32xDict.RegSpecS32x.SH2_FIFO_REG.addr;
    private static final DmaSrcDestMode[] modeVals = DmaSrcDestMode.values();
    private static final DmaTransferSize[] trnVals = DmaTransferSize.values();

    public static DmaChannelSetup createChannel(int channel) {
        DmaChannelSetup d = new DmaChannelSetup();
        d.channel = channel;
        return d;
    }

    public static void updateChannelDmaor(DmaChannelSetup chan, int dmaor) {
        boolean dme;
        chan.dmaor_dme = dme = (dmaor & 1) > 0;
    }

    public static void updateChannelControl(DmaChannelSetup c, int chcr) {
        c.chcr_dmaEn = (chcr & 1) > 0;
        c.chcr_tranEndOk = (chcr & 2) > 0;
        c.chcr_intEn = (chcr & 4) > 0;
        c.chcr_autoReq = (chcr >> 9 & 1) > 0;
        c.chcr_destMode = modeVals[chcr >> 14 & 3];
        c.chcr_srcMode = modeVals[chcr >> 12 & 3];
        c.chcr_transferSize = trnVals[chcr >> 10 & 3];
        c.srcDelta = DmaHelper.getAddressDelta(c.chcr_srcMode, c.chcr_transferSize, true);
        c.destDelta = DmaHelper.getAddressDelta(c.chcr_destMode, c.chcr_transferSize, false);
        if (c.chcr_transferSize == DmaTransferSize.BYTE_16) {
            c.trnSize = Size.LONG;
            c.transfersPerStep = 4;
        } else {
            c.trnSize = Size.vals[c.chcr_transferSize.ordinal()];
            c.transfersPerStep = 1;
        }
    }

    private static int getAddressDelta(DmaSrcDestMode mode, DmaTransferSize transferSize, boolean isSrc) {
        int d = mode.signMult * transferSize.byteSize;
        if (isSrc && mode == DmaSrcDestMode.FIXED && transferSize == DmaTransferSize.BYTE_16) {
            d = transferSize.byteSize;
        }
        return d;
    }

    public static class DmaChannelSetup {
        public int channel;
        public boolean chcr_dmaEn;
        public boolean chcr_intEn;
        public boolean chcr_autoReq;
        public boolean chcr_tranEndOk;
        public boolean dmaor_dme;
        public boolean dreqLevel;
        public DmaSrcDestMode chcr_destMode;
        public DmaSrcDestMode chcr_srcMode;
        public DmaTransferSize chcr_transferSize;
        public boolean dmaInProgress;
        public int srcDelta;
        public int destDelta;
        public int transfersPerStep;
        public Size trnSize;

        public String toString() {
            return "DmaChannelSetup{channel=" + this.channel + ", chcr_dmaEn=" + this.chcr_dmaEn + ", chcr_intEn=" + this.chcr_intEn + ", chcr_autoReq=" + this.chcr_autoReq + ", chcr_tranEndOk=" + this.chcr_tranEndOk + ", dmaor_dme=" + this.dmaor_dme + ", dreqLevel=" + this.dreqLevel + ", chcr_destMode=" + this.chcr_destMode + ", chcr_srcMode=" + this.chcr_srcMode + ", chcr_transferSize=" + this.chcr_transferSize + ", dmaInProgress=" + this.dmaInProgress + ", srcDelta=" + this.srcDelta + ", destDelta=" + this.destDelta + ", transfersPerStep=" + this.transfersPerStep + ", trnSize=" + this.trnSize + "}";
        }
    }

    static enum DmaSrcDestMode {
        FIXED(0),
        INCREMENT(1),
        DECREMENT(-1),
        ILLEGAL(0);

        public final int signMult;

        private DmaSrcDestMode(int s) {
            this.signMult = s;
        }
    }

    static enum DmaTransferSize {
        BYTE(1),
        WORD(2),
        LONG(4),
        BYTE_16(4);

        public final int byteSize;

        private DmaTransferSize(int s) {
            this.byteSize = s;
        }
    }
}

