/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2.device;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.dict.S32xDict;
import s32x.dict.Sh2Dict;
import s32x.sh2.device.IntControl;
import s32x.sh2.device.IntControlImplOld;
import s32x.sh2.device.Sh2DeviceHelper;
import s32x.util.S32xUtil;

public class IntControlImplNew
implements IntControl {
    private static final Logger LOG = LogHelper.getLogger((String)IntControlImplNew.class.getSimpleName());
    private static final boolean verbose = false;
    private final Map<Sh2DeviceHelper.Sh2DeviceType, Integer> onChipDevicePriority;
    private final Map<IntControl.Sh2InterruptSource, IntControl.InterruptContext> s32xInt;
    static final int VALID_BIT_POS = 0;
    static final int PENDING_BIT_POS = 1;
    static final int TRIGGER_BIT_POS = 2;
    static final int INT_VALID_MASK = 1;
    static final int INT_PENDING_MASK = 2;
    static final int INT_TRIGGER_MASK = 4;
    private IntControl.InterruptContext currentInterrupt = LEV_0;
    private final ByteBuffer sh2_int_mask = ByteBuffer.allocate(2);
    private final ByteBuffer regs;
    private final S32xUtil.CpuDeviceAccess cpu;
    private static final boolean legacy = true;

    public static IntControl createInstance(S32xUtil.CpuDeviceAccess cpu, ByteBuffer regs) {
        return new IntControlImplOld(cpu, regs);
    }

    public IntControlImplNew(S32xUtil.CpuDeviceAccess cpu, ByteBuffer regs) {
        this.regs = regs;
        this.cpu = cpu;
        this.s32xInt = new HashMap<IntControl.Sh2InterruptSource, IntControl.InterruptContext>(IntControl.Sh2InterruptSource.values().length);
        this.onChipDevicePriority = new HashMap<Sh2DeviceHelper.Sh2DeviceType, Integer>();
        this.init();
    }

    public void init() {
        this.s32xInt.clear();
        this.onChipDevicePriority.clear();
        Arrays.stream(Sh2DeviceHelper.Sh2DeviceType.values()).forEach(d -> this.onChipDevicePriority.put((Sh2DeviceHelper.Sh2DeviceType)((Object)d), 0));
        Arrays.stream(IntControl.Sh2InterruptSource.values()).forEach(s -> {
            IntControl.InterruptContext intCtx = new IntControl.InterruptContext();
            intCtx.source = s;
            this.s32xInt.put((IntControl.Sh2InterruptSource)((Object)s), intCtx);
        });
        this.setIntsMasked(0);
    }

    @Override
    public void write(Sh2Dict.RegSpecSh2 regSpec, int pos, int value, Size size) {
        int val = 0;
        S32xUtil.writeBufferRaw(this.regs, pos, value, size);
        switch (regSpec) {
            case INTC_IPRA: {
                val = S32xUtil.readBuffer(this.regs, regSpec.addr, Size.WORD);
                this.onChipDevicePriority.put(Sh2DeviceHelper.Sh2DeviceType.DIV, val >> 12 & 0xF);
                this.onChipDevicePriority.put(Sh2DeviceHelper.Sh2DeviceType.DMA, val >> 8 & 0xF);
                this.onChipDevicePriority.put(Sh2DeviceHelper.Sh2DeviceType.WDT, val >> 4 & 0xF);
                this.logExternalIntLevel(regSpec, val);
                break;
            }
            case INTC_IPRB: {
                val = S32xUtil.readBuffer(this.regs, regSpec.addr, Size.WORD);
                this.onChipDevicePriority.put(Sh2DeviceHelper.Sh2DeviceType.SCI, val >> 12 & 0xF);
                this.onChipDevicePriority.put(Sh2DeviceHelper.Sh2DeviceType.FRT, val >> 8 & 0xF);
                this.logExternalIntLevel(regSpec, val);
                break;
            }
            case INTC_ICR: {
                val = S32xUtil.readBuffer(this.regs, regSpec.addr, Size.WORD);
                if ((val & 1) <= 0) break;
                LOG.error("{} Not supported: IRL Interrupt vector mode: External Vector", (Object)this.cpu);
                break;
            }
            case INTC_VCRA: 
            case INTC_VCRB: 
            case INTC_VCRC: 
            case INTC_VCRD: {
                LOG.error("{} Not supported: {}, val {} {}", new Object[]{this.cpu, regSpec.getName(), Util.th((int)value), size});
            }
        }
    }

    @Override
    public int read(Sh2Dict.RegSpecSh2 regSpec, int reg, Size size) {
        return S32xUtil.readBuffer(this.regs, reg, size);
    }

    private IntControl.InterruptContext getContextFromExternalInterrupt(IntControl.Sh2Interrupt intp) {
        IntControl.InterruptContext source = null;
        for (Map.Entry<IntControl.Sh2InterruptSource, IntControl.InterruptContext> e : this.s32xInt.entrySet()) {
            if (e.getKey().externalInterrupt != intp) continue;
            source = e.getValue();
            break;
        }
        assert (source != null);
        return source;
    }

    private void setIntMasked(int ipt, int isValid) {
        boolean change;
        IntControl.Sh2Interrupt sh2Interrupt = intVals[ipt];
        IntControl.InterruptContext source = this.getContextFromExternalInterrupt(sh2Interrupt);
        boolean bl = change = (source.intState & 1) != isValid;
        if (change) {
            IntControlImplNew.setBit(source, 0, isValid);
            if (ipt == IntControl.Sh2Interrupt.CMD_8.ordinal()) {
                IntControlImplNew.setBit(source, 2, isValid > 0 && (source.intState & 2) > 0);
            }
            this.resetInterruptLevel();
            this.logInfo("MASK", source);
        }
    }

    @Override
    public void setIntsMasked(int value) {
        for (int i = 0; i < 4; ++i) {
            int imask = value & 1 << i;
            int sh2Int = 6 + (i << 1);
            this.setIntMasked(sh2Int, imask > 0 ? 1 : 0);
        }
    }

    @Override
    public void reloadSh2IntMask() {
        int newVal = S32xUtil.readBuffer(this.sh2_int_mask, S32xDict.RegSpecS32x.SH2_INT_MASK.addr, Size.WORD);
        this.setIntsMasked(newVal & 0xF);
    }

    @Override
    public void setIntPending(IntControl.Sh2Interrupt interrupt, boolean isPending) {
        this.setIntPending(interrupt.ordinal(), isPending);
    }

    @Override
    public void setOnChipDeviceIntPending(Sh2DeviceHelper.Sh2DeviceType deviceType, IntControl.OnChipSubType subType) {
        int level = this.onChipDevicePriority.get((Object)deviceType);
        IntControl.Sh2InterruptSource source = IntControl.Sh2InterruptSource.getSh2InterruptSource(deviceType, subType);
        assert (source != null);
        IntControl.InterruptContext intCtx = this.s32xInt.get((Object)source);
        assert (intCtx != null);
        intCtx.source = source;
        intCtx.level = this.onChipDevicePriority.get((Object)deviceType);
        if (level > 0) {
            IntControlImplNew.setBit(intCtx, 1, 1);
            IntControlImplNew.setBit(intCtx, 2, 1);
            this.resetInterruptLevel();
        }
    }

    @Override
    public int readSh2IntMaskReg(int pos, Size size) {
        return S32xUtil.readBuffer(this.sh2_int_mask, pos, size);
    }

    private void setIntPending(int ipt, boolean isPending) {
        boolean val;
        IntControl.InterruptContext source = this.getContextFromExternalInterrupt(intVals[ipt]);
        boolean bl = val = (source.intState & 2) > 0;
        if (val != isPending) {
            boolean valid;
            boolean bl2 = valid = (source.intState & 1) > 0;
            if (valid) {
                IntControlImplNew.setBit(source, 1, isPending);
                if (valid && isPending) {
                    IntControlImplNew.setBit(source, 2, 1);
                    source.level = ipt;
                    this.resetInterruptLevel();
                } else {
                    IntControlImplNew.setBit(source, 2, 0);
                }
                this.logInfo("PENDING", source);
            }
        }
    }

    private void resetInterruptLevel() {
        int maxLevel = this.s32xInt.values().stream().filter(s -> s.intState > 4).max((c1, c2) -> Integer.compare(c1.level, c2.level)).map(ctx -> ctx.level).orElse(0);
        assert (maxLevel >= 0);
        if (maxLevel > 0) {
            IntControl.InterruptContext ctx2 = Arrays.stream(IntControl.Sh2InterruptSource.vals).map(this.s32xInt::get).filter(ic -> ic.level == maxLevel).findFirst().orElse(null);
            assert (ctx2 != null);
            this.currentInterrupt = ctx2;
        } else {
            this.currentInterrupt = LEV_0;
        }
        assert (this.currentInterrupt.level != IntControl.Sh2Interrupt.VRES_14.ordinal());
    }

    @Override
    public void clearInterrupt(IntControl.Sh2Interrupt intType) {
        this.clearInterrupt(this.getContextFromExternalInterrupt(intType));
    }

    public void clearInterrupt(IntControl.InterruptContext source) {
        source.intState &= 0xFFFFFFF9;
        source.level = 0;
        this.resetInterruptLevel();
        this.logInfo("CLEAR", source);
    }

    @Override
    public void clearCurrentInterrupt() {
        this.clearInterrupt(this.currentInterrupt);
        this.currentInterrupt = LEV_0;
    }

    @Override
    public IntControl.InterruptContext getInterruptContext() {
        return this.currentInterrupt;
    }

    @Override
    public int getVectorNumber() {
        if (this.currentInterrupt.source.externalInterrupt.internal == 0) {
            return this.getOnChipDeviceVectorNumber(this.currentInterrupt);
        }
        return 64 + (this.currentInterrupt.level >> 1);
    }

    private int getOnChipDeviceVectorNumber(IntControl.InterruptContext ctx) {
        int vn = -1;
        switch (ctx.source.deviceType) {
            case DMA: {
                int offset = ctx.source.subType == IntControl.OnChipSubType.DMA_C0 ? 0 : 1;
                vn = S32xUtil.readBuffer(this.regs, Sh2Dict.RegSpecSh2.INTC_VCRDMA0.addr + (offset << 3), Size.LONG) & 0xFF;
                break;
            }
            case WDT: {
                vn = S32xUtil.readBuffer(this.regs, Sh2Dict.RegSpecSh2.INTC_VCRWDT.addr, Size.BYTE) & 0xFF;
                break;
            }
            case DIV: {
                vn = S32xUtil.readBuffer(this.regs, Sh2Dict.RegSpecSh2.INTC_VCRDIV.addr, Size.BYTE) & 0xFF;
                break;
            }
            case SCI: {
                int pos = ctx.source.subType == IntControl.OnChipSubType.RXI ? Sh2Dict.RegSpecSh2.INTC_VCRA.addr + 1 : Sh2Dict.RegSpecSh2.INTC_VCRB.addr;
                vn = S32xUtil.readBuffer(this.regs, pos, Size.BYTE) & 0xFF;
                break;
            }
            case NONE: {
                break;
            }
            default: {
                LOG.error("{} Unhandled interrupt for device: {}, level: {}", new Object[]{this.cpu, ctx.source.deviceType, ctx.level});
            }
        }
        return vn;
    }

    @Override
    public ByteBuffer getSh2_int_mask_regs() {
        return this.sh2_int_mask;
    }

    private void logInfo(String action, IntControl.InterruptContext source) {
    }

    private void logExternalIntLevel(Sh2Dict.RegSpecSh2 regSpec, int val) {
        if (regSpec == Sh2Dict.RegSpecSh2.INTC_IPRA) {
            LOG.info("{} set IPRA levels, {}:{}, {}:{}, {}:{}", new Object[]{this.cpu, Sh2DeviceHelper.Sh2DeviceType.DIV, val >> 12, Sh2DeviceHelper.Sh2DeviceType.DMA, val >> 8 & 0xF, Sh2DeviceHelper.Sh2DeviceType.WDT, val >> 4 & 0xF});
        } else if (regSpec == Sh2Dict.RegSpecSh2.INTC_IPRB) {
            LOG.info("{} set IPRB levels, {}:{}, {}:{}", new Object[]{this.cpu, Sh2DeviceHelper.Sh2DeviceType.SCI, val >> 12, Sh2DeviceHelper.Sh2DeviceType.FRT, val >> 8 & 0xF});
        }
    }

    private static void setBit(IntControl.InterruptContext ctx, int bitPos, boolean bitValue) {
        IntControlImplNew.setBit(ctx, bitPos, bitValue ? 1 : 0);
    }

    private static void setBit(IntControl.InterruptContext ctx, int bitPos, int bitValue) {
        ctx.intState = ctx.intState & ~(1 << bitPos) | bitValue << bitPos;
    }

    public void reset() {
        S32xUtil.writeRegBuffer(Sh2Dict.RegSpecSh2.INTC_IPRA, this.regs, 0, Size.WORD);
        S32xUtil.writeRegBuffer(Sh2Dict.RegSpecSh2.INTC_IPRB, this.regs, 0, Size.WORD);
        S32xUtil.writeRegBuffer(Sh2Dict.RegSpecSh2.INTC_VCRA, this.regs, 0, Size.WORD);
        S32xUtil.writeRegBuffer(Sh2Dict.RegSpecSh2.INTC_VCRB, this.regs, 0, Size.WORD);
        S32xUtil.writeRegBuffer(Sh2Dict.RegSpecSh2.INTC_VCRC, this.regs, 0, Size.WORD);
        S32xUtil.writeRegBuffer(Sh2Dict.RegSpecSh2.INTC_VCRD, this.regs, 0, Size.WORD);
        S32xUtil.writeRegBuffer(Sh2Dict.RegSpecSh2.INTC_VCRWDT, this.regs, 0, Size.WORD);
        S32xUtil.writeRegBuffer(Sh2Dict.RegSpecSh2.INTC_VCRDIV, this.regs, 0, Size.WORD);
        S32xUtil.writeRegBuffer(Sh2Dict.RegSpecSh2.INTC_VCRDMA0, this.regs, 0, Size.WORD);
        S32xUtil.writeRegBuffer(Sh2Dict.RegSpecSh2.INTC_VCRDMA1, this.regs, 0, Size.WORD);
        S32xUtil.writeRegBuffer(Sh2Dict.RegSpecSh2.INTC_ICR, this.regs, 0, Size.WORD);
    }
}

