/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2.device;

import s32x.DmaFifo68k;
import s32x.Sh2MMREG;
import s32x.bus.Sh2Bus;
import s32x.sh2.device.DivUnit;
import s32x.sh2.device.DmaC;
import s32x.sh2.device.IntControl;
import s32x.sh2.device.IntControlImplNew;
import s32x.sh2.device.SerialCommInterface;
import s32x.sh2.device.WatchdogTimer;
import s32x.util.MarsLauncherHelper;
import s32x.util.S32xUtil;

public class Sh2DeviceHelper {
    public static Sh2DeviceContext createDevices(S32xUtil.CpuDeviceAccess cpu, MarsLauncherHelper.Sh2LaunchContext ctx) {
        return Sh2DeviceHelper.createDevices(cpu, ctx.memory, ctx.dmaFifo68k, ctx.memory.getSh2MMREGS(cpu));
    }

    public static Sh2DeviceContext createDevices(S32xUtil.CpuDeviceAccess cpu, Sh2Bus memory, DmaFifo68k dmaFifo68k, Sh2MMREG sh2Regs) {
        Sh2DeviceContext ctx = new Sh2DeviceContext();
        ctx.cpu = cpu;
        ctx.sh2MMREG = sh2Regs;
        ctx.intC = IntControlImplNew.createInstance(cpu, sh2Regs.getRegs());
        ctx.dmaC = new DmaC(cpu, ctx.intC, memory, dmaFifo68k, sh2Regs.getRegs());
        ctx.sci = new SerialCommInterface(cpu, ctx.intC, sh2Regs.getRegs());
        ctx.divUnit = new DivUnit(cpu, ctx.intC, sh2Regs.getRegs());
        ctx.wdt = new WatchdogTimer(cpu, ctx.intC, sh2Regs.getRegs());
        return ctx;
    }

    public static class Sh2DeviceContext {
        public S32xUtil.CpuDeviceAccess cpu;
        public IntControl intC;
        public DmaC dmaC;
        public SerialCommInterface sci;
        public DivUnit divUnit;
        public WatchdogTimer wdt;
        public Sh2MMREG sh2MMREG;
    }

    public static enum Sh2DeviceType {
        NONE,
        UBC,
        FRT,
        BSC,
        DMA,
        INTC,
        DIV,
        SCI,
        WDT;

    }
}

