/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2.device;

import java.nio.ByteBuffer;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.dict.Sh2Dict;
import s32x.sh2.device.IntControl;
import s32x.sh2.device.Sh2DeviceHelper;
import s32x.util.S32xUtil;

public class WatchdogTimer
implements S32xUtil.Sh2Device {
    private static final Logger LOG = LogHelper.getLogger((String)WatchdogTimer.class.getSimpleName());
    private static final int ADDR_WRITE_80 = 128;
    private static final int ADDR_WRITE_82 = 130;
    private static final int WTCSR_ADDR_READ = 128;
    private static final int WTCNT_ADDR_READ = 129;
    private static final int RSTCSR_ADDR_READ = 131;
    private static final int WRITE_MSB_5A = 90;
    private static final int WRITE_MSB_A5 = 165;
    private static final int WOVF_BIT_POS = 7;
    private static final int OVF_BIT_POS = 7;
    private static final int RSTE_BIT_POS = 6;
    private static final int RSTS_BIT_POS = 5;
    private static final int TME_BIT_POS = 5;
    private static final int WT_IT_BIT_POS = 6;
    private static final int[] clockDivs = new int[]{2, 64, 128, 256, 512, 1024, 4096, 8192};
    private static final boolean verbose = false;
    private final ByteBuffer regs;
    private final S32xUtil.CpuDeviceAccess cpu;
    private final IntControl intControl;
    private boolean wdtTimerEnable;
    private boolean timerMode = true;
    private int count = 0;
    private int clockDivider = 2;
    private int sh2TicksToNextWdtClock;

    public WatchdogTimer(S32xUtil.CpuDeviceAccess cpu, IntControl intC, ByteBuffer regs) {
        this.cpu = cpu;
        this.regs = regs;
        this.intControl = intC;
        this.reset();
    }

    @Override
    public int read(Sh2Dict.RegSpecSh2 regSpec, int address, Size size) {
        if (size != Size.BYTE) {
            LOG.error("{} WDT read {}: {}", new Object[]{this.cpu, regSpec.getName(), size});
            throw new RuntimeException();
        }
        assert (address == regSpec.addr) : Util.th((int)address) + ", " + Util.th((int)regSpec.addr);
        if (address == 129) {
            S32xUtil.writeBufferRaw(this.regs, 129, this.count, Size.BYTE);
        }
        return S32xUtil.readBuffer(this.regs, address, size);
    }

    @Override
    public void write(Sh2Dict.RegSpecSh2 regSpec, int pos, int value, Size size) {
        if (size != Size.WORD) {
            LOG.error("{} WDT write {}: {}", new Object[]{this.cpu, regSpec.getName(), size});
            throw new RuntimeException();
        }
        assert (pos == regSpec.addr) : Util.th((int)pos) + ", " + Util.th((int)regSpec.addr);
        switch (regSpec.addr) {
            case 128: {
                this.handleWrite80(value);
                break;
            }
            case 130: {
                this.handleWrite82(value);
            }
        }
    }

    private void handleWrite82(int value) {
        int msb = value >> 8;
        switch (msb) {
            case 90: {
                if ((value & 0xFF) == 0) {
                    S32xUtil.setBit(this.regs, 131, 7, 0, Size.BYTE);
                    break;
                }
                LOG.error("{} WDT write, addr {}, unexpected LSB, should be zero: {}", new Object[]{this.cpu, Util.th((int)130), Util.th((int)(value & 0xFF))});
                break;
            }
            case 165: {
                int rste = value >> 6 & 1;
                int rsts = value >> 5 & 1;
                S32xUtil.setBit(this.regs, 131, 6, rste, Size.BYTE);
                S32xUtil.setBit(this.regs, 131, 5, rsts, Size.BYTE);
                assert (rste == 0);
                break;
            }
            default: {
                LOG.error("{} WDT write, addr {}, unexpected MSB: {}", new Object[]{this.cpu, Util.th((int)130), Util.th((int)msb)});
            }
        }
    }

    private void handleWrite80(int value) {
        int msb = value >> 8;
        switch (msb) {
            case 165: {
                S32xUtil.writeBufferRaw(this.regs, 128, value & 0xFF, Size.BYTE);
                this.handleTimerEnable(value);
                break;
            }
            case 90: {
                S32xUtil.writeBufferRaw(this.regs, 129, value & 0xFF, Size.BYTE);
                this.count = value & 0xFF;
                break;
            }
            default: {
                LOG.error("{} WDT write, addr {}, unexpected MSB: {}", new Object[]{this.cpu, 128, msb});
            }
        }
    }

    private void handleTimerEnable(int value) {
        this.timerMode = (value >> 6 & 1) == 0;
        this.wdtTimerEnable = (value >> 5 & 1) > 0;
        this.sh2TicksToNextWdtClock = this.clockDivider = clockDivs[value & 7];
        if (!this.wdtTimerEnable) {
            S32xUtil.writeBufferRaw(this.regs, 129, 0, Size.BYTE);
        }
        assert (!this.wdtTimerEnable || this.timerMode);
    }

    @Override
    public void step(int cycles) {
        if (this.wdtTimerEnable) {
            while (cycles-- > 0) {
                this.stepOne();
            }
        }
    }

    private void stepOne() {
        assert (this.sh2TicksToNextWdtClock > 0);
        if (--this.sh2TicksToNextWdtClock == 0) {
            this.sh2TicksToNextWdtClock = this.clockDivider;
            int cnt = this.increaseCount();
            if (cnt == 0) {
                S32xUtil.setBit(this.regs, 128, 7, 1, Size.BYTE);
                this.intControl.setOnChipDeviceIntPending(Sh2DeviceHelper.Sh2DeviceType.WDT);
            }
        }
    }

    private int increaseCount() {
        this.count = this.count + 1 & 0xFF;
        return this.count;
    }

    public void reset() {
        S32xUtil.writeBufferRaw(this.regs, 128, 24, Size.BYTE);
        S32xUtil.writeBufferRaw(this.regs, 129, 0, Size.BYTE);
        S32xUtil.writeBufferRaw(this.regs, 131, 31, Size.BYTE);
        this.handleTimerEnable(24);
        this.count = 0;
    }
}

