/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2.drc;

import java.io.PrintStream;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import s32x.sh2.Sh2Context;
import s32x.sh2.drc.Ow2Sh2BlockRecompiler;
import s32x.sh2.drc.Ow2Sh2Bytecode;
import s32x.sh2.prefetch.Sh2Prefetch;

public class Ow2Sh2Helper {
    private static final Logger LOG = LogHelper.getLogger((String)Ow2Sh2Helper.class.getSimpleName());

    public static void createInst(Sh2Prefetch.BytecodeContext ctx) {
        switch (ctx.sh2Inst) {
            case ADD: {
                Ow2Sh2Bytecode.ADD(ctx);
                break;
            }
            case ADDC: {
                Ow2Sh2Bytecode.ADDC(ctx);
                break;
            }
            case ADDI: {
                Ow2Sh2Bytecode.ADDI(ctx);
                break;
            }
            case ADDV: {
                Ow2Sh2Bytecode.ADDV(ctx);
                break;
            }
            case AND: {
                Ow2Sh2Bytecode.AND(ctx);
                break;
            }
            case ANDI: {
                Ow2Sh2Bytecode.ANDI(ctx);
                break;
            }
            case ANDM: {
                Ow2Sh2Bytecode.ANDM(ctx);
                break;
            }
            case BF: {
                Ow2Sh2Bytecode.BF(ctx);
                break;
            }
            case BFS: {
                Ow2Sh2Bytecode.BFS(ctx);
                break;
            }
            case BRA: {
                Ow2Sh2Bytecode.BRA(ctx);
                break;
            }
            case BRAF: {
                Ow2Sh2Bytecode.BRAF(ctx);
                break;
            }
            case BSR: {
                Ow2Sh2Bytecode.BSR(ctx);
                break;
            }
            case BSRF: {
                Ow2Sh2Bytecode.BSRF(ctx);
                break;
            }
            case BT: {
                Ow2Sh2Bytecode.BT(ctx);
                break;
            }
            case BTS: {
                Ow2Sh2Bytecode.BTS(ctx);
                break;
            }
            case CLRMAC: {
                Ow2Sh2Bytecode.CLRMAC(ctx);
                break;
            }
            case CLRT: {
                Ow2Sh2Bytecode.CLRT(ctx);
                break;
            }
            case CMPEQ: {
                Ow2Sh2Bytecode.CMPEQ(ctx);
                break;
            }
            case CMPGE: {
                Ow2Sh2Bytecode.CMPGE(ctx);
                break;
            }
            case CMPGT: {
                Ow2Sh2Bytecode.CMPGT(ctx);
                break;
            }
            case CMPHI: {
                Ow2Sh2Bytecode.CMPHI(ctx);
                break;
            }
            case CMPHS: {
                Ow2Sh2Bytecode.CMPHS(ctx);
                break;
            }
            case CMPIM: {
                Ow2Sh2Bytecode.CMPIM(ctx);
                break;
            }
            case CMPPL: {
                Ow2Sh2Bytecode.CMPPL(ctx);
                break;
            }
            case CMPPZ: {
                Ow2Sh2Bytecode.CMPPZ(ctx);
                break;
            }
            case CMPSTR: {
                Ow2Sh2Bytecode.CMPSTR(ctx);
                break;
            }
            case DIV0S: {
                Ow2Sh2Bytecode.DIV0S(ctx);
                break;
            }
            case DIV0U: {
                Ow2Sh2Bytecode.DIV0U(ctx);
                break;
            }
            case DIV1: {
                Ow2Sh2Bytecode.DIV1(ctx);
                break;
            }
            case DMULS: {
                Ow2Sh2Bytecode.DMULS(ctx);
                break;
            }
            case DMULU: {
                Ow2Sh2Bytecode.DMULU(ctx);
                break;
            }
            case DT: {
                Ow2Sh2Bytecode.DT(ctx);
                break;
            }
            case EXTSB: {
                Ow2Sh2Bytecode.EXTSB(ctx);
                break;
            }
            case EXTSW: {
                Ow2Sh2Bytecode.EXTSW(ctx);
                break;
            }
            case EXTUB: {
                Ow2Sh2Bytecode.EXTUB(ctx);
                break;
            }
            case EXTUW: {
                Ow2Sh2Bytecode.EXTUW(ctx);
                break;
            }
            case ILLEGAL: {
                Ow2Sh2Bytecode.ILLEGAL(ctx);
                break;
            }
            case JMP: {
                Ow2Sh2Bytecode.JMP(ctx);
                break;
            }
            case JSR: {
                Ow2Sh2Bytecode.JSR(ctx);
                break;
            }
            case LDCGBR: {
                Ow2Sh2Bytecode.LDCGBR(ctx);
                break;
            }
            case LDCMGBR: {
                Ow2Sh2Bytecode.LDCMGBR(ctx);
                break;
            }
            case LDCMSR: {
                Ow2Sh2Bytecode.LDCMSR(ctx);
                break;
            }
            case LDCMVBR: {
                Ow2Sh2Bytecode.LDCMVBR(ctx);
                break;
            }
            case LDCSR: {
                Ow2Sh2Bytecode.LDCSR(ctx);
                break;
            }
            case LDCVBR: {
                Ow2Sh2Bytecode.LDCVBR(ctx);
                break;
            }
            case LDSMACH: {
                Ow2Sh2Bytecode.LDSMACH(ctx);
                break;
            }
            case LDSMACL: {
                Ow2Sh2Bytecode.LDSMACL(ctx);
                break;
            }
            case LDSMMACH: {
                Ow2Sh2Bytecode.LDSMMACH(ctx);
                break;
            }
            case LDSMMACL: {
                Ow2Sh2Bytecode.LDSMMACL(ctx);
                break;
            }
            case LDSMPR: {
                Ow2Sh2Bytecode.LDSMPR(ctx);
                break;
            }
            case LDSPR: {
                Ow2Sh2Bytecode.LDSPR(ctx);
                break;
            }
            case MACL: {
                Ow2Sh2Bytecode.MACL(ctx);
                break;
            }
            case MACW: {
                Ow2Sh2Bytecode.MACW(ctx);
                break;
            }
            case MOV: {
                Ow2Sh2Bytecode.MOV(ctx);
                break;
            }
            case MOVA: {
                Ow2Sh2Bytecode.MOVA(ctx);
                break;
            }
            case MOVBL: {
                Ow2Sh2Bytecode.MOVBL(ctx);
                break;
            }
            case MOVBL0: {
                Ow2Sh2Bytecode.MOVBL0(ctx);
                break;
            }
            case MOVBL4: {
                Ow2Sh2Bytecode.MOVBL4(ctx);
                break;
            }
            case MOVBLG: {
                Ow2Sh2Bytecode.MOVBLG(ctx);
                break;
            }
            case MOVBM: {
                Ow2Sh2Bytecode.MOVBM(ctx);
                break;
            }
            case MOVBP: {
                Ow2Sh2Bytecode.MOVBP(ctx);
                break;
            }
            case MOVBS: {
                Ow2Sh2Bytecode.MOVBS(ctx);
                break;
            }
            case MOVBS0: {
                Ow2Sh2Bytecode.MOVBS0(ctx);
                break;
            }
            case MOVBS4: {
                Ow2Sh2Bytecode.MOVBS4(ctx);
                break;
            }
            case MOVBSG: {
                Ow2Sh2Bytecode.MOVBSG(ctx);
                break;
            }
            case MOVI: {
                Ow2Sh2Bytecode.MOVI(ctx);
                break;
            }
            case MOVLI: {
                Ow2Sh2Bytecode.MOVLI(ctx);
                break;
            }
            case MOVLL: {
                Ow2Sh2Bytecode.MOVLL(ctx);
                break;
            }
            case MOVLL0: {
                Ow2Sh2Bytecode.MOVLL0(ctx);
                break;
            }
            case MOVLL4: {
                Ow2Sh2Bytecode.MOVLL4(ctx);
                break;
            }
            case MOVLLG: {
                Ow2Sh2Bytecode.MOVLLG(ctx);
                break;
            }
            case MOVLM: {
                Ow2Sh2Bytecode.MOVLM(ctx);
                break;
            }
            case MOVLP: {
                Ow2Sh2Bytecode.MOVLP(ctx);
                break;
            }
            case MOVLS: {
                Ow2Sh2Bytecode.MOVLS(ctx);
                break;
            }
            case MOVLS0: {
                Ow2Sh2Bytecode.MOVLS0(ctx);
                break;
            }
            case MOVLS4: {
                Ow2Sh2Bytecode.MOVLS4(ctx);
                break;
            }
            case MOVLSG: {
                Ow2Sh2Bytecode.MOVLSG(ctx);
                break;
            }
            case MOVT: {
                Ow2Sh2Bytecode.MOVT(ctx);
                break;
            }
            case MOVWI: {
                Ow2Sh2Bytecode.MOVWI(ctx);
                break;
            }
            case MOVWL: {
                Ow2Sh2Bytecode.MOVWL(ctx);
                break;
            }
            case MOVWL0: {
                Ow2Sh2Bytecode.MOVWL0(ctx);
                break;
            }
            case MOVWL4: {
                Ow2Sh2Bytecode.MOVWL4(ctx);
                break;
            }
            case MOVWLG: {
                Ow2Sh2Bytecode.MOVWLG(ctx);
                break;
            }
            case MOVWM: {
                Ow2Sh2Bytecode.MOVWM(ctx);
                break;
            }
            case MOVWP: {
                Ow2Sh2Bytecode.MOVWP(ctx);
                break;
            }
            case MOVWS: {
                Ow2Sh2Bytecode.MOVWS(ctx);
                break;
            }
            case MOVWS0: {
                Ow2Sh2Bytecode.MOVWS0(ctx);
                break;
            }
            case MOVWS4: {
                Ow2Sh2Bytecode.MOVWS4(ctx);
                break;
            }
            case MOVWSG: {
                Ow2Sh2Bytecode.MOVWSG(ctx);
                break;
            }
            case MULL: {
                Ow2Sh2Bytecode.MULL(ctx);
                break;
            }
            case MULSU: {
                Ow2Sh2Bytecode.MULSU(ctx);
                break;
            }
            case MULSW: {
                Ow2Sh2Bytecode.MULSW(ctx);
                break;
            }
            case NEG: {
                Ow2Sh2Bytecode.NEG(ctx);
                break;
            }
            case NEGC: {
                Ow2Sh2Bytecode.NEGC(ctx);
                break;
            }
            case NOP: {
                Ow2Sh2Bytecode.NOP(ctx);
                break;
            }
            case NOT: {
                Ow2Sh2Bytecode.NOT(ctx);
                break;
            }
            case OR: {
                Ow2Sh2Bytecode.OR(ctx);
                break;
            }
            case ORI: {
                Ow2Sh2Bytecode.ORI(ctx);
                break;
            }
            case ORM: {
                Ow2Sh2Bytecode.ORM(ctx);
                break;
            }
            case ROTCL: {
                Ow2Sh2Bytecode.ROTCL(ctx);
                break;
            }
            case ROTCR: {
                Ow2Sh2Bytecode.ROTCR(ctx);
                break;
            }
            case ROTL: {
                Ow2Sh2Bytecode.ROTL(ctx);
                break;
            }
            case ROTR: {
                Ow2Sh2Bytecode.ROTR(ctx);
                break;
            }
            case RTE: {
                Ow2Sh2Bytecode.RTE(ctx);
                break;
            }
            case RTS: {
                Ow2Sh2Bytecode.RTS(ctx);
                break;
            }
            case SETT: {
                Ow2Sh2Bytecode.SETT(ctx);
                break;
            }
            case SHAL: {
                Ow2Sh2Bytecode.SHAL(ctx);
                break;
            }
            case SHAR: {
                Ow2Sh2Bytecode.SHAR(ctx);
                break;
            }
            case SHLL: {
                Ow2Sh2Bytecode.SHLL(ctx);
                break;
            }
            case SHLL16: {
                Ow2Sh2Bytecode.SHLL16(ctx);
                break;
            }
            case SHLL2: {
                Ow2Sh2Bytecode.SHLL2(ctx);
                break;
            }
            case SHLL8: {
                Ow2Sh2Bytecode.SHLL8(ctx);
                break;
            }
            case SHLR: {
                Ow2Sh2Bytecode.SHLR(ctx);
                break;
            }
            case SHLR16: {
                Ow2Sh2Bytecode.SHLR16(ctx);
                break;
            }
            case SHLR2: {
                Ow2Sh2Bytecode.SHLR2(ctx);
                break;
            }
            case SHLR8: {
                Ow2Sh2Bytecode.SHLR8(ctx);
                break;
            }
            case SLEEP: {
                Ow2Sh2Bytecode.SLEEP(ctx);
                break;
            }
            case STCGBR: {
                Ow2Sh2Bytecode.STCGBR(ctx);
                break;
            }
            case STCMGBR: {
                Ow2Sh2Bytecode.STCMGBR(ctx);
                break;
            }
            case STCMSR: {
                Ow2Sh2Bytecode.STCMSR(ctx);
                break;
            }
            case STCMVBR: {
                Ow2Sh2Bytecode.STCMVBR(ctx);
                break;
            }
            case STCSR: {
                Ow2Sh2Bytecode.STCSR(ctx);
                break;
            }
            case STCVBR: {
                Ow2Sh2Bytecode.STCVBR(ctx);
                break;
            }
            case STSMACH: {
                Ow2Sh2Bytecode.STSMACH(ctx);
                break;
            }
            case STSMACL: {
                Ow2Sh2Bytecode.STSMACL(ctx);
                break;
            }
            case STSMMACH: {
                Ow2Sh2Bytecode.STSMMACH(ctx);
                break;
            }
            case STSMMACL: {
                Ow2Sh2Bytecode.STSMMACL(ctx);
                break;
            }
            case STSMPR: {
                Ow2Sh2Bytecode.STSMPR(ctx);
                break;
            }
            case STSPR: {
                Ow2Sh2Bytecode.STSPR(ctx);
                break;
            }
            case SUB: {
                Ow2Sh2Bytecode.SUB(ctx);
                break;
            }
            case SUBC: {
                Ow2Sh2Bytecode.SUBC(ctx);
                break;
            }
            case SUBV: {
                Ow2Sh2Bytecode.SUBV(ctx);
                break;
            }
            case SWAPB: {
                Ow2Sh2Bytecode.SWAPB(ctx);
                break;
            }
            case SWAPW: {
                Ow2Sh2Bytecode.SWAPW(ctx);
                break;
            }
            case TAS: {
                Ow2Sh2Bytecode.TAS(ctx);
                break;
            }
            case TRAPA: {
                Ow2Sh2Bytecode.TRAPA(ctx);
                break;
            }
            case TST: {
                Ow2Sh2Bytecode.TST(ctx);
                break;
            }
            case TSTI: {
                Ow2Sh2Bytecode.TSTI(ctx);
                break;
            }
            case TSTM: {
                Ow2Sh2Bytecode.TSTM(ctx);
                break;
            }
            case XOR: {
                Ow2Sh2Bytecode.XOR(ctx);
                break;
            }
            case XORI: {
                Ow2Sh2Bytecode.XORI(ctx);
                break;
            }
            case XORM: {
                Ow2Sh2Bytecode.XORM(ctx);
                break;
            }
            case XTRCT: {
                Ow2Sh2Bytecode.XTRCT(ctx);
                break;
            }
            default: {
                LOG.warn("Fallback: {}", (Object)ctx.sh2Inst);
                System.out.println("Fallback: " + ctx.sh2Inst);
                Ow2Sh2Bytecode.fallback(ctx);
            }
        }
    }

    public static void printString(Sh2Prefetch.BytecodeContext ctx, String str) {
        ctx.mv.visitFieldInsn(178, Type.getInternalName(System.class), "out", Type.getDescriptor(PrintStream.class));
        ctx.mv.visitLdcInsn((Object)str);
        ctx.mv.visitMethodInsn(182, Type.getInternalName(PrintStream.class), "println", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class)}));
    }

    public static void printRegValue(Sh2Prefetch.BytecodeContext ctx, int reg) {
        ctx.mv.visitFieldInsn(178, Type.getInternalName(System.class), "out", Type.getDescriptor(PrintStream.class));
        Ow2Sh2Bytecode.pushRegStack(ctx, reg);
        ctx.mv.visitInsn(46);
        ctx.mv.visitMethodInsn(182, Type.getInternalName(PrintStream.class), "println", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Integer.TYPE)}));
    }

    public static void printSh2ContextField(Sh2Prefetch.BytecodeContext ctx, String name, Class<?> clazz) {
        ctx.mv.visitFieldInsn(178, Type.getInternalName(System.class), "out", Type.getDescriptor(PrintStream.class));
        Ow2Sh2Helper.pushSh2Context(ctx);
        ctx.mv.visitFieldInsn(180, Type.getInternalName(Sh2Context.class), name, Type.getDescriptor(clazz));
        ctx.mv.visitMethodInsn(182, Type.getInternalName(PrintStream.class), "println", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(clazz)}));
    }

    public static void popSh2ContextIntField(Sh2Prefetch.BytecodeContext ctx, String name) {
        ctx.mv.visitFieldInsn(181, Type.getInternalName(Sh2Context.class), name, Ow2Sh2BlockRecompiler.intDesc);
    }

    public static void popSR(Sh2Prefetch.BytecodeContext ctx) {
        ctx.mv.visitFieldInsn(181, Type.getInternalName(Sh2Context.class), SH2CTX_CLASS_FIELD.SR.name(), Ow2Sh2BlockRecompiler.intDesc);
    }

    public static void pushSR(Sh2Prefetch.BytecodeContext ctx) {
        Ow2Sh2Helper.pushField(ctx, Sh2Context.class, SH2CTX_CLASS_FIELD.SR.name(), Integer.TYPE);
    }

    public static void pushField(Sh2Prefetch.BytecodeContext ctx, Class<?> refClass, String fieldName, Class<?> fieldClass) {
        ctx.mv.visitFieldInsn(180, Type.getInternalName(refClass), fieldName, Type.getDescriptor(fieldClass));
    }

    public static void pushSh2Context(Sh2Prefetch.BytecodeContext ctx) {
        ctx.mv.visitVarInsn(25, 0);
        ctx.mv.visitFieldInsn(180, ctx.classDesc, DRC_CLASS_FIELD.sh2Context.name(), Type.getDescriptor(Sh2Context.class));
    }

    public static void pushMemory(Sh2Prefetch.BytecodeContext ctx) {
        ctx.mv.visitVarInsn(25, 0);
        ctx.mv.visitFieldInsn(180, ctx.classDesc, DRC_CLASS_FIELD.memory.name(), Type.getDescriptor(Ow2Sh2BlockRecompiler.memoryClass));
    }

    public static void pushSh2ContextIntField(Sh2Prefetch.BytecodeContext ctx, String name) {
        Ow2Sh2Helper.pushSh2Context(ctx);
        Ow2Sh2Helper.pushField(ctx, Sh2Context.class, name, Integer.TYPE);
    }

    public static void sh2PushReg15(Sh2Prefetch.BytecodeContext ctx) {
        int valIdx = ctx.mv.newLocal(Type.INT_TYPE);
        ctx.mv.visitVarInsn(54, valIdx);
        Ow2Sh2Bytecode.decReg(ctx, 15, 4);
        Ow2Sh2Helper.pushMemory(ctx);
        Ow2Sh2Bytecode.pushRegStack(ctx, 15);
        ctx.mv.visitInsn(46);
        ctx.mv.visitVarInsn(21, valIdx);
        Ow2Sh2Bytecode.writeMem(ctx, Size.LONG);
    }

    public static void sh2PopReg15(Sh2Prefetch.BytecodeContext ctx) {
        int resIdx = ctx.mv.newLocal(Type.INT_TYPE);
        Ow2Sh2Helper.pushMemory(ctx);
        Ow2Sh2Bytecode.pushRegStack(ctx, 15);
        ctx.mv.visitInsn(46);
        Ow2Sh2Bytecode.readMem(ctx, Size.LONG);
        ctx.mv.visitVarInsn(54, resIdx);
        Ow2Sh2Bytecode.pushRegStack(ctx, 15);
        ctx.mv.visitInsn(92);
        ctx.mv.visitInsn(46);
        ctx.mv.visitInsn(7);
        ctx.mv.visitInsn(96);
        ctx.mv.visitInsn(79);
        ctx.mv.visitVarInsn(21, resIdx);
    }

    private static void printArrayField(Sh2Prefetch.BytecodeContext ctx, String name, String fieldDesc) {
    }

    private static void emitPrintField(Sh2Prefetch.BytecodeContext ctx, String name, Class<?> clazz) {
    }

    public static void emitPushLongConstToStack(Sh2Prefetch.BytecodeContext ctx, long val) {
        if (val == 0L || val == 1L) {
            ctx.mv.visitInsn((int)(9L + val));
        } else {
            ctx.mv.visitLdcInsn((Object)val);
        }
    }

    public static void emitPushConstToStack(Sh2Prefetch.BytecodeContext ctx, int val) {
        if (val >= 0 && val <= 5) {
            ctx.mv.visitInsn(3 + val);
        } else if (val >= -128 && val <= 127) {
            ctx.mv.visitIntInsn(16, val);
        } else if (val >= Short.MIN_VALUE && val <= Short.MAX_VALUE) {
            ctx.mv.visitIntInsn(17, val);
        } else {
            ctx.mv.visitLdcInsn((Object)val);
        }
    }

    public static void emitCastIntToSize(Sh2Prefetch.BytecodeContext ctx, Size size) {
        switch (size) {
            case BYTE: {
                ctx.mv.visitInsn(145);
                break;
            }
            case WORD: {
                ctx.mv.visitInsn(147);
            }
        }
    }

    public static enum SH2CTX_CLASS_FIELD {
        PC,
        PR,
        SR,
        GBR,
        VBR,
        MACH,
        MACL,
        delaySlot,
        cycles,
        devices;

    }

    public static enum DRC_CLASS_FIELD {
        regs,
        opcodes,
        sh2DrcContext,
        sh2Context,
        sh2MMREG,
        memory;

    }

    public static enum SH2MEMORY_METHOD {
        read,
        write;

    }

    public static enum SH2_DEVICE_CTX_CLASS_FIELD {
        sh2MMREG;

    }

    public static enum SH2_DRC_CTX_CLASS_FIELD {
        sh2Ctx,
        memory;

    }
}

