/*
 * Decompiled with CFR 0.152.
 */
package s32x.vdp.debug;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import omegadrive.Device;
import omegadrive.util.ImageUtil;
import omegadrive.util.VideoMode;
import s32x.vdp.MarsVdp;

public interface MarsVdpDebugView
extends Device {
    public static final MarsVdpDebugView NO_OP = new MarsVdpDebugView(){

        @Override
        public void update(MarsVdp.MarsVdpContext context, int[] buffer) {
        }

        @Override
        public void updateFinalImage(int[] fg) {
        }
    };

    public void update(MarsVdp.MarsVdpContext var1, int[] var2);

    public void updateFinalImage(int[] var1);

    default public JPanel getPanel() {
        return null;
    }

    public static MarsVdpDebugView createInstance() {
        return MarsVdpDebugViewImpl.DEBUG_VIEWER_ENABLED ? new MarsVdpDebugViewImpl() : NO_OP;
    }

    public static class MarsVdpDebugViewImpl
    implements MarsVdpDebugView {
        protected static final boolean DEBUG_VIEWER_ENABLED = Boolean.parseBoolean(System.getProperty("md.show.vdp.debug.viewer", "false"));
        public static GraphicsDevice gd;
        static boolean isHeadless;
        static Point lastLocation;
        private static final int PANEL_TEXT_HEIGHT = 20;
        private static final int PANEL_HEIGHT = 276;
        private static final int PANEL_WIDTH = 320;
        private static final Dimension layerDim;
        private static final int imgTypeLen;
        private JPanel panel;
        private final ImageIcon[] imgIcons = new ImageIcon[ImageType.values().length];
        private final BufferedImage[] imageList = new BufferedImage[ImageType.values().length];
        private VideoMode videoMode = VideoMode.NTSCJ_H20_V18;

        public void init() {
            this.imageList[ImageType.BUFF_0.ordinal()] = ImageUtil.createImage((GraphicsDevice)gd, (Dimension)layerDim);
            this.imageList[ImageType.BUFF_1.ordinal()] = ImageUtil.createImage((GraphicsDevice)gd, (Dimension)layerDim);
            this.imageList[ImageType.FULL.ordinal()] = ImageUtil.createImage((GraphicsDevice)gd, (Dimension)layerDim);
            this.imageList[ImageType.MDp32X.ordinal()] = ImageUtil.createImage((GraphicsDevice)gd, (Dimension)layerDim);
            this.panel = new JPanel();
            JComponent p0 = this.createComponent(ImageType.BUFF_0);
            JComponent p1 = this.createComponent(ImageType.BUFF_1);
            JComponent p2 = this.createComponent(ImageType.FULL);
            JComponent p3 = this.createComponent(ImageType.MDp32X);
            this.panel.add(p0);
            this.panel.add(p1);
            this.panel.add(p2);
            this.panel.add(p3);
            Dimension d = new Dimension(1312, 278);
            this.panel.setMaximumSize(d);
            this.panel.setBackground(Color.BLACK);
        }

        protected MarsVdpDebugViewImpl() {
            this.init();
        }

        JComponent createComponent(ImageType type) {
            int num = type.ordinal();
            this.imgIcons[num] = new ImageIcon(this.imageList[num]);
            JPanel pnl = new JPanel();
            BoxLayout bl = new BoxLayout(pnl, 1);
            pnl.setLayout(bl);
            JLabel title = new JLabel((String)(type != ImageType.MDp32X ? "32X " + type : "MD+32X Layer"));
            title.setForeground(Color.WHITE);
            JLabel lbl = new JLabel(this.imgIcons[num]);
            pnl.add(title);
            pnl.add(lbl);
            pnl.setBackground(Color.BLACK);
            pnl.setBorder(BorderFactory.createLineBorder(Color.WHITE));
            return pnl;
        }

        private void updateVideoMode(VideoMode videoMode) {
            IntStream.range(0, imgTypeLen).forEach(i -> {
                this.imageList[i] = ImageUtil.createImage((GraphicsDevice)gd, (Dimension)videoMode.getDimension());
                this.imgIcons[i].setImage(this.imageList[i]);
            });
            this.videoMode = videoMode;
        }

        @Override
        public void update(MarsVdp.MarsVdpContext context, int[] rgb888) {
            if (context.videoMode != this.videoMode) {
                this.updateVideoMode(context.videoMode);
            }
            this.copyToImages(context.frameBufferDisplay, rgb888);
            this.panel.repaint();
        }

        @Override
        public void updateFinalImage(int[] fg) {
            int[] imgDataFull = ImageUtil.getPixels((BufferedImage)this.imageList[ImageType.MDp32X.ordinal()]);
            System.arraycopy(fg, 0, imgDataFull, 0, fg.length);
        }

        private void copyToImages(int num, int[] rgb888) {
            int[] imgData = ImageUtil.getPixels((BufferedImage)this.imageList[num]);
            int[] imgDataFull = ImageUtil.getPixels((BufferedImage)this.imageList[ImageType.FULL.ordinal()]);
            System.arraycopy(rgb888, 0, imgData, 0, rgb888.length);
            System.arraycopy(rgb888, 0, imgDataFull, 0, rgb888.length);
        }

        @Override
        public JPanel getPanel() {
            return this.panel;
        }

        static {
            if (DEBUG_VIEWER_ENABLED) {
                // empty if block
            }
            if (!(isHeadless = GraphicsEnvironment.getLocalGraphicsEnvironment().isHeadlessInstance())) {
                gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            }
            layerDim = new Dimension(320, 276);
            imgTypeLen = ImageType.values().length;
        }
    }

    public static enum ImageType {
        BUFF_0,
        BUFF_1,
        FULL,
        MDp32X;

    }
}

