/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib;

import java.util.ArrayList;
import java.util.List;
import org.digitalmediaserver.cuelib.CueSheet;
import org.digitalmediaserver.cuelib.Index;
import org.digitalmediaserver.cuelib.TrackData;
import org.digitalmediaserver.cuelib.util.Utils;

public class FileData {
    private final List<TrackData> trackData = new ArrayList<TrackData>();
    private String file = null;
    private String fileType = null;
    private CueSheet parent;

    public FileData(CueSheet parent) {
        this.parent = parent;
    }

    public FileData(CueSheet parent, String file, String fileType) {
        this.parent = parent;
        this.file = file;
        this.fileType = fileType;
    }

    public List<Index> getAllIndices() {
        ArrayList<Index> allIndices = new ArrayList<Index>();
        for (TrackData trackDataElement : this.trackData) {
            allIndices.addAll(trackDataElement.getIndices());
        }
        return allIndices;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public List<TrackData> getTrackData() {
        return this.trackData;
    }

    public CueSheet getParent() {
        return this.parent;
    }

    public void setParent(CueSheet parent) {
        this.parent = parent;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        if (!Utils.isBlank(this.fileType)) {
            sb.append(this.fileType).append(" ");
        }
        sb.append("file=");
        if (Utils.isBlank(this.file)) {
            sb.append("None");
        } else {
            sb.append('\"').append(this.file).append('\"');
        }
        if (!this.trackData.isEmpty()) {
            sb.append(" trackData=").append(Utils.collectionToString(this.trackData, 12));
        }
        sb.append("]");
        return sb.toString();
    }
}

