package omegadrive.vdp.util;

import omegadrive.bus.md.GenesisBus;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import org.slf4j.Logger;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import static omegadrive.util.Util.th;

/**
 * Federico Berti
 * <p>
 * Copyright 2022
 */
public class RegAccessLogger {
    private static final Logger LOG = LogHelper.getLogger(RegAccessLogger.class.getSimpleName());

    private static final boolean ENABLE = false;

    private static final Map<String, Integer> log = new HashMap<>();
    private static final Set<Integer> addrRead = new HashSet<>();
    private static final Set<Integer> addrWrite = new HashSet<>();

    public static void regAccess(String regSpec, int address, int val, Size size, boolean read){
        if(!ENABLE){
            return;
        }
        if(((address & 0xFF_0000) == 0xFF_0000) || (address < GenesisBus.DEFAULT_ROM_END_ADDRESS)){
            return;
        }
        String s = (read ? "R," : "W,") + regSpec + "," + th(address) + "," + size;
        Integer v = log.get(s);
        if(v == null || v != val){
//            LOG.info(s + "," + th(val));
            log.put(s, val);
        }
        Set<Integer> set = read ? addrRead : addrWrite;
        if(set.add(address)){
            LOG.info("U" + s + "," + th(val));
        }
    }
}
