package m68k.cpu.instructions;

import m68k.cpu.Cpu;
import m68k.cpu.Instruction;
import m68k.cpu.operand.Operand;
import m68k.cpu.operand.Operands;

/**
 * Federico Berti
 * <p>
 * Copyright 2023
 */
public class Helper {

    public static int[] INVALID_M68K_AREAS = new int[0x100];
    static {
        INVALID_M68K_AREAS[0xA0] = 1;
        INVALID_M68K_AREAS[0xA1] = 1;
        INVALID_M68K_AREAS[0xC0] = 1;
    }

    public static void disasm(Instruction i, Cpu cpu, int opcode){
        StringBuilder sb = new StringBuilder();
        i.disassemble(cpu.getPC(), opcode).shortFormat(sb);
        System.err.println(sb);
    }

    public static void checkInvalidAccess(Cpu cpu, int addr, int opcode){
        int area = (addr >> 16) & 0xFF;
        if(area != 0xFF || INVALID_M68K_AREAS[area] > 0){
            disasm(cpu.getInstructionFor(opcode), cpu, opcode);
        }
    }

    public static void checkInvalidAccess(Cpu cpu, Operand dst, int opcode){
        if(dst instanceof Operands.AddressRegisterPreDecOperand orio){
            checkInvalidAccess(cpu, orio.getComputedAddress(), opcode);
        }
    }
}
