/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;

public enum JInputHelper {

    private static final String[] NATIVE_LIBRARIES = new String[]{"jinput-dx8.dll", "jinput-dx8_64.dll", "jinput-raw.dll", "jinput-raw_64.dll", "jinput-wintab.dll", "jinput-wintab.dll", "libjinput-linux.so", "libjinput-linux64.so", "libjinput-osx.jnilib"};

    public static void setupJInput() {
        try {
            File nativesDirectory = JInputHelper.createTempDirectory();
            JInputHelper.unpackNativeLibraries(nativesDirectory);
            JInputHelper.setLibraryPath(nativesDirectory);
            JInputHelper.fixInputPluginForWindows8();
        }
        catch (Exception exception) {
            System.err.println("Unable to setup native libraries.");
            exception.printStackTrace();
        }
    }

    private static void unpackNativeLibraries(File nativesDirectory) throws IOException {
        for (String nativeLibrary : NATIVE_LIBRARIES) {
            JInputHelper.unpackNativeLibrary(nativesDirectory, nativeLibrary);
        }
    }

    private static void unpackNativeLibrary(File nativesDirectory, String nativeLibrary) throws IOException {
        block25: {
            try (InputStream nativeLibraryInputStream = ClassLoader.getSystemResourceAsStream(nativeLibrary);){
                File nativeLibraryTempFile = new File(nativesDirectory, nativeLibrary);
                nativeLibraryTempFile.deleteOnExit();
                if (nativeLibraryTempFile.exists()) break block25;
                try (BufferedOutputStream nativeLibraryTempFileOutputStream = new BufferedOutputStream(new FileOutputStream(nativeLibraryTempFile));){
                    int length;
                    byte[] buffer = new byte[4096];
                    while ((length = nativeLibraryInputStream.read(buffer)) > 0) {
                        nativeLibraryTempFileOutputStream.write(buffer, 0, length);
                    }
                }
            }
        }
    }

    private static File createTempDirectory() throws IOException {
        String tmpdir = System.getProperty("java.io.tmpdir") + "/halfnes-" + "1.0.6";
        System.err.println(tmpdir);
        File f = new File(tmpdir);
        if (!f.exists()) {
            f.mkdir();
        }
        f.deleteOnExit();
        return f;
    }

    private static void setLibraryPath(File nativesDirectory) throws NoSuchFieldException, IllegalAccessException {
        System.setProperty("java.library.path", nativesDirectory.getAbsolutePath());
        Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
        fieldSysPath.setAccessible(true);
        fieldSysPath.set(null, null);
    }

    private static void fixInputPluginForWindows8() {
        AccessController.doPrivileged(() -> {
            String os = System.getProperty("os.name", "").trim();
            if (os.startsWith("Windows")) {
                if (os.startsWith("Windows 8")) {
                    System.setProperty("jinput.useDefaultPlugin", "false");
                    System.setProperty("net.java.games.input.plugins", "net.java.games.input.DirectAndRawInputEnvironmentPlugin");
                }
                if (os.startsWith("Windows 10") || JInputHelper.isWindows10()) {
                    System.setProperty("jinput.useDefaultPlugin", "false");
                    System.setProperty("net.java.games.input.plugins", "net.java.games.input.DirectAndRawInputEnvironmentPlugin");
                }
            }
            return null;
        });
    }

    private static boolean isWindows10() {
        try {
            Process process = Runtime.getRuntime().exec("cmd.exe /c ver");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
            bufferedReader.readLine();
            String line = bufferedReader.readLine();
            process.waitFor();
            return line.contains("10");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

