/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes;

import com.grapeshot.halfnes.PrefsSingleton;
import com.grapeshot.halfnes.mappers.Mapper;
import com.grapeshot.halfnes.ui.DebugUI;
import com.grapeshot.halfnes.ui.GUIInterface;
import com.grapeshot.halfnes.utils;
import java.awt.image.BufferedImage;
import java.util.Arrays;

public class PPU {
    private static final boolean PPUDEBUG = PrefsSingleton.get().getBoolean("ntView", false);
    public Mapper mapper;
    public int oamaddr;
    public int oamstart;
    public int readbuffer = 0;
    public int loopyV = 0;
    public int loopyT = 0;
    public int loopyX = 0;
    public int scanline = 0;
    public int cycles = 0;
    private int framecount = 0;
    private int div = 2;
    private final int[] OAM = new int[256];
    public boolean even = true;
    private boolean bgpattern = true;
    private boolean sprpattern;
    private boolean spritesize;
    private boolean grayscale;
    private boolean bgClip;
    private boolean spriteClip;
    private boolean bgOn;
    private boolean spritesOn;
    private boolean sprite0hit;
    private boolean spriteoverflow;
    public boolean vblankflag;
    public boolean nmicontrol;
    private int emph;
    public final int[] pal;
    private int vraminc = 1;
    public int openbus = 0;
    private int[] ppuReg = new int[8];
    private int[] bitmap = new int[61440];
    private int[] secOAM = new int[32];
    private int[] spriteshiftregH = new int[8];
    private int[] spriteshiftregL = new int[8];
    private int[] spriteXlatch = new int[8];
    private int[] spritepals = new int[8];
    private int found;
    private int bgShiftRegH;
    private int bgShiftRegL;
    private int bgAttrShiftRegH;
    private int bgAttrShiftRegL;
    private final boolean[] spritebgflags = new boolean[8];
    private final int[] bgcolors = new int[256];
    private int nextattr;
    private int linelowbits;
    private int linehighbits;
    private int penultimateattr;
    private int numscanlines;
    private int vblankline;
    private final int[] cpudivider = new int[]{3, 3, 3, 3, 3};
    private DebugUI debuggui;
    private BufferedImage nametableView;
    private int tileAddr = 0;
    private int cpudividerctr = 0;
    boolean dotcrawl = true;
    private boolean sprite0here = false;

    public PPU(Mapper mapper) {
        this.pal = new int[]{9, 1, 0, 1, 0, 2, 2, 13, 8, 16, 8, 36, 0, 0, 4, 44, 9, 1, 52, 3, 0, 4, 0, 20, 8, 58, 0, 2, 0, 32, 44, 8};
        this.mapper = mapper;
        Arrays.fill(this.OAM, 255);
        if (PPUDEBUG) {
            this.nametableView = new BufferedImage(512, 480, 4);
            this.debuggui = new DebugUI(512, 480);
            this.debuggui.run();
        }
        this.setParameters();
    }

    public void init() {
        this.framecount = 0;
        this.div = 2;
        this.scanline = 0;
        this.cycles = 0;
        this.write(0, this.ppuReg[0]);
        this.write(1, this.ppuReg[1]);
        this.write(2, this.ppuReg[2]);
    }

    public final void setParameters() {
        switch (this.mapper.getTVType()) {
            default: {
                this.numscanlines = 262;
                this.vblankline = 241;
                this.cpudivider[0] = 3;
                break;
            }
            case PAL: {
                this.numscanlines = 312;
                this.vblankline = 241;
                this.cpudivider[0] = 4;
                break;
            }
            case DENDY: {
                this.numscanlines = 312;
                this.vblankline = 291;
                this.cpudivider[0] = 3;
            }
        }
    }

    public void runFrame() {
        for (int line = 0; line < this.numscanlines; ++line) {
            this.clockLine(line);
        }
    }

    public final int read(int regnum) {
        switch (regnum) {
            case 2: {
                this.even = true;
                if (this.scanline == 241 && this.cycles == 1) {
                    this.vblankflag = false;
                }
                this.openbus = (this.vblankflag ? 128 : 0) | (this.sprite0hit ? 64 : 0) | (this.spriteoverflow ? 32 : 0) | this.openbus & 0x1F;
                this.vblankflag = false;
                break;
            }
            case 4: {
                this.openbus = this.OAM[this.oamaddr];
                if (!this.renderingOn() || this.scanline > 240) break;
                if (this.cycles < 64) {
                    return 255;
                }
                if (this.cycles <= 256) {
                    return 0;
                }
                if (this.cycles < 320) {
                    return 255;
                }
                return this.secOAM[0];
            }
            case 7: {
                int temp;
                if ((this.loopyV & 0x3FFF) < 16128) {
                    temp = this.readbuffer;
                    this.readbuffer = this.mapper.ppuRead(this.loopyV & 0x3FFF);
                } else {
                    this.readbuffer = this.mapper.ppuRead((this.loopyV & 0x3FFF) - 4096);
                    temp = this.mapper.ppuRead(this.loopyV);
                }
                if (!this.renderingOn() || this.scanline > 240 && this.scanline < this.numscanlines - 1) {
                    this.loopyV += this.vraminc;
                } else {
                    this.incLoopyVHoriz();
                    this.incLoopyVVert();
                }
                this.openbus = temp;
                break;
            }
            default: {
                return this.openbus;
            }
        }
        return this.openbus;
    }

    public final void write(int regnum, int data) {
        if (regnum >= 0 && regnum < 8) {
            this.ppuReg[regnum] = data;
        }
        this.openbus = data;
        block0 : switch (regnum) {
            case 0: {
                this.loopyT &= 0xFFFFF3FF;
                this.loopyT |= (data & 3) << 10;
                this.vraminc = (data & 4) != 0 ? 32 : 1;
                this.sprpattern = (data & 8) != 0;
                this.bgpattern = (data & 0x10) != 0;
                this.spritesize = (data & 0x20) != 0;
                this.nmicontrol = (data & 0x80) != 0;
                break;
            }
            case 1: {
                this.grayscale = (data & 1) != 0;
                this.bgClip = (data & 2) == 0;
                this.spriteClip = (data & 4) == 0;
                this.bgOn = (data & 8) != 0;
                this.spritesOn = (data & 0x10) != 0;
                this.emph = (data & 0xE0) << 1;
                if (this.numscanlines != 312) break;
                int red = this.emph >> 6 & 1;
                int green = this.emph >> 7 & 1;
                this.emph &= 0xF3F;
                this.emph |= red << 7 | green << 6;
                break;
            }
            case 3: {
                this.oamaddr = data & 0xFF;
                break;
            }
            case 4: {
                this.OAM[this.oamaddr++] = (this.oamaddr & 3) == 2 ? data & 0xE3 : data;
                this.oamaddr &= 0xFF;
                break;
            }
            case 5: {
                if (this.even) {
                    this.loopyT &= 0xFFFFFFE0;
                    this.loopyX = data & 7;
                    this.loopyT |= data >> 3;
                    this.even = false;
                    break;
                }
                this.loopyT &= 0xFFFF8FFF;
                this.loopyT |= (data & 7) << 12;
                this.loopyT &= 0xFFFFFC1F;
                this.loopyT |= (data & 0xF8) << 2;
                this.even = true;
                break;
            }
            case 6: {
                if (this.even) {
                    this.loopyT &= 0xC0FF;
                    this.loopyT |= (data & 0x3F) << 8;
                    this.loopyT &= 0x3FFF;
                    this.even = false;
                    break;
                }
                this.loopyT &= 0xFFF00;
                this.loopyT |= data;
                this.loopyV = this.loopyT;
                this.even = true;
                break;
            }
            case 7: {
                this.mapper.ppuWrite(this.loopyV & 0x3FFF, data);
                if (!this.renderingOn() || this.scanline > 240 && this.scanline < this.numscanlines - 1) {
                    this.loopyV += this.vraminc;
                    break;
                }
                if ((this.loopyV & 0x7000) == 28672) {
                    int YScroll = this.loopyV & 0x3E0;
                    this.loopyV &= 0xFFF;
                    switch (YScroll) {
                        case 928: {
                            this.loopyV ^= 0xBA0;
                            break block0;
                        }
                        case 992: {
                            this.loopyV ^= 0x3E0;
                            break block0;
                        }
                    }
                    this.loopyV += 32;
                    break;
                }
                this.loopyV += 4096;
                break;
            }
        }
    }

    public int[] getPpuReg() {
        return this.ppuReg;
    }

    public int[] getOAM() {
        return this.OAM;
    }

    public int[] getPalette() {
        return this.pal;
    }

    public boolean renderingOn() {
        return this.bgOn || this.spritesOn;
    }

    public final boolean mmc3CounterClocking() {
        return this.bgpattern != this.sprpattern && this.renderingOn();
    }

    public final void clockLine(int scanline) {
        int skip;
        this.cycles = skip = this.numscanlines == 262 && scanline == 0 && this.renderingOn() && (this.framecount & 2) == 0 ? 1 : 0;
        while (this.cycles < 341) {
            this.clock();
            ++this.cycles;
        }
    }

    public final void clock() {
        boolean renderingOn = this.renderingOn();
        if (this.cycles == 1) {
            if (this.scanline == 0) {
                this.dotcrawl = renderingOn;
            }
            if (this.scanline < 240) {
                this.bgcolors[this.scanline] = this.pal[0];
            }
        }
        if (this.scanline < 240 || this.scanline == this.numscanlines - 1) {
            if (renderingOn) {
                if (this.cycles >= 1 && this.cycles <= 256 || this.cycles >= 321 && this.cycles <= 336) {
                    this.bgFetch();
                }
                if (this.cycles == 257) {
                    this.loopyV &= 0xFFFFFBE0;
                    this.loopyV |= this.loopyT & 0x41F;
                } else if (this.cycles == 340) {
                    this.fetchNTByte();
                    this.fetchNTByte();
                } else if (this.cycles == 65) {
                    this.oamstart = this.oamaddr;
                } else if (this.cycles == 260) {
                    this.evalSprites();
                }
            } else if (this.cycles > 257 && this.cycles <= 341) {
                this.oamaddr = 0;
            }
            if (this.scanline == this.numscanlines - 1) {
                if (this.cycles == 0) {
                    this.vblankflag = false;
                    this.sprite0hit = false;
                    this.spriteoverflow = false;
                } else if (this.cycles >= 280 && this.cycles <= 304 && this.renderingOn()) {
                    this.loopyV = this.loopyT;
                }
            }
        } else if (this.scanline == this.vblankline && this.cycles == 1) {
            this.vblankflag = true;
        }
        if (!renderingOn || this.scanline > 240 && this.scanline < this.numscanlines - 1) {
            this.mapper.checkA12(this.loopyV & 0x3FFF);
        }
        if (this.scanline < 240 && this.cycles >= 1 && this.cycles <= 256) {
            int bufferoffset = (this.scanline << 8) + (this.cycles - 1);
            if (this.bgOn) {
                boolean isBG = this.drawBGPixel(bufferoffset);
                this.drawSprites(this.scanline, this.cycles - 1, isBG);
            } else if (this.spritesOn) {
                int bgcolor;
                this.bitmap[bufferoffset] = bgcolor = this.loopyV > 16128 && this.loopyV < 16383 ? this.mapper.ppuRead(this.loopyV) : this.pal[0];
                this.drawSprites(this.scanline, this.cycles - 1, true);
            } else {
                int bgcolor;
                this.bitmap[bufferoffset] = bgcolor = this.loopyV > 16128 && this.loopyV < 16383 ? this.mapper.ppuRead(this.loopyV) : this.pal[0];
            }
            if (this.grayscale) {
                int n = bufferoffset;
                this.bitmap[n] = this.bitmap[n] & 0x30;
            }
            this.bitmap[bufferoffset] = this.bitmap[bufferoffset] & 0x3F | this.emph;
        }
        if (this.vblankflag && this.nmicontrol) {
            this.mapper.cpu.setNMI(true);
        } else {
            this.mapper.cpu.setNMI(false);
        }
        this.div = (this.div + 1) % this.cpudivider[this.cpudividerctr];
        if (this.div == 0) {
            this.mapper.cpu.runcycle(this.scanline, this.cycles);
            this.mapper.cpucycle(1);
            this.cpudividerctr = (this.cpudividerctr + 1) % this.cpudivider.length;
        }
        if (this.cycles == 257) {
            this.mapper.notifyscanline(this.scanline);
        } else if (this.cycles == 340) {
            this.scanline = (this.scanline + 1) % this.numscanlines;
            if (this.scanline == 0) {
                ++this.framecount;
            }
        }
    }

    private void bgFetch() {
        this.bgAttrShiftRegH |= this.nextattr >> 1 & 1;
        this.bgAttrShiftRegL |= this.nextattr & 1;
        switch (this.cycles - 1 & 7) {
            case 1: {
                this.fetchNTByte();
                break;
            }
            case 3: {
                this.penultimateattr = this.getAttribute((this.loopyV & 0xC00) + 9152, this.loopyV & 0x1F, (this.loopyV & 0x3E0) >> 5);
                break;
            }
            case 5: {
                this.linelowbits = this.mapper.ppuRead(this.tileAddr + ((this.loopyV & 0x7000) >> 12));
                break;
            }
            case 7: {
                this.linehighbits = this.mapper.ppuRead(this.tileAddr + 8 + ((this.loopyV & 0x7000) >> 12));
                this.bgShiftRegL |= this.linelowbits;
                this.bgShiftRegH |= this.linehighbits;
                this.nextattr = this.penultimateattr;
                if (this.cycles != 256) {
                    this.incLoopyVHoriz();
                    break;
                }
                this.incLoopyVVert();
                break;
            }
        }
        if (this.cycles >= 321 && this.cycles <= 336) {
            this.bgShiftClock();
        }
    }

    private void incLoopyVVert() {
        if ((this.loopyV & 0x7000) == 28672) {
            this.loopyV &= 0xFFFF8FFF;
            int y = (this.loopyV & 0x3E0) >> 5;
            if (y == 29) {
                y = 0;
                this.loopyV ^= 0x800;
            } else {
                y = y + 1 & 0x1F;
            }
            this.loopyV = this.loopyV & 0xFFFFFC1F | y << 5;
        } else {
            this.loopyV += 4096;
        }
    }

    private void incLoopyVHoriz() {
        if ((this.loopyV & 0x1F) == 31) {
            this.loopyV &= 0xFFFFFFE0;
            this.loopyV ^= 0x400;
        } else {
            ++this.loopyV;
        }
    }

    private void fetchNTByte() {
        this.tileAddr = this.mapper.ppuRead((this.loopyV & 0xC00 | 0x2000) + (this.loopyV & 0x3FF)) * 16 + (this.bgpattern ? 4096 : 0);
    }

    private boolean drawBGPixel(int bufferoffset) {
        boolean isBG;
        if (this.bgClip && (bufferoffset & 0xFF) < 8) {
            this.bitmap[bufferoffset] = this.pal[0];
            isBG = true;
        } else {
            int bgPix = ((this.bgShiftRegH >> -this.loopyX + 16 & 1) << 1) + (this.bgShiftRegL >> -this.loopyX + 16 & 1);
            int bgPal = ((this.bgAttrShiftRegH >> -this.loopyX + 8 & 1) << 1) + (this.bgAttrShiftRegL >> -this.loopyX + 8 & 1);
            isBG = bgPix == 0;
            this.bitmap[bufferoffset] = isBG ? this.pal[0] : this.pal[(bgPal << 2) + bgPix];
        }
        this.bgShiftClock();
        return isBG;
    }

    private void bgShiftClock() {
        this.bgShiftRegH <<= 1;
        this.bgShiftRegL <<= 1;
        this.bgAttrShiftRegH <<= 1;
        this.bgAttrShiftRegL <<= 1;
    }

    private void evalSprites() {
        this.sprite0here = false;
        this.found = 0;
        Arrays.fill(this.secOAM, 255);
        for (int spritestart = this.oamstart; spritestart < 255; spritestart += 4) {
            int ypos = this.OAM[spritestart];
            int offset = this.scanline - ypos;
            if (ypos > this.scanline || offset > (this.spritesize ? 15 : 7)) continue;
            if (spritestart == 0) {
                this.sprite0here = true;
            }
            if (this.found >= 8) {
                this.spriteoverflow = true;
                break;
            }
            this.secOAM[this.found * 4] = this.OAM[spritestart];
            int oamextra = this.OAM[spritestart + 2];
            this.spritebgflags[this.found] = (oamextra & 0x20) != 0;
            this.spriteXlatch[this.found] = this.OAM[spritestart + 3];
            this.spritepals[this.found] = ((oamextra & 3) + 4) * 4;
            if ((oamextra & 0x80) != 0) {
                offset = (this.spritesize ? 15 : 7) - offset;
            }
            if (offset > 7) {
                offset += 8;
            }
            int tilenum = this.OAM[spritestart + 1];
            this.spriteFetch(this.spritesize, tilenum, offset, oamextra);
            ++this.found;
        }
        for (int i = this.found; i < 8; ++i) {
            this.spriteshiftregL[this.found] = 0;
            this.spriteshiftregH[this.found] = 0;
            this.spriteFetch(this.spritesize, 255, 0, 0);
        }
    }

    private void spriteFetch(boolean spritesize, int tilenum, int offset, int oamextra) {
        boolean hflip;
        int tilefetched = spritesize ? (tilenum & 1) * 4096 + (tilenum & 0xFE) * 16 : tilenum * 16 + (this.sprpattern ? 4096 : 0);
        tilefetched += offset;
        boolean bl = hflip = (oamextra & 0x40) != 0;
        if (!hflip) {
            this.spriteshiftregL[this.found] = utils.reverseByte(this.mapper.ppuRead(tilefetched));
            this.spriteshiftregH[this.found] = utils.reverseByte(this.mapper.ppuRead(tilefetched + 8));
        } else {
            this.spriteshiftregL[this.found] = this.mapper.ppuRead(tilefetched);
            this.spriteshiftregH[this.found] = this.mapper.ppuRead(tilefetched + 8);
        }
    }

    private void drawSprites(int line, int x, boolean bgflag) {
        int startdraw = !this.spriteClip ? 0 : 8;
        int sprpxl = 0;
        int index = 7;
        for (int y = this.found - 1; y >= 0; --y) {
            int off = x - this.spriteXlatch[y];
            if (off < 0 || off > 8) continue;
            if ((this.spriteshiftregH[y] & 1) + (this.spriteshiftregL[y] & 1) != 0) {
                index = y;
                sprpxl = 2 * (this.spriteshiftregH[y] & 1) + (this.spriteshiftregL[y] & 1);
            }
            int n = y;
            this.spriteshiftregH[n] = this.spriteshiftregH[n] >> 1;
            int n2 = y;
            this.spriteshiftregL[n2] = this.spriteshiftregL[n2] >> 1;
        }
        if (sprpxl == 0 || x < startdraw || !this.spritesOn) {
            return;
        }
        if (this.sprite0here && index == 0 && !bgflag && x < 255) {
            this.sprite0hit = true;
        }
        if (!this.spritebgflags[index] || bgflag) {
            this.bitmap[(line << 8) + x] = this.pal[this.spritepals[index] + sprpxl];
        }
    }

    private int getAttribute(int ntstart, int tileX, int tileY) {
        int base = this.mapper.ppuRead(ntstart + (tileX >> 2) + 8 * (tileY >> 2));
        if ((tileY & 2) != 0) {
            if ((tileX & 2) != 0) {
                return base >> 6 & 3;
            }
            return base >> 4 & 3;
        }
        if ((tileX & 2) != 0) {
            return base >> 2 & 3;
        }
        return base & 3;
    }

    private void debugDraw() {
        int j;
        int i;
        for (i = 0; i < 32; ++i) {
            for (j = 0; j < 30; ++j) {
                this.nametableView.setRGB(i * 8, j * 8, 8, 8, this.debugGetTile(this.mapper.ppuRead(8192 + i + 32 * j) * 16 + (this.bgpattern ? 4096 : 0)), 0, 8);
            }
        }
        for (i = 0; i < 32; ++i) {
            for (j = 0; j < 30; ++j) {
                this.nametableView.setRGB(i * 8 + 255, j * 8, 8, 8, this.debugGetTile(this.mapper.ppuRead(9216 + i + 32 * j) * 16 + (this.bgpattern ? 4096 : 0)), 0, 8);
            }
        }
        for (i = 0; i < 32; ++i) {
            for (j = 0; j < 30; ++j) {
                this.nametableView.setRGB(i * 8, j * 8 + 239, 8, 8, this.debugGetTile(this.mapper.ppuRead(10240 + i + 32 * j) * 16 + (this.bgpattern ? 4096 : 0)), 0, 8);
            }
        }
        for (i = 0; i < 32; ++i) {
            for (j = 0; j < 30; ++j) {
                this.nametableView.setRGB(i * 8 + 255, j * 8 + 239, 8, 8, this.debugGetTile(this.mapper.ppuRead(11264 + i + 32 * j) * 16 + (this.bgpattern ? 4096 : 0)), 0, 8);
            }
        }
        this.debuggui.setFrame(this.nametableView);
    }

    private int[] debugGetTile(int offset) {
        int[] dat = new int[64];
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                dat[8 * i + j] = ((this.mapper.ppuRead(i + offset) & 128 - j) != 0 ? 0x555555 : 0) + ((this.mapper.ppuRead(i + offset + 8) & 128 - j) != 0 ? 0xAAAAAA : 0);
            }
        }
        return dat;
    }

    public final void renderFrame(GUIInterface gui) {
        if (PPUDEBUG) {
            this.debugDraw();
        }
        if (gui != null) {
            gui.setFrame(this.bitmap, this.bgcolors, this.dotcrawl);
        }
    }
}

