/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.audio;

public class CircularBuffer {
    int[] buffer;
    int bufsize;
    int write_ptr;
    int read_ptr;

    public CircularBuffer(int size) {
        for (int i = 0; i < 26; ++i) {
            int q = (int)Math.pow(2.0, i);
            if (q <= size) continue;
            this.buffer = new int[q];
            this.bufsize = q;
            break;
        }
        if (this.buffer == null) {
            throw new UnsupportedOperationException("Buffer too large");
        }
        this.write_ptr = size - 2;
        this.read_ptr = 0;
    }

    public void write(int data) {
        this.buffer[this.write_ptr] = data;
        ++this.write_ptr;
        this.write_ptr &= this.bufsize - 1;
    }

    public int read() {
        int retval = this.buffer[this.read_ptr];
        ++this.read_ptr;
        this.read_ptr &= this.bufsize - 1;
        return retval;
    }

    public void advanceRead(int amt) {
        this.read_ptr = this.read_ptr + amt & this.bufsize - 1;
    }

    public void advanceWrite(int amt) {
        this.write_ptr = this.write_ptr + amt & this.bufsize - 1;
    }

    public int peek() {
        return this.buffer[this.read_ptr];
    }
}

