/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.audio;

import com.grapeshot.halfnes.audio.Timer;

public class NoiseTimer
extends Timer {
    private int divider = 0;
    private int[] values = NoiseTimer.genvalues(1, 1);
    private int prevduty = 1;
    private static final int periodadd = 0;

    public NoiseTimer() {
        this.period = 0;
    }

    @Override
    public void setduty(int duty) {
        if (duty != this.prevduty) {
            this.values = NoiseTimer.genvalues(duty, this.values[this.position]);
            this.position = 0;
        }
        this.prevduty = duty;
    }

    @Override
    public final void clock() {
        ++this.divider;
        int periods = (this.divider + this.period + 0) / (this.period + 0);
        if (periods < 0) {
            periods = 0;
        }
        this.position = (this.position + periods) % this.values.length;
        this.divider -= (this.period + 0) * periods;
    }

    @Override
    public final int getval() {
        return this.values[this.position] & 1;
    }

    @Override
    public final void reset() {
        this.position = 0;
    }

    @Override
    public final void clock(int cycles) {
        this.divider += cycles;
        int periods = (this.divider + this.period + 0) / (this.period + 0);
        if (periods < 0) {
            periods = 0;
        }
        this.position = (this.position + periods) % this.values.length;
        this.divider -= (this.period + 0) * periods;
    }

    @Override
    public final void setperiod(int newperiod) {
        this.period = newperiod;
    }

    public static int[] genvalues(int whichbit, int seed) {
        int[] tehsuck = new int[whichbit == 1 ? Short.MAX_VALUE : 93];
        for (int i = 0; i < tehsuck.length; ++i) {
            tehsuck[i] = seed = seed >> 1 | ((seed & 1 << whichbit) != 0 ^ (seed & 1) != 0 ? 16384 : 0);
        }
        return tehsuck;
    }

    @Override
    public void setduty(int[] duty) {
        throw new UnsupportedOperationException("Not supported on noise channel.");
    }
}

