/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.cheats;

import com.grapeshot.halfnes.cheats.ActionReplay;
import com.grapeshot.halfnes.cheats.Patch;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class ActionReplayGui
extends JDialog {
    private static final int ADDRESS_LENGTH = 6;
    private static final int DATA_LENGTH = 2;
    private static final int CODE_LENGTH = 8;
    private Patch patch = null;
    private final ActionReplay actionReplay;
    private static final String ggMap = "APZLGITYEOXUKSVN";
    private JButton btnApply;
    private JButton btnClose;
    private JButton btnRemoveAll;
    private JButton btnReset;
    private JButton btnSearch;
    private JButton btnTry;
    private JList currentCodesList;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JTable jTable1;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;
    private JList listPossibleAddresses;
    private JPanel panelApplyCode;
    private JTabbedPane tabbedPan;
    private JTextField textCode;
    private JTextField textFindData;

    public ActionReplayGui(Frame parent, boolean modal, ActionReplay actionReplay) {
        super(parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(null);
        this.textCode.requestFocusInWindow();
        this.textCode.setDocument(new PlainDocument(){

            @Override
            public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
                if (str == null) {
                    return;
                }
                if (this.getLength() + str.length() <= 8 && str.matches("[0-9a-fA-FAEGIKLNOPSTUVXYZaegiklnopstuvxyz]*")) {
                    super.insertString(offset, str, attr);
                }
            }
        });
        this.textFindData.setDocument(new PlainDocument(){

            @Override
            public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
                if (str == null) {
                    return;
                }
                if (this.getLength() + str.length() <= 3 && str.matches("[0-9]*")) {
                    super.insertString(offset, str, attr);
                }
            }
        });
        this.listPossibleAddresses.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (ActionReplayGui.this.listPossibleAddresses.getSelectedIndex() == -1) {
                    ActionReplayGui.this.btnTry.setEnabled(false);
                } else {
                    ActionReplayGui.this.btnTry.setEnabled(true);
                }
            }
        });
        this.actionReplay = actionReplay;
        this.updateCurrentCodesList();
        this.updateListPossibleCodes();
    }

    private void updateCurrentCodesList() {
        Patch[] patches = this.actionReplay.getPatches().values().toArray(new Patch[0]);
        String[] patchesStr = new String[patches.length];
        for (int i = 0; i < patches.length; ++i) {
            patchesStr[i] = patches[i].toString().toUpperCase();
        }
        this.currentCodesList.setListData(patchesStr);
    }

    private void updateListPossibleCodes() {
        ArrayList<String> adrStr = new ArrayList<String>();
        for (Integer adr : this.actionReplay.getFoundAddresses()) {
            String str = Integer.toHexString(adr).toUpperCase();
            while (str.length() < 6) {
                str = "0" + str;
            }
            adrStr.add(str);
        }
        this.listPossibleAddresses.setListData(adrStr.toArray());
    }

    private boolean isCodeValid() {
        long c;
        String code = this.textCode.getText();
        if (code.length() == 8 && code.matches("[0-9a-fA-F]*")) {
            this.btnApply.setEnabled(true);
            int data = Integer.parseInt(this.textCode.getText().substring(this.textCode.getText().length() - 2), 16) & 0xFF;
            int address = Integer.parseInt(this.textCode.getText().substring(0, this.textCode.getText().length() - 2), 16);
            this.patch = new Patch(address, data);
            return true;
        }
        if (code.length() == 6 && code.matches("[AEGIKLNOPSTUVXYZaegiklnopstuvxyz]*")) {
            long c2 = this.GGtoHex(code);
            if ((c2 & 0x8000L) == 0L) {
                int address = 0x8000 | (int)(c2 >> 10 & 1L) << 14 | (int)(c2 >> 9 & 1L) << 13 | (int)(c2 >> 8 & 1L) << 12 | (int)(c2 >> 7 & 1L) << 11 | (int)(c2 >> 2 & 1L) << 10 | (int)(c2 >> 1 & 1L) << 9 | (int)(c2 >> 0 & 1L) << 8 | (int)(c2 >> 19 & 1L) << 7 | (int)(c2 >> 14 & 1L) << 6 | (int)(c2 >> 13 & 1L) << 5 | (int)(c2 >> 12 & 1L) << 4 | (int)(c2 >> 11 & 1L) << 3 | (int)(c2 >> 6 & 1L) << 2 | (int)(c2 >> 5 & 1L) << 1 | (int)(c2 >> 4 & 1L);
                int data = (int)(c2 >> 23 & 1L) << 7 | (int)(c2 >> 18 & 1L) << 6 | (int)(c2 >> 17 & 1L) << 5 | (int)(c2 >> 16 & 1L) << 4 | (int)(c2 >> 3 & 1L) << 3 | (int)(c2 >> 22 & 1L) << 2 | (int)(c2 >> 21 & 1L) << 1 | (int)(c2 >> 20 & 1L);
                this.btnApply.setEnabled(true);
                this.patch = new Patch(address, data);
                return true;
            }
        } else if (code.length() == 8 && code.matches("[AEGIKLNOPSTUVXYZaegiklnopstuvxyz]*") && ((c = this.GGtoHex(code)) & 0x800000L) != 0L) {
            int address = 0x8000 | (int)(c >> 18 & 1L) << 14 | (int)(c >> 17 & 1L) << 13 | (int)(c >> 16 & 1L) << 12 | (int)(c >> 15 & 1L) << 11 | (int)(c >> 10 & 1L) << 10 | (int)(c >> 9 & 1L) << 9 | (int)(c >> 8 & 1L) << 8 | (int)(c >> 27 & 1L) << 7 | (int)(c >> 22 & 1L) << 6 | (int)(c >> 21 & 1L) << 5 | (int)(c >> 20 & 1L) << 4 | (int)(c >> 19 & 1L) << 3 | (int)(c >> 14 & 1L) << 2 | (int)(c >> 13 & 1L) << 1 | (int)(c >> 12 & 1L);
            int data = (int)(c >> 31 & 1L) << 7 | (int)(c >> 26 & 1L) << 6 | (int)(c >> 25 & 1L) << 5 | (int)(c >> 24 & 1L) << 4 | (int)(c >> 3 & 1L) << 3 | (int)(c >> 30 & 1L) << 2 | (int)(c >> 29 & 1L) << 1 | (int)(c >> 28 & 1L);
            int check = (int)(c >> 7 & 1L) << 7 | (int)(c >> 2 & 1L) << 6 | (int)(c >> 1 & 1L) << 5 | (int)(c >> 0 & 1L) << 4 | (int)(c >> 11 & 1L) << 3 | (int)(c >> 6 & 1L) << 2 | (int)(c >> 5 & 1L) << 1 | (int)(c >> 4 & 1L);
            this.btnApply.setEnabled(true);
            this.patch = new Patch(address, data, check);
            return true;
        }
        this.btnApply.setEnabled(false);
        this.patch = null;
        return false;
    }

    private long GGtoHex(String code) {
        code = code.toUpperCase(Locale.ENGLISH);
        long ret = 0L;
        for (int i = 0; i < code.length(); ++i) {
            ret *= 16L;
            ret += (long)ggMap.indexOf(code.charAt(i));
        }
        return ret;
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.jTable1 = new JTable();
        this.tabbedPan = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.panelApplyCode = new JPanel();
        this.textCode = new JTextField();
        this.btnApply = new JButton();
        this.jPanel3 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.currentCodesList = new JList();
        this.btnRemoveAll = new JButton();
        this.jPanel2 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jTextArea2 = new JTextArea();
        this.jPanel4 = new JPanel();
        this.textFindData = new JTextField();
        this.btnSearch = new JButton();
        this.btnReset = new JButton();
        this.jPanel5 = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.listPossibleAddresses = new JList();
        this.btnTry = new JButton();
        this.btnClose = new JButton();
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane2.setViewportView(this.jTable1);
        this.setDefaultCloseOperation(2);
        this.setTitle("Cheat Codes");
        this.setModal(true);
        this.setName("actionReplayDialog");
        this.setResizable(false);
        this.tabbedPan.setMinimumSize(new Dimension(10, 128));
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setBackground(new Color(240, 240, 240));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setFont(new Font("Tahoma", 0, 11));
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText("Enter a Game Genie or Pro Action Replay cheat code.\nA Pro Action Replay code is composed of 8 hexadecimal characters\n(numbers from 0 to 9 and letters from A to F).\nThe first 6 characters represent the in-memory address, and the last two the value to write in.\nIt is used to patch the NES memory to give you extra lives, ammo, time etc...");
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.panelApplyCode.setBorder(BorderFactory.createTitledBorder("Add new code"));
        this.textCode.setColumns(8);
        this.textCode.setFont(new Font("Tahoma", 0, 24));
        this.textCode.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                ActionReplayGui.this.textCodeCaretUpdate(evt);
            }
        });
        this.btnApply.setText("Apply");
        this.btnApply.setEnabled(false);
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionReplayGui.this.btnApplyActionPerformed(evt);
            }
        });
        GroupLayout panelApplyCodeLayout = new GroupLayout(this.panelApplyCode);
        this.panelApplyCode.setLayout(panelApplyCodeLayout);
        panelApplyCodeLayout.setHorizontalGroup(panelApplyCodeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelApplyCodeLayout.createSequentialGroup().addContainerGap().addComponent(this.textCode, -2, 130, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnApply).addContainerGap(-1, Short.MAX_VALUE)));
        panelApplyCodeLayout.setVerticalGroup(panelApplyCodeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelApplyCodeLayout.createSequentialGroup().addContainerGap().addGroup(panelApplyCodeLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.textCode, -2, 28, -2).addComponent(this.btnApply)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Currently applied codes"));
        this.currentCodesList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.currentCodesList.setSelectionMode(0);
        this.jScrollPane4.setViewportView(this.currentCodesList);
        this.btnRemoveAll.setText("Remove all");
        this.btnRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionReplayGui.this.btnRemoveAllActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane4, -2, 75, -2).addGap(18, 18, 18).addComponent(this.btnRemoveAll).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.btnRemoveAll).addGap(0, 96, Short.MAX_VALUE)).addComponent(this.jScrollPane4, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane1, -2, 468, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.panelApplyCode, -2, -1, -2).addGap(20, 20, 20).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE))).addContainerGap(13, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 78, -2).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelApplyCode, -2, -1, -2).addComponent(this.jPanel3, -2, -1, -2)).addContainerGap(16, Short.MAX_VALUE)));
        this.tabbedPan.addTab("Apply", this.jPanel1);
        this.jTextArea2.setEditable(false);
        this.jTextArea2.setBackground(new Color(240, 240, 240));
        this.jTextArea2.setColumns(20);
        this.jTextArea2.setFont(new Font("Tahoma", 0, 11));
        this.jTextArea2.setRows(5);
        this.jTextArea2.setText("You can find new Pro Action Replay codes by searching into memory the location of\nsome data like remaining lives, time left, etc...\nStart a new search with the current value you want to search, then continue the search\nwith new values of the same data until the number of locations found is low, and then\ntry the codes until you found the good one!");
        this.jScrollPane3.setViewportView(this.jTextArea2);
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Search"));
        this.textFindData.setColumns(8);
        this.textFindData.setFont(new Font("Tahoma", 0, 24));
        this.textFindData.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                ActionReplayGui.this.textFindDataCaretUpdate(evt);
            }
        });
        this.btnSearch.setText("Search");
        this.btnSearch.setEnabled(false);
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionReplayGui.this.btnSearchActionPerformed(evt);
            }
        });
        this.btnReset.setText("Reset Search");
        this.btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionReplayGui.this.btnResetActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.textFindData, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSearch).addContainerGap(42, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.btnReset).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.textFindData, -2, 28, -2).addComponent(this.btnSearch)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 7, Short.MAX_VALUE).addComponent(this.btnReset).addContainerGap()));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder("Possible addresses"));
        this.listPossibleAddresses.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.listPossibleAddresses.setSelectionMode(0);
        this.jScrollPane5.setViewportView(this.listPossibleAddresses);
        this.btnTry.setText("Try");
        this.btnTry.setEnabled(false);
        this.btnTry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionReplayGui.this.btnTryActionPerformed(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane5, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 28, Short.MAX_VALUE).addComponent(this.btnTry).addGap(18, 18, 18)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane5, -1, 155, Short.MAX_VALUE).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.btnTry).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -2, 468, -2).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jPanel4, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel5, -2, -1, -2))).addContainerGap(13, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jPanel4, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.tabbedPan.addTab("Find", this.jPanel2);
        this.btnClose.setText("Close");
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionReplayGui.this.btnCloseActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPan, -2, 496, -2).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.btnClose).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPan, -2, 315, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnClose).addContainerGap(-1, Short.MAX_VALUE)));
        this.tabbedPan.getAccessibleContext().setAccessibleName("");
        this.pack();
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void btnApplyActionPerformed(ActionEvent evt) {
        if (this.isCodeValid()) {
            this.actionReplay.addMemoryPatch(this.patch);
            this.setVisible(false);
        }
    }

    private void textCodeCaretUpdate(CaretEvent evt) {
        this.isCodeValid();
    }

    private void btnRemoveAllActionPerformed(ActionEvent evt) {
        this.actionReplay.clear();
        this.updateCurrentCodesList();
    }

    private void btnResetActionPerformed(ActionEvent evt) {
        this.actionReplay.getFoundAddresses().clear();
        this.updateListPossibleCodes();
    }

    private void textFindDataCaretUpdate(CaretEvent evt) {
        if (this.textFindData.getText().matches("[0-9]+")) {
            this.btnSearch.setEnabled(true);
        } else {
            this.btnSearch.setEnabled(false);
        }
    }

    private void btnSearchActionPerformed(ActionEvent evt) {
        if (this.actionReplay.getFoundAddresses().isEmpty()) {
            this.actionReplay.newSearchInMemory((byte)Integer.parseInt(this.textFindData.getText(), 16));
        } else {
            this.actionReplay.continueSearch((byte)Integer.parseInt(this.textFindData.getText(), 16));
        }
        this.updateListPossibleCodes();
    }

    private void btnTryActionPerformed(ActionEvent evt) {
        this.textCode.setText(this.listPossibleAddresses.getSelectedValue().toString());
        this.tabbedPan.setSelectedIndex(0);
    }
}

