/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.cheats;

public class Patch {
    private final int type;
    private final int address;
    private final int data;
    private final int cmpData;

    public Patch(int address, int data) {
        this.address = address;
        this.data = data;
        this.type = 0;
        this.cmpData = 0;
    }

    public Patch(int address, int data, int check) {
        this.address = address;
        this.data = data;
        this.type = 1;
        this.cmpData = check;
    }

    public int getAddress() {
        return this.address;
    }

    public int getData() {
        return this.data;
    }

    public boolean matchesData(int data) {
        return this.type == 0 || data == this.cmpData;
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + this.address;
        hash = 71 * hash + this.data;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Patch other = (Patch)obj;
        if (this.address != other.address) {
            return false;
        }
        return this.data == other.data;
    }

    public String toString() {
        int i;
        String addStr = Integer.toHexString(this.address);
        String datStr = Integer.toHexString(this.data & 0xFF);
        StringBuilder builder = new StringBuilder();
        for (i = 0; i < 6 - addStr.length(); ++i) {
            builder.append("0");
        }
        builder.append(addStr);
        for (i = 0; i < 2 - datStr.length(); ++i) {
            builder.append("0");
        }
        builder.append(datStr);
        return builder.toString().toUpperCase();
    }
}

