/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.audio.ExpansionSoundChip;
import com.grapeshot.halfnes.audio.Sunsoft5BSoundChip;
import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;

public class FME7Mapper
extends Mapper {
    private int commandRegister = 0;
    private int soundCommand = 0;
    private int[] charbanks = new int[8];
    private int[] prgbanks = new int[4];
    private boolean ramEnable = true;
    private boolean ramSelect = false;
    private int irqcounter = 65535;
    private boolean irqenabled;
    private boolean irqclock;
    private boolean hasInitSound = false;
    private final ExpansionSoundChip sndchip = new Sunsoft5BSoundChip();
    private boolean interrupted = false;

    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        this.prg_map = new int[40];
        for (i = 1; i <= 40; ++i) {
            this.prg_map[40 - i] = this.prgsize - 1024 * i;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 0;
        }
    }

    @Override
    public final int cartRead(int addr) {
        if (addr >= 24576) {
            if (addr < 32768 && this.ramSelect) {
                if (this.ramEnable) {
                    return this.prgram[addr - 24576];
                }
                return addr >> 8;
            }
            return this.prg[this.prg_map[addr - 24576 >> 10] + (addr & 0x3FF)];
        }
        return addr >> 8;
    }

    @Override
    public final void cartWrite(int addr, int data) {
        if (addr < 32768 || addr > 65535) {
            super.cartWrite(addr, data);
            return;
        }
        if (addr == 32768) {
            this.commandRegister = data & 0xF;
        } else if (addr == 49152) {
            this.soundCommand = data & 0xF;
            if (!this.hasInitSound) {
                this.cpuram.apu.addExpnSound(this.sndchip);
                this.hasInitSound = true;
            }
        } else if (addr == 40960) {
            switch (this.commandRegister) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.charbanks[this.commandRegister] = data;
                    this.setbanks();
                    break;
                }
                case 8: {
                    this.ramEnable = (data & 0x80) != 0;
                    this.ramSelect = (data & 0x40) != 0;
                    this.prgbanks[0] = data & 0x3F;
                    this.setbanks();
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    this.prgbanks[this.commandRegister - 8] = data;
                    this.setbanks();
                    break;
                }
                case 12: {
                    switch (data & 3) {
                        case 0: {
                            this.setmirroring(Mapper.MirrorType.V_MIRROR);
                            break;
                        }
                        case 1: {
                            this.setmirroring(Mapper.MirrorType.H_MIRROR);
                            break;
                        }
                        case 2: {
                            this.setmirroring(Mapper.MirrorType.SS_MIRROR0);
                            break;
                        }
                        case 3: {
                            this.setmirroring(Mapper.MirrorType.SS_MIRROR1);
                        }
                    }
                }
                case 13: {
                    this.irqclock = (data & 0x80) != 0;
                    boolean bl = this.irqenabled = (data & 1) != 0;
                    if (this.interrupted && this.cpu.interrupt > 0) {
                        --this.cpu.interrupt;
                    }
                    this.interrupted = false;
                    break;
                }
                case 14: {
                    this.irqcounter &= 0xFF00;
                    this.irqcounter |= data;
                    break;
                }
                case 15: {
                    this.irqcounter &= 0xFF;
                    this.irqcounter |= data << 8;
                }
            }
        } else if (addr == 57344) {
            this.sndchip.write(this.soundCommand, data);
        }
    }

    @Override
    public void cpucycle(int cycles) {
        if (this.irqclock) {
            if (this.irqcounter == 0) {
                this.irqcounter = 65535;
                if (this.irqenabled && !this.interrupted) {
                    this.interrupted = true;
                    ++this.cpu.interrupt;
                }
            } else {
                --this.irqcounter;
            }
        }
    }

    private void setbanks() {
        int i;
        for (i = 0; i < 8; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.prg_map[i + 8 * j] = 1024 * (i + this.prgbanks[j] * 8) % this.prgsize;
            }
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * this.charbanks[i] % this.chrsize;
        }
    }
}

