/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.CPU;
import com.grapeshot.halfnes.CPURAM;
import com.grapeshot.halfnes.PPU;
import com.grapeshot.halfnes.PrefsSingleton;
import com.grapeshot.halfnes.ROMLoader;
import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.utils;
import java.util.Arrays;
import java.util.prefs.Preferences;
import java.util.zip.CRC32;

public abstract class Mapper {
    protected ROMLoader loader;
    protected int mappertype;
    protected int submapper;
    protected int prgsize;
    protected int prgoff;
    protected int chroff;
    protected int chrsize;
    public CPU cpu;
    public CPURAM cpuram;
    public PPU ppu;
    protected int[] prg;
    protected int[] chr;
    protected int[] chr_map;
    protected int[] prg_map;
    protected int[] prgram = new int[8192];
    protected MirrorType scrolltype;
    protected boolean haschrram = false;
    protected boolean hasprgram = true;
    protected boolean savesram = false;
    protected final int[] pput0 = new int[1024];
    protected final int[] pput1 = new int[1024];
    protected final int[] pput2 = new int[1024];
    protected final int[] pput3 = new int[1024];
    protected int[] nt0;
    protected int[] nt1;
    protected int[] nt2;
    protected int[] nt3;
    long crc;
    TVType region;
    Preferences prefs = PrefsSingleton.get();

    public boolean supportsSaves() {
        return this.savesram;
    }

    public void destroy() {
        this.cpu = null;
        this.cpuram = null;
        this.ppu = null;
    }

    public static long crc32(int[] array) {
        CRC32 c = new CRC32();
        for (int i : array) {
            c.update(i);
        }
        return c.getValue();
    }

    public void loadrom() throws BadMapperException {
        int i;
        this.loader.parseHeader();
        this.prgsize = this.loader.prgsize;
        this.mappertype = this.loader.mappertype;
        this.prgoff = this.loader.prgoff;
        this.chroff = this.loader.chroff;
        this.chrsize = this.loader.chrsize;
        this.scrolltype = this.loader.scrolltype;
        this.savesram = this.loader.savesram;
        this.prg = this.loader.load(this.prgsize, this.prgoff);
        this.region = this.loader.tvtype;
        this.submapper = this.loader.submapper;
        this.crc = Mapper.crc32(this.prg);
        if (this.crc == 1092891794L || this.crc == 2563560325L) {
            this.hasprgram = false;
        }
        this.chr = this.loader.load(this.chrsize, this.chroff);
        if (this.chrsize == 0) {
            this.haschrram = true;
            this.chrsize = 8192;
            this.chr = new int[8192];
        }
        this.prg_map = new int[32];
        for (i = 0; i < 32; ++i) {
            this.prg_map[i] = 1024 * i & this.prgsize - 1;
        }
        this.chr_map = new int[8];
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
        this.cpuram = new CPURAM(this);
        this.cpu = new CPU(this.cpuram);
        this.ppu = new PPU(this);
        Arrays.fill(this.pput0, 160);
        Arrays.fill(this.pput1, 176);
        Arrays.fill(this.pput2, 192);
        Arrays.fill(this.pput3, 208);
        this.setmirroring(this.scrolltype);
    }

    public void reset() {
    }

    public void cartWrite(int addr, int data) {
        if (addr >= 24576 && addr < 32768) {
            this.prgram[addr & 0x1FFF] = data;
        }
    }

    public int cartRead(int addr) {
        if (addr >= 32768) {
            return this.prg[this.prg_map[(addr & Short.MAX_VALUE) >> 10] + (addr & 0x3FF)];
        }
        if (addr >= 24576 && this.hasprgram) {
            return this.prgram[addr & 0x1FFF];
        }
        return addr >> 8;
    }

    public int ppuRead(int addr) {
        if (addr < 8192) {
            return this.chr[this.chr_map[addr >> 10] + (addr & 0x3FF)];
        }
        switch (addr & 0xC00) {
            case 0: {
                return this.nt0[addr & 0x3FF];
            }
            case 1024: {
                return this.nt1[addr & 0x3FF];
            }
            case 2048: {
                return this.nt2[addr & 0x3FF];
            }
        }
        if (addr >= 16128) {
            if ((addr &= 0x1F) >= 16 && (addr & 3) == 0) {
                addr -= 16;
            }
            return this.ppu.pal[addr];
        }
        return this.nt3[addr & 0x3FF];
    }

    public void ppuWrite(int addr, int data) {
        if ((addr &= 0x3FFF) < 8192) {
            if (this.haschrram) {
                this.chr[this.chr_map[addr >> 10] + (addr & 0x3FF)] = data;
            }
        } else {
            switch (addr & 0xC00) {
                case 0: {
                    this.nt0[addr & 0x3FF] = data;
                    break;
                }
                case 1024: {
                    this.nt1[addr & 0x3FF] = data;
                    break;
                }
                case 2048: {
                    this.nt2[addr & 0x3FF] = data;
                    break;
                }
                case 3072: {
                    if (addr >= 16128 && addr <= 16383) {
                        if ((addr &= 0x1F) >= 16 && (addr & 3) == 0) {
                            addr -= 16;
                        }
                        this.ppu.pal[addr] = data & 0x3F;
                        break;
                    }
                    this.nt3[addr & 0x3FF] = data;
                    break;
                }
                default: {
                    System.err.println("where?");
                }
            }
        }
    }

    public void notifyscanline(int scanline) {
    }

    public void cpucycle(int cycles) {
    }

    public String getrominfo() {
        return "ROM INFO: \nFilename:     " + this.loader.name + "\nMapper:       " + this.mappertype + "\nPRG Size:     " + this.prgsize / 1024 + " K\nCHR Size:     " + (this.haschrram ? 0 : this.chrsize / 1024) + " K\nMirroring:    " + this.scrolltype.toString() + "\nBattery Save: " + (this.savesram ? "Yes" : "No") + "\nCRC:          " + utils.hex(this.crc);
    }

    public boolean hasSRAM() {
        return this.savesram;
    }

    public void setLoader(ROMLoader l) {
        this.loader = l;
    }

    public CPURAM getCPURAM() {
        return this.cpuram;
    }

    public void checkA12(int addr) {
    }

    public void setPRGRAM(int[] newprgram) {
        this.prgram = newprgram;
    }

    public int[] getPRGRam() {
        return this.prgram;
    }

    public final void setmirroring(MirrorType type) {
        switch (type) {
            case H_MIRROR: {
                this.nt0 = this.pput0;
                this.nt1 = this.pput0;
                this.nt2 = this.pput1;
                this.nt3 = this.pput1;
                break;
            }
            case V_MIRROR: {
                this.nt0 = this.pput0;
                this.nt1 = this.pput1;
                this.nt2 = this.pput0;
                this.nt3 = this.pput1;
                break;
            }
            case SS_MIRROR0: {
                this.nt0 = this.pput0;
                this.nt1 = this.pput0;
                this.nt2 = this.pput0;
                this.nt3 = this.pput0;
                break;
            }
            case SS_MIRROR1: {
                this.nt0 = this.pput1;
                this.nt1 = this.pput1;
                this.nt2 = this.pput1;
                this.nt3 = this.pput1;
                break;
            }
            default: {
                this.nt0 = this.pput0;
                this.nt1 = this.pput1;
                this.nt2 = this.pput2;
                this.nt3 = this.pput3;
            }
        }
        this.scrolltype = type;
    }

    public TVType getTVType() {
        int prefsregion = this.prefs.getInt("region", 0);
        switch (prefsregion) {
            default: {
                return this.region;
            }
            case 1: {
                return TVType.NTSC;
            }
            case 2: {
                return TVType.PAL;
            }
            case 3: 
        }
        return TVType.DENDY;
    }

    public void setTVType(int val) {
        this.prefs.putInt("region", val);
    }

    public MirrorType getScrolltype() {
        return this.scrolltype;
    }

    public static MirrorType getScrolltype(int val) {
        return MirrorType.values()[val];
    }

    public boolean hasChrRam() {
        return this.haschrram;
    }

    public boolean hasPrgRam() {
        return this.hasprgram;
    }

    public int[] getChr() {
        return this.chr;
    }

    public int[] getPputN(int n) {
        switch (n) {
            case 0: {
                return this.pput0;
            }
            case 1: {
                return this.pput1;
            }
            case 2: {
                return this.pput2;
            }
            case 3: {
                return this.pput3;
            }
        }
        return null;
    }

    public void init() {
    }

    public static enum TVType {
        NTSC,
        PAL,
        DENDY;

    }

    public static enum MirrorType {
        H_MIRROR,
        V_MIRROR,
        SS_MIRROR0,
        SS_MIRROR1,
        FOUR_SCREEN_MIRROR;

    }
}

