/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;

public class Mapper246
extends Mapper {
    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 0; i < 24; ++i) {
            this.prg_map[i] = 1024 * i & this.prgsize - 1;
        }
        for (i = 1; i <= 8; ++i) {
            this.prg_map[32 - i] = this.prgsize - 1024 * i;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
    }

    @Override
    public final void cartWrite(int addr, int data) {
        if (addr < 24576 || addr > 26623) {
            super.cartWrite(addr, data);
            return;
        }
        switch (addr & 7) {
            case 0: {
                for (int i = 0; i < 8; ++i) {
                    this.prg_map[i] = 1024 * (i + 8 * data) & this.prgsize - 1;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < 8; ++i) {
                    this.prg_map[8 + i] = 1024 * (i + 8 * data) & this.prgsize - 1;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < 8; ++i) {
                    this.prg_map[16 + i] = 1024 * (i + 8 * data) & this.prgsize - 1;
                }
                break;
            }
            case 3: {
                for (int i = 0; i < 8; ++i) {
                    this.prg_map[24 + i] = 1024 * (i + 8 * data) & this.prgsize - 1;
                }
                break;
            }
            case 4: {
                for (int i = 0; i < 2; ++i) {
                    this.chr_map[i] = 1024 * (i + 2 * data) & this.chrsize - 1;
                }
                break;
            }
            case 5: {
                for (int i = 0; i < 2; ++i) {
                    this.chr_map[2 + i] = 1024 * (i + 2 * data) & this.chrsize - 1;
                }
                break;
            }
            case 6: {
                for (int i = 0; i < 2; ++i) {
                    this.chr_map[4 + i] = 1024 * (i + 2 * data) & this.chrsize - 1;
                }
                break;
            }
            case 7: {
                for (int i = 0; i < 2; ++i) {
                    this.chr_map[6 + i] = 1024 * (i + 2 * data) & this.chrsize - 1;
                }
                break;
            }
        }
    }
}

