/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.ROMLoader;
import com.grapeshot.halfnes.mappers.Action52Mapper;
import com.grapeshot.halfnes.mappers.AfterburnerMapper;
import com.grapeshot.halfnes.mappers.AnromMapper;
import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.BnromMapper;
import com.grapeshot.halfnes.mappers.CaltronMapper;
import com.grapeshot.halfnes.mappers.CnromMapper;
import com.grapeshot.halfnes.mappers.CodemastersMapper;
import com.grapeshot.halfnes.mappers.ColorDreamsMapper;
import com.grapeshot.halfnes.mappers.CrazyClimberMapper;
import com.grapeshot.halfnes.mappers.CrimeBustersMapper;
import com.grapeshot.halfnes.mappers.FME7Mapper;
import com.grapeshot.halfnes.mappers.GnromMapper;
import com.grapeshot.halfnes.mappers.IremH3001Mapper;
import com.grapeshot.halfnes.mappers.MIMICMapper;
import com.grapeshot.halfnes.mappers.MMC1Mapper;
import com.grapeshot.halfnes.mappers.MMC2Mapper;
import com.grapeshot.halfnes.mappers.MMC3Mapper;
import com.grapeshot.halfnes.mappers.MMC4Mapper;
import com.grapeshot.halfnes.mappers.MMC5Mapper;
import com.grapeshot.halfnes.mappers.Mapper;
import com.grapeshot.halfnes.mappers.Mapper107;
import com.grapeshot.halfnes.mappers.Mapper112;
import com.grapeshot.halfnes.mappers.Mapper119;
import com.grapeshot.halfnes.mappers.Mapper140;
import com.grapeshot.halfnes.mappers.Mapper15;
import com.grapeshot.halfnes.mappers.Mapper152;
import com.grapeshot.halfnes.mappers.Mapper182;
import com.grapeshot.halfnes.mappers.Mapper185;
import com.grapeshot.halfnes.mappers.Mapper200;
import com.grapeshot.halfnes.mappers.Mapper201;
import com.grapeshot.halfnes.mappers.Mapper203;
import com.grapeshot.halfnes.mappers.Mapper212;
import com.grapeshot.halfnes.mappers.Mapper213;
import com.grapeshot.halfnes.mappers.Mapper214;
import com.grapeshot.halfnes.mappers.Mapper225;
import com.grapeshot.halfnes.mappers.Mapper226;
import com.grapeshot.halfnes.mappers.Mapper229;
import com.grapeshot.halfnes.mappers.Mapper231;
import com.grapeshot.halfnes.mappers.Mapper240;
import com.grapeshot.halfnes.mappers.Mapper241;
import com.grapeshot.halfnes.mappers.Mapper242;
import com.grapeshot.halfnes.mappers.Mapper244;
import com.grapeshot.halfnes.mappers.Mapper246;
import com.grapeshot.halfnes.mappers.Mapper255;
import com.grapeshot.halfnes.mappers.Mapper31;
import com.grapeshot.halfnes.mappers.Mapper33;
import com.grapeshot.halfnes.mappers.Mapper36;
import com.grapeshot.halfnes.mappers.Mapper47;
import com.grapeshot.halfnes.mappers.Mapper48;
import com.grapeshot.halfnes.mappers.Mapper58;
import com.grapeshot.halfnes.mappers.Mapper60;
import com.grapeshot.halfnes.mappers.Mapper61;
import com.grapeshot.halfnes.mappers.Mapper62;
import com.grapeshot.halfnes.mappers.Mapper70;
import com.grapeshot.halfnes.mappers.Mapper72;
import com.grapeshot.halfnes.mappers.Mapper76;
import com.grapeshot.halfnes.mappers.Mapper78;
import com.grapeshot.halfnes.mappers.Mapper86;
import com.grapeshot.halfnes.mappers.Mapper87;
import com.grapeshot.halfnes.mappers.Mapper92;
import com.grapeshot.halfnes.mappers.Mapper94;
import com.grapeshot.halfnes.mappers.Mapper97;
import com.grapeshot.halfnes.mappers.NINA_001_Mapper;
import com.grapeshot.halfnes.mappers.NINA_003_006_Mapper;
import com.grapeshot.halfnes.mappers.NSFMapper;
import com.grapeshot.halfnes.mappers.NamcoMapper;
import com.grapeshot.halfnes.mappers.Namcot34x3Mapper;
import com.grapeshot.halfnes.mappers.NromMapper;
import com.grapeshot.halfnes.mappers.Sunsoft01Mapper;
import com.grapeshot.halfnes.mappers.Sunsoft02Mapper;
import com.grapeshot.halfnes.mappers.Sunsoft03Mapper;
import com.grapeshot.halfnes.mappers.TengenRamboMapper;
import com.grapeshot.halfnes.mappers.UnromMapper;
import com.grapeshot.halfnes.mappers.VRC1Mapper;
import com.grapeshot.halfnes.mappers.VRC2Mapper;
import com.grapeshot.halfnes.mappers.VRC3Mapper;
import com.grapeshot.halfnes.mappers.VRC4Mapper;
import com.grapeshot.halfnes.mappers.VRC6Mapper;
import com.grapeshot.halfnes.mappers.VRC7Mapper;

public class MapperHelper {
    public static Mapper getCorrectMapper(ROMLoader l) throws BadMapperException {
        int type = l.mappertype;
        boolean haschr = l.chrsize == 0;
        switch (type) {
            case -1: {
                return new NSFMapper();
            }
            case 0: {
                return new NromMapper();
            }
            case 1: {
                return new MMC1Mapper();
            }
            case 2: {
                return new UnromMapper();
            }
            case 3: {
                return new CnromMapper();
            }
            case 4: {
                return new MMC3Mapper();
            }
            case 5: {
                return new MMC5Mapper();
            }
            case 7: {
                return new AnromMapper();
            }
            case 9: {
                return new MMC2Mapper();
            }
            case 10: {
                return new MMC4Mapper();
            }
            case 11: {
                return new ColorDreamsMapper();
            }
            case 15: 
            case 169: {
                return new Mapper15();
            }
            case 19: {
                return new NamcoMapper();
            }
            case 21: 
            case 23: 
            case 25: {
                return new VRC4Mapper(type);
            }
            case 22: {
                return new VRC2Mapper();
            }
            case 24: 
            case 26: {
                return new VRC6Mapper(type);
            }
            case 31: {
                return new Mapper31();
            }
            case 33: {
                return new Mapper33();
            }
            case 34: {
                if (haschr) {
                    return new BnromMapper();
                }
                return new NINA_001_Mapper();
            }
            case 36: {
                return new Mapper36();
            }
            case 38: {
                return new CrimeBustersMapper();
            }
            case 41: {
                return new CaltronMapper();
            }
            case 47: {
                return new Mapper47();
            }
            case 48: {
                return new Mapper48();
            }
            case 58: {
                return new Mapper58();
            }
            case 60: {
                return new Mapper60();
            }
            case 61: {
                return new Mapper61();
            }
            case 62: {
                return new Mapper62();
            }
            case 64: {
                return new TengenRamboMapper();
            }
            case 65: {
                return new IremH3001Mapper();
            }
            case 66: {
                return new GnromMapper();
            }
            case 67: {
                return new Sunsoft03Mapper();
            }
            case 68: {
                return new AfterburnerMapper();
            }
            case 69: {
                return new FME7Mapper();
            }
            case 70: {
                return new Mapper70();
            }
            case 71: {
                return new CodemastersMapper();
            }
            case 72: {
                return new Mapper72();
            }
            case 73: {
                return new VRC3Mapper();
            }
            case 75: {
                return new VRC1Mapper();
            }
            case 76: {
                return new Mapper76();
            }
            case 78: {
                return new Mapper78();
            }
            case 79: 
            case 113: {
                return new NINA_003_006_Mapper(type);
            }
            case 85: {
                return new VRC7Mapper();
            }
            case 86: {
                return new Mapper86();
            }
            case 87: {
                return new Mapper87();
            }
            case 88: 
            case 154: {
                return new Namcot34x3Mapper(type);
            }
            case 89: 
            case 93: {
                return new Sunsoft02Mapper(type);
            }
            case 92: {
                return new Mapper92();
            }
            case 94: {
                return new Mapper94();
            }
            case 97: {
                return new Mapper97();
            }
            case 107: {
                return new Mapper107();
            }
            case 112: {
                return new Mapper112();
            }
            case 119: {
                return new Mapper119();
            }
            case 140: {
                return new Mapper140();
            }
            case 152: {
                return new Mapper152();
            }
            case 180: {
                return new CrazyClimberMapper();
            }
            case 182: {
                return new Mapper182();
            }
            case 184: {
                return new Sunsoft01Mapper();
            }
            case 185: {
                return new Mapper185();
            }
            case 200: {
                return new Mapper200();
            }
            case 201: {
                return new Mapper201();
            }
            case 203: {
                return new Mapper203();
            }
            case 206: {
                return new MIMICMapper();
            }
            case 212: {
                return new Mapper212();
            }
            case 213: {
                return new Mapper213();
            }
            case 214: {
                return new Mapper214();
            }
            case 225: {
                return new Mapper225();
            }
            case 226: {
                return new Mapper226();
            }
            case 228: {
                return new Action52Mapper();
            }
            case 229: {
                return new Mapper229();
            }
            case 231: {
                return new Mapper231();
            }
            case 240: {
                return new Mapper240();
            }
            case 241: {
                return new Mapper241();
            }
            case 242: {
                return new Mapper242();
            }
            case 244: {
                return new Mapper244();
            }
            case 246: {
                return new Mapper246();
            }
            case 255: {
                return new Mapper255();
            }
        }
        System.err.println("unsupported mapper # " + type);
        throw new BadMapperException("Unsupported mapper: " + type);
    }

    public static interface MapperState<T> {
        default public void loadState(T state) {
        }

        default public T saveState() {
            return null;
        }
    }
}

