/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;

public class NINA_001_Mapper
extends Mapper {
    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 0; i < 32; ++i) {
            this.prg_map[i] = 1024 * i & this.prgsize - 1;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
    }

    @Override
    public final void cartWrite(int addr, int data) {
        if (addr < 32765 || addr > Short.MAX_VALUE) {
            super.cartWrite(addr, data);
            return;
        }
        switch (addr) {
            case 32765: {
                for (int i = 0; i < 32; ++i) {
                    this.prg_map[i] = 1024 * (i + 32 * data) & this.prgsize - 1;
                }
                break;
            }
            case 32766: {
                for (int i = 0; i < 4; ++i) {
                    this.chr_map[i] = 1024 * (i + 4 * data) & this.chrsize - 1;
                }
                break;
            }
            case 32767: {
                for (int i = 0; i < 4; ++i) {
                    this.chr_map[4 + i] = 1024 * (i + 4 * data) & this.chrsize - 1;
                }
                break;
            }
        }
    }
}

