/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;

public class NINA_003_006_Mapper
extends Mapper {
    boolean m113 = true;

    public NINA_003_006_Mapper(int mappernum) {
        switch (mappernum) {
            case 79: {
                this.m113 = false;
                break;
            }
            case 113: {
                this.m113 = true;
            }
        }
    }

    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 0; i < 32; ++i) {
            this.prg_map[i] = 1024 * i & this.prgsize - 1;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
    }

    @Override
    public final void reset() {
        for (int i = 16640; i < 24576; i += 512) {
            this.cartWrite(i, i + 255);
        }
    }

    @Override
    public final void cartWrite(int addr, int data) {
        if (addr < 16640 || addr > 24575) {
            super.cartWrite(addr, data);
            return;
        }
        if (this.m113) {
            int i;
            this.setmirroring((data & 0x80) != 0 ? Mapper.MirrorType.V_MIRROR : Mapper.MirrorType.H_MIRROR);
            for (i = 0; i < 8; ++i) {
                this.chr_map[i] = 1024 * (i + 8 * (data >> 3 & 8 | data & 7)) & this.chrsize - 1;
            }
            for (i = 0; i < 32; ++i) {
                this.prg_map[i] = 1024 * (i + 32 * (data >> 3 & 7)) & this.prgsize - 1;
            }
        } else {
            int i;
            for (i = 0; i < 8; ++i) {
                this.chr_map[i] = 1024 * (i + 8 * data) & this.chrsize - 1;
            }
            for (i = 0; i < 32; ++i) {
                this.prg_map[i] = 1024 * (i + 32 * (data >> 3)) & this.prgsize - 1;
            }
        }
    }
}

