/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.state;

import com.grapeshot.halfnes.APU;
import com.grapeshot.halfnes.CPU;
import com.grapeshot.halfnes.CPURAM;
import com.grapeshot.halfnes.NES;
import com.grapeshot.halfnes.PPU;
import com.grapeshot.halfnes.mappers.Mapper;
import com.grapeshot.halfnes.mappers.MapperHelper;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.stream.IntStream;

public class HalfnesSaveStateHandler {
    private static int FILE_SIZE = 131072;
    private ByteBuffer buf = ByteBuffer.allocate(FILE_SIZE);

    private static void putInt(ByteBuffer buffer, int[] data) {
        Arrays.stream(data).forEach(d -> buffer.putInt(d));
    }

    private static void getInt(ByteBuffer buffer, int[] data) {
        IntStream.range(0, data.length).forEach(i -> {
            data[i] = buffer.getInt();
        });
    }

    public byte[] getSaveStateData(NES nes) {
        this.buf.clear();
        this.processState(Type.SAVE, nes);
        return this.buf.array();
    }

    public void setSaveStateData(NES nes, byte[] data) {
        this.buf = ByteBuffer.wrap(data);
        this.processState(Type.LOAD, nes);
    }

    public void processState(Type type, CPU cpu, PPU ppu, APU apu, CPURAM ram) {
        if (type == Type.LOAD) {
            this.loadCpu(cpu);
            this.loadPpu(ppu);
            this.loadApu(apu);
            this.loadRam(ram);
        } else {
            this.saveCpu(cpu);
            this.savePpu(ppu);
            this.saveApu(apu);
            this.saveRam(ram);
        }
    }

    private void processState(Type type, NES nes) {
        CPU cpu = nes.getCPU();
        PPU ppu = nes.getPpu();
        APU apu = nes.getApu();
        CPURAM ram = nes.getCPURAM();
        this.processState(type, cpu, ppu, apu, ram);
    }

    private void loadCpu(CPU cpu) {
        cpu.setRegA(this.buf.getInt());
        cpu.setPC(this.buf.getInt());
        cpu.setS(this.buf.getInt());
        cpu.setRegX(this.buf.getInt());
        cpu.setY(this.buf.getInt());
        cpu.bytetoflags(this.buf.getInt());
        cpu.interrupt = this.buf.getInt();
        cpu.interruptDelay = this.buf.getInt() != 0;
        cpu.nmiNext = this.buf.getInt() != 0;
        cpu.clocks = this.buf.getInt();
        cpu.cycles = this.buf.getInt();
    }

    private void saveCpu(CPU cpu) {
        this.buf.putInt(cpu.getA());
        this.buf.putInt(cpu.getPC());
        this.buf.putInt(cpu.getS());
        this.buf.putInt(cpu.getX());
        this.buf.putInt(cpu.getY());
        this.buf.putInt(cpu.flagstobyte());
        this.buf.putInt(cpu.interrupt);
        this.buf.putInt(cpu.interruptDelay ? 1 : 0);
        this.buf.putInt(cpu.nmiNext ? 1 : 0);
        this.buf.putInt(cpu.clocks);
        this.buf.putInt(cpu.cycles);
    }

    private void loadPpu(PPU ppu) {
        int[] ppuReg = ppu.getPpuReg();
        IntStream.range(0, ppuReg.length).forEach(i -> {
            ppuReg[i] = this.buf.getInt();
        });
        ppu.even = this.buf.getInt() != 0;
        ppu.openbus = this.buf.getInt();
        ppu.readbuffer = this.buf.getInt();
        ppu.vblankflag = this.buf.getInt() != 0;
        ppu.loopyX = this.buf.getInt();
        ppu.loopyV = this.buf.getInt();
        int loopyT = this.buf.getInt();
        HalfnesSaveStateHandler.getInt(this.buf, ppu.getOAM());
        HalfnesSaveStateHandler.getInt(this.buf, ppu.getPalette());
        this.loadMapper(ppu.mapper);
        ppu.setParameters();
        ppu.init();
        ppu.loopyT = loopyT;
    }

    private void savePpu(PPU ppu) {
        HalfnesSaveStateHandler.putInt(this.buf, ppu.getPpuReg());
        this.buf.putInt(ppu.even ? 1 : 0);
        this.buf.putInt(ppu.openbus);
        this.buf.putInt(ppu.readbuffer);
        this.buf.putInt(ppu.vblankflag ? 1 : 0);
        this.buf.putInt(ppu.loopyX);
        this.buf.putInt(ppu.loopyV);
        this.buf.putInt(ppu.loopyT);
        HalfnesSaveStateHandler.putInt(this.buf, ppu.getOAM());
        HalfnesSaveStateHandler.putInt(this.buf, ppu.getPalette());
        this.saveMapper(ppu.mapper);
    }

    private void loadMapper(Mapper mapper) {
        mapper.setTVType(this.buf.getInt());
        Mapper.MirrorType type = Mapper.getScrolltype(this.buf.getInt());
        if (mapper.hasPrgRam()) {
            HalfnesSaveStateHandler.getInt(this.buf, mapper.getPRGRam());
        }
        if (mapper.hasChrRam()) {
            HalfnesSaveStateHandler.getInt(this.buf, mapper.getChr());
        }
        HalfnesSaveStateHandler.getInt(this.buf, mapper.getPputN(0));
        HalfnesSaveStateHandler.getInt(this.buf, mapper.getPputN(1));
        HalfnesSaveStateHandler.getInt(this.buf, mapper.getPputN(2));
        HalfnesSaveStateHandler.getInt(this.buf, mapper.getPputN(3));
        if (mapper instanceof MapperHelper.MapperState) {
            MapperHelper.MapperState mapperState = (MapperHelper.MapperState)((Object)mapper);
            mapperState.loadState(this.buf.getInt());
        }
        mapper.setmirroring(type);
    }

    private void saveMapper(Mapper mapper) {
        this.buf.putInt(mapper.getTVType().ordinal());
        this.buf.putInt(mapper.getScrolltype().ordinal());
        if (mapper.hasPrgRam()) {
            HalfnesSaveStateHandler.putInt(this.buf, mapper.getPRGRam());
        }
        if (mapper.hasChrRam()) {
            HalfnesSaveStateHandler.putInt(this.buf, mapper.getChr());
        }
        HalfnesSaveStateHandler.putInt(this.buf, mapper.getPputN(0));
        HalfnesSaveStateHandler.putInt(this.buf, mapper.getPputN(1));
        HalfnesSaveStateHandler.putInt(this.buf, mapper.getPputN(2));
        HalfnesSaveStateHandler.putInt(this.buf, mapper.getPputN(3));
        if (mapper instanceof MapperHelper.MapperState) {
            MapperHelper.MapperState mapperState = (MapperHelper.MapperState)((Object)mapper);
            this.buf.putInt((Integer)mapperState.saveState());
        }
    }

    public void setBuf(ByteBuffer buf) {
        this.buf = buf;
    }

    private void saveRam(CPURAM ram) {
        HalfnesSaveStateHandler.putInt(this.buf, ram.getWram());
    }

    private void loadRam(CPURAM ram) {
        HalfnesSaveStateHandler.getInt(this.buf, ram.getWram());
    }

    private void loadApu(APU cpu) {
    }

    private void saveApu(APU cpu) {
    }

    public static enum Type {
        SAVE,
        LOAD;

    }
}

