/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.ui;

import com.grapeshot.halfnes.PrefsSingleton;
import com.grapeshot.halfnes.ui.ControllerInterface;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.prefs.Preferences;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.Event;
import net.java.games.input.EventQueue;

public class ControllerImpl
implements ControllerInterface,
KeyListener {
    public static boolean JINPUT_ENABLE = Boolean.valueOf(System.getProperty("halfnes.jinput.enable", "true"));
    private static Map<String, String> keyMap = new HashMap<String, String>();
    private Controller gameController;
    private net.java.games.input.Component[] buttons;
    private final ScheduledExecutorService thread = Executors.newSingleThreadScheduledExecutor();
    private int latchbyte = 0;
    private int controllerbyte = 0;
    private int prevbyte = 0;
    private int outbyte = 0;
    private int gamepadbyte = 0;
    private final HashMap<Integer, Integer> m = new HashMap(10);
    private final int controllernum;
    public static boolean verbose;
    double threshold = 0.25;

    public ControllerImpl(int controllernum) {
        this(controllernum, Collections.emptyMap());
    }

    public ControllerImpl(Component parent, int controllernum) {
        this(controllernum, Collections.emptyMap());
        parent.addKeyListener(this);
    }

    public ControllerImpl(int controllernum, Map<String, Integer> pKeyMap) {
        if (controllernum != 0 && controllernum != 1) {
            throw new IllegalArgumentException("controllerNum must be 0 or 1");
        }
        this.controllernum = controllernum;
        this.setKeyMappings(controllernum, pKeyMap);
        this.setButtons();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.pressKey(keyEvent.getKeyCode());
    }

    private void pressKey(int keyCode) {
        this.prevbyte = this.controllerbyte;
        if (!this.m.containsKey(keyCode)) {
            return;
        }
        this.controllerbyte |= this.m.get(keyCode).intValue();
        if ((this.controllerbyte & 0x30) == 48) {
            this.controllerbyte &= 0xFFFFFFCF;
            this.controllerbyte |= this.prevbyte & 0xFFFFFFCF;
        }
        if ((this.controllerbyte & 0xC0) == 192) {
            this.controllerbyte &= 0xFFFFFF3F;
            this.controllerbyte |= this.prevbyte & 0xFFFFFF3F;
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.releaseKey(keyEvent.getKeyCode());
    }

    private void releaseKey(int keyCode) {
        this.prevbyte = this.controllerbyte;
        if (!this.m.containsKey(keyCode)) {
            return;
        }
        this.controllerbyte &= ~this.m.get(keyCode).intValue();
    }

    @Override
    public int getbyte() {
        return this.outbyte;
    }

    @Override
    public int peekOutput() {
        return this.latchbyte;
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void strobe() {
        this.outbyte = this.latchbyte & 1;
        this.latchbyte = this.latchbyte >> 1 | 0x100;
    }

    @Override
    public void output(boolean state) {
        this.latchbyte = this.gamepadbyte | this.controllerbyte;
    }

    public void startEventQueue() {
        this.thread.execute(this.eventQueueLoop());
    }

    private Runnable eventQueueLoop() {
        return new Runnable(){

            @Override
            public void run() {
                if (ControllerImpl.this.gameController != null) {
                    Event event = new Event();
                    while (!Thread.interrupted()) {
                        ControllerImpl.this.gameController.poll();
                        EventQueue queue = ControllerImpl.this.gameController.getEventQueue();
                        while (queue.getNextEvent(event)) {
                            net.java.games.input.Component component = event.getComponent();
                            if (component.getIdentifier() == Component.Identifier.Axis.X) {
                                if ((double)event.getValue() > ControllerImpl.this.threshold) {
                                    ControllerImpl.this.gamepadbyte = ControllerImpl.this.gamepadbyte | 0x80;
                                    ControllerImpl.this.gamepadbyte = ControllerImpl.this.gamepadbyte & 0xFFFFFFBF;
                                    continue;
                                }
                                if ((double)event.getValue() < -ControllerImpl.this.threshold) {
                                    ControllerImpl.this.gamepadbyte = ControllerImpl.this.gamepadbyte | 0x40;
                                    ControllerImpl.this.gamepadbyte = ControllerImpl.this.gamepadbyte & 0xFFFFFF7F;
                                    continue;
                                }
                                ControllerImpl.this.gamepadbyte = ControllerImpl.this.gamepadbyte & 0xFFFFFF3F;
                                continue;
                            }
                            if (component.getIdentifier() == Component.Identifier.Axis.Y) {
                                if ((double)event.getValue() > ControllerImpl.this.threshold) {
                                    ControllerImpl.this.gamepadbyte = ControllerImpl.this.gamepadbyte | 0x20;
                                    ControllerImpl.this.gamepadbyte = ControllerImpl.this.gamepadbyte & 0xFFFFFFEF;
                                    continue;
                                }
                                if ((double)event.getValue() < -ControllerImpl.this.threshold) {
                                    ControllerImpl.this.gamepadbyte = ControllerImpl.this.gamepadbyte | 0x10;
                                    ControllerImpl.this.gamepadbyte = ControllerImpl.this.gamepadbyte & 0xFFFFFFDF;
                                    continue;
                                }
                                ControllerImpl.this.gamepadbyte = ControllerImpl.this.gamepadbyte & 0xFFFFFFCF;
                                continue;
                            }
                            if (component == ControllerImpl.this.buttons[0]) {
                                if (ControllerImpl.this.isPressed(event)) {
                                    ControllerImpl.this.gamepadbyte = ControllerImpl.this.gamepadbyte | 1;
                                    continue;
                                }
                                ControllerImpl.this.gamepadbyte = ControllerImpl.this.gamepadbyte & 0xFFFFFFFE;
                                continue;
                            }
                            if (component == ControllerImpl.this.buttons[1]) {
                                if (ControllerImpl.this.isPressed(event)) {
                                    ControllerImpl.this.gamepadbyte = ControllerImpl.this.gamepadbyte | 2;
                                    continue;
                                }
                                ControllerImpl.this.gamepadbyte = ControllerImpl.this.gamepadbyte & 0xFFFFFFFD;
                                continue;
                            }
                            if (component == ControllerImpl.this.buttons[2]) {
                                if (ControllerImpl.this.isPressed(event)) {
                                    ControllerImpl.this.gamepadbyte = ControllerImpl.this.gamepadbyte | 4;
                                    continue;
                                }
                                ControllerImpl.this.gamepadbyte = ControllerImpl.this.gamepadbyte & 0xFFFFFFFB;
                                continue;
                            }
                            if (component != ControllerImpl.this.buttons[3]) continue;
                            if (ControllerImpl.this.isPressed(event)) {
                                ControllerImpl.this.gamepadbyte = ControllerImpl.this.gamepadbyte | 8;
                                continue;
                            }
                            ControllerImpl.this.gamepadbyte = ControllerImpl.this.gamepadbyte & 0xFFFFFFF7;
                        }
                        try {
                            Thread.sleep(5L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            }
        };
    }

    private boolean isPressed(Event event) {
        net.java.games.input.Component component = event.getComponent();
        if (component.isAnalog()) {
            return Math.abs(event.getValue()) > 0.2f;
        }
        return event.getValue() != 0.0f;
    }

    public void stopEventQueue() {
        this.thread.shutdownNow();
    }

    private static Controller[] getAvailablePadControllers() {
        Controller[] controllers;
        ArrayList<Controller> gameControllers = new ArrayList<Controller>();
        if (!JINPUT_ENABLE) {
            return new Controller[0];
        }
        for (Controller controller : controllers = ControllerEnvironment.getDefaultEnvironment().getControllers()) {
            net.java.games.input.Component[] components;
            if (controller.getType() != Controller.Type.GAMEPAD && controller.getType() != Controller.Type.STICK) continue;
            int nbOfAxis = 0;
            for (net.java.games.input.Component component : components = controller.getComponents()) {
                if (component.getIdentifier() != Component.Identifier.Axis.X && component.getIdentifier() != Component.Identifier.Axis.Y) continue;
                ++nbOfAxis;
            }
            if (nbOfAxis < 2 || ControllerImpl.getButtons(controller).length < 2) continue;
            gameControllers.add(controller);
        }
        return gameControllers.toArray(new Controller[0]);
    }

    private static net.java.games.input.Component[] getButtons(Controller controller) {
        net.java.games.input.Component[] components;
        ArrayList<net.java.games.input.Component> buttons = new ArrayList<net.java.games.input.Component>();
        for (net.java.games.input.Component component : components = controller.getComponents()) {
            if (!(component.getIdentifier() instanceof Component.Identifier.Button)) continue;
            buttons.add(component);
        }
        return buttons.toArray(new net.java.games.input.Component[0]);
    }

    private void setKeyMappings(int pNum, Map<String, Integer> pKeyMap) {
        Preferences prefs = PrefsSingleton.get();
        String tail = "" + (pNum + 1);
        StringBuilder sb = new StringBuilder();
        pKeyMap.entrySet().forEach(e -> {
            String k = keyMap.getOrDefault(e.getKey(), null);
            if (k != null) {
                prefs.putInt(k + tail, (Integer)e.getValue());
                sb.append(k + tail + "->" + KeyEvent.getKeyText((Integer)e.getValue()) + ", ");
            }
        });
        if (verbose) {
            System.out.println("Setting player " + tail + " key mappings: " + sb.toString());
        }
    }

    public final void setButtons() {
        Preferences prefs = PrefsSingleton.get();
        this.m.clear();
        switch (this.controllernum) {
            case 0: {
                this.m.put(prefs.getInt("keyUp1", 38), 16);
                this.m.put(prefs.getInt("keyDown1", 40), 32);
                this.m.put(prefs.getInt("keyLeft1", 37), 64);
                this.m.put(prefs.getInt("keyRight1", 39), 128);
                this.m.put(prefs.getInt("keyA1", 73), 1);
                this.m.put(prefs.getInt("keyB1", 79), 2);
                this.m.put(prefs.getInt("keySelect1", 76), 4);
                this.m.put(prefs.getInt("keyStart1", 10), 8);
                break;
            }
            default: {
                this.m.put(prefs.getInt("keyUp2", 87), 16);
                this.m.put(prefs.getInt("keyDown2", 83), 32);
                this.m.put(prefs.getInt("keyLeft2", 65), 64);
                this.m.put(prefs.getInt("keyRight2", 68), 128);
                this.m.put(prefs.getInt("keyA2", 67), 1);
                this.m.put(prefs.getInt("keyB2", 86), 2);
                this.m.put(prefs.getInt("keySelect2", 78), 4);
                this.m.put(prefs.getInt("keyStart2", 32), 8);
            }
        }
        if (JINPUT_ENABLE) {
            Controller[] controllers = ControllerImpl.getAvailablePadControllers();
            if (controllers.length > this.controllernum) {
                this.gameController = controllers[this.controllernum];
                PrefsSingleton.get().put("controller" + this.controllernum, this.gameController.getName());
                System.err.println(this.controllernum + 1 + ". " + this.gameController.getName());
                this.buttons = ControllerImpl.getButtons(controllers[this.controllernum]);
            } else {
                PrefsSingleton.get().put("controller" + this.controllernum, "");
                this.gameController = null;
                this.buttons = null;
            }
        }
    }

    static {
        keyMap.put("U", "keyUp");
        keyMap.put("D", "keyDown");
        keyMap.put("L", "keyLeft");
        keyMap.put("R", "keyRight");
        keyMap.put("A", "keyA");
        keyMap.put("B", "keyB");
        keyMap.put("M", "keySelect");
        keyMap.put("S", "keyStart");
        verbose = false;
    }
}

