/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.ui;

import com.grapeshot.halfnes.PrefsSingleton;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class ControlsDialog
extends JDialog {
    private int[][] keys;
    private boolean okClicked = false;
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JTextField jField1A;
    private JTextField jField1B;
    private JTextField jField1Down;
    private JTextField jField1Left;
    private JTextField jField1Right;
    private JTextField jField1Select;
    private JTextField jField1Start;
    private JTextField jField1Up;
    private JTextField jField2A;
    private JTextField jField2B;
    private JTextField jField2Down;
    private JTextField jField2Left;
    private JTextField jField2Right;
    private JTextField jField2Select;
    private JTextField jField2Start;
    private JTextField jField2Up;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel16;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelCtrl1;
    private JLabel jLabelCtrl2;

    public ControlsDialog(Frame parent) {
        super(parent, true);
        Preferences prefs = PrefsSingleton.get();
        int[][] keys = new int[][]{{prefs.getInt("keyUp1", 38), prefs.getInt("keyDown1", 40), prefs.getInt("keyLeft1", 37), prefs.getInt("keyRight1", 39), prefs.getInt("keyA1", 88), prefs.getInt("keyB1", 90), prefs.getInt("keySelect1", 16), prefs.getInt("keyStart1", 10)}, {prefs.getInt("keyUp2", 87), prefs.getInt("keyDown2", 83), prefs.getInt("keyLeft2", 65), prefs.getInt("keyRight2", 68), prefs.getInt("keyA2", 71), prefs.getInt("keyB2", 70), prefs.getInt("keySelect2", 82), prefs.getInt("keyStart2", 84)}};
        this.keys = keys;
        this.initComponents();
        this.setTitle("HalfNES Controller Settings");
        this.jField1Up.setText(KeyEvent.getKeyText(keys[0][0]));
        this.jField1Down.setText(KeyEvent.getKeyText(keys[0][1]));
        this.jField1Left.setText(KeyEvent.getKeyText(keys[0][2]));
        this.jField1Right.setText(KeyEvent.getKeyText(keys[0][3]));
        this.jField1A.setText(KeyEvent.getKeyText(keys[0][4]));
        this.jField1B.setText(KeyEvent.getKeyText(keys[0][5]));
        this.jField1Select.setText(KeyEvent.getKeyText(keys[0][6]));
        this.jField1Start.setText(KeyEvent.getKeyText(keys[0][7]));
        this.jField2Up.setText(KeyEvent.getKeyText(keys[1][0]));
        this.jField2Down.setText(KeyEvent.getKeyText(keys[1][1]));
        this.jField2Left.setText(KeyEvent.getKeyText(keys[1][2]));
        this.jField2Right.setText(KeyEvent.getKeyText(keys[1][3]));
        this.jField2A.setText(KeyEvent.getKeyText(keys[1][4]));
        this.jField2B.setText(KeyEvent.getKeyText(keys[1][5]));
        this.jField2Select.setText(KeyEvent.getKeyText(keys[1][6]));
        this.jField2Start.setText(KeyEvent.getKeyText(keys[1][7]));
        String ctrl1 = prefs.get("controller0", "");
        String ctrl2 = prefs.get("controller1", "");
        if (!ctrl1.isEmpty()) {
            this.jLabelCtrl1.setText(ctrl1);
        }
        if (!ctrl2.isEmpty()) {
            this.jLabelCtrl2.setText(ctrl2);
        }
        this.jButtonOK.setActionCommand("OK");
        this.jButtonCancel.setActionCommand("Cancel");
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jField1Up = new JTextField();
        this.jField1Down = new JTextField();
        this.jField1Right = new JTextField();
        this.jField1Left = new JTextField();
        this.jField1Start = new JTextField();
        this.jField1Select = new JTextField();
        this.jField1B = new JTextField();
        this.jField1A = new JTextField();
        this.jField2Up = new JTextField();
        this.jField2Down = new JTextField();
        this.jField2Left = new JTextField();
        this.jField2Right = new JTextField();
        this.jField2A = new JTextField();
        this.jField2B = new JTextField();
        this.jField2Select = new JTextField();
        this.jField2Start = new JTextField();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel16 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabelCtrl1 = new JLabel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jLabelCtrl2 = new JLabel();
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setName("ControlsDialog");
        this.setResizable(false);
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setText("Keybindings:");
        this.jLabel4.setText("Controller 1");
        this.jLabel5.setText("Controller 2");
        this.jLabel6.setText("Up");
        this.jLabel7.setText("Down");
        this.jLabel8.setText("Left");
        this.jLabel9.setText("Right");
        this.jLabel10.setText("A");
        this.jLabel11.setText("B");
        this.jLabel12.setText("Select");
        this.jLabel13.setText("Start");
        this.jField1Up.setMinimumSize(new Dimension(120, 20));
        this.jField1Up.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlsDialog.this.jField2StartActionPerformed(evt);
            }
        });
        this.jField1Up.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ControlsDialog.this.jField1UpKeyReleased(evt);
            }
        });
        this.jField1Down.setMinimumSize(new Dimension(120, 20));
        this.jField1Down.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlsDialog.this.jField2StartActionPerformed(evt);
            }
        });
        this.jField1Down.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ControlsDialog.this.jField1DownKeyReleased(evt);
            }
        });
        this.jField1Right.setMinimumSize(new Dimension(120, 20));
        this.jField1Right.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlsDialog.this.jField2StartActionPerformed(evt);
            }
        });
        this.jField1Right.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ControlsDialog.this.jField1RightKeyReleased(evt);
            }
        });
        this.jField1Left.setMinimumSize(new Dimension(120, 20));
        this.jField1Left.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlsDialog.this.jField2StartActionPerformed(evt);
            }
        });
        this.jField1Left.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ControlsDialog.this.jField1LeftKeyReleased(evt);
            }
        });
        this.jField1Start.setMinimumSize(new Dimension(120, 20));
        this.jField1Start.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ControlsDialog.this.jField1StartKeyReleased(evt);
            }
        });
        this.jField1Select.setMinimumSize(new Dimension(120, 20));
        this.jField1Select.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ControlsDialog.this.jField1SelectKeyReleased(evt);
            }
        });
        this.jField1B.setMinimumSize(new Dimension(120, 20));
        this.jField1B.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ControlsDialog.this.jField1BKeyReleased(evt);
            }
        });
        this.jField1A.setMinimumSize(new Dimension(120, 20));
        this.jField1A.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ControlsDialog.this.jField1AKeyReleased(evt);
            }
        });
        this.jField2Up.setMinimumSize(new Dimension(120, 20));
        this.jField2Up.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ControlsDialog.this.jField2UpKeyReleased(evt);
            }
        });
        this.jField2Down.setMinimumSize(new Dimension(120, 20));
        this.jField2Down.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ControlsDialog.this.jField2DownKeyReleased(evt);
            }
        });
        this.jField2Left.setMinimumSize(new Dimension(120, 20));
        this.jField2Left.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ControlsDialog.this.jField2LeftKeyReleased(evt);
            }
        });
        this.jField2Right.setMinimumSize(new Dimension(120, 20));
        this.jField2Right.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ControlsDialog.this.jField2RightKeyReleased(evt);
            }
        });
        this.jField2A.setMinimumSize(new Dimension(120, 20));
        this.jField2A.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ControlsDialog.this.jField2AKeyReleased(evt);
            }
        });
        this.jField2B.setMinimumSize(new Dimension(120, 20));
        this.jField2B.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ControlsDialog.this.jField2BKeyReleased(evt);
            }
        });
        this.jField2Select.setMinimumSize(new Dimension(120, 20));
        this.jField2Select.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ControlsDialog.this.jField2SelectKeyReleased(evt);
            }
        });
        this.jField2Start.setMinimumSize(new Dimension(120, 20));
        this.jField2Start.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ControlsDialog.this.jField2StartKeyReleased(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlsDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlsDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel16.setText(" Click in text box and type a key to change that binding.");
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Detected Game Controllers:");
        this.jLabelCtrl1.setText("No Player 1 controller connected");
        this.jLabelCtrl1.setEnabled(false);
        this.jButton1.setText("Set Buttons");
        this.jButton1.setEnabled(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlsDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Set Buttons");
        this.jButton2.setEnabled(false);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlsDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jLabelCtrl2.setText("No Player 2 controller connected");
        this.jLabelCtrl2.setEnabled(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel16).addGroup(layout.createSequentialGroup().addGap(49, 49, 49).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel5)).addComponent(this.jLabel3).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel7).addComponent(this.jLabel8).addComponent(this.jLabel9).addComponent(this.jLabel10).addComponent(this.jLabel11).addComponent(this.jLabel13).addComponent(this.jLabel6).addComponent(this.jLabel12)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jField1Right, -2, 60, -2).addComponent(this.jField1Left, -2, 60, -2).addComponent(this.jField1B, -2, 60, -2).addComponent(this.jField1A, -2, 60, -2).addComponent(this.jField1Start, -2, 60, -2).addComponent(this.jField1Select, -2, 60, -2).addComponent(this.jField1Up, -2, 60, -2).addComponent(this.jField1Down, -2, 60, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jField2Select, -2, 60, -2).addComponent(this.jField2B, -2, 60, -2).addComponent(this.jField2Start, -2, 60, -2).addComponent(this.jField2A, -2, 60, -2).addComponent(this.jField2Right, -2, 60, -2).addComponent(this.jField2Up, -2, 60, -2).addComponent(this.jField2Down, -2, 60, -2).addComponent(this.jField2Left, -2, 60, -2))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonOK, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelCtrl1).addComponent(this.jLabelCtrl2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton2).addComponent(this.jButton1)))))));
        layout.linkSize(0, this.jField1A, this.jField1B, this.jField1Down, this.jField1Left, this.jField1Right, this.jField1Select, this.jField1Start, this.jField1Up, this.jField2A, this.jField2B, this.jField2Down, this.jField2Left, this.jField2Right, this.jField2Select, this.jField2Start, this.jField2Up);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel16, -2, 14, -2).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jField2Up, -2, -1, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jField1Up, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jField1Down, -2, -1, -2).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jField1Left, -2, -1, -2).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jField1Right, -2, -1, -2).addComponent(this.jLabel9).addComponent(this.jField2Right, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jField1A, -2, -1, -2).addComponent(this.jLabel10).addComponent(this.jField2A, -2, -1, -2))).addGroup(layout.createSequentialGroup().addGap(31, 31, 31).addComponent(this.jField2Down, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jField2Left, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jField1B, -2, -1, -2).addComponent(this.jLabel11).addComponent(this.jField2B, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jField1Select, -2, -1, -2).addComponent(this.jLabel12).addComponent(this.jField2Select, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jField1Start, -2, -1, -2).addComponent(this.jLabel13).addComponent(this.jField2Start, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelCtrl1).addComponent(this.jButton2)).addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelCtrl2).addComponent(this.jButton1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOK).addComponent(this.jButtonCancel)).addGap(0, 8, Short.MAX_VALUE)));
        layout.linkSize(1, this.jField1A, this.jField1B, this.jField1Down, this.jField1Left, this.jField1Right, this.jField1Select, this.jField1Start, this.jField1Up, this.jField2A, this.jField2B, this.jField2Down, this.jField2Left, this.jField2Right, this.jField2Select, this.jField2Start, this.jField2Up);
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        if ("Cancel".equals(evt.getActionCommand())) {
            this.setVisible(false);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        Preferences prefs = PrefsSingleton.get();
        prefs.putInt("keyUp1", this.keys[0][0]);
        prefs.putInt("keyDown1", this.keys[0][1]);
        prefs.putInt("keyLeft1", this.keys[0][2]);
        prefs.putInt("keyRight1", this.keys[0][3]);
        prefs.putInt("keyA1", this.keys[0][4]);
        prefs.putInt("keyB1", this.keys[0][5]);
        prefs.putInt("keySelect1", this.keys[0][6]);
        prefs.putInt("keyStart1", this.keys[0][7]);
        prefs.putInt("keyUp2", this.keys[1][0]);
        prefs.putInt("keyDown2", this.keys[1][1]);
        prefs.putInt("keyLeft2", this.keys[1][2]);
        prefs.putInt("keyRight2", this.keys[1][3]);
        prefs.putInt("keyA2", this.keys[1][4]);
        prefs.putInt("keyB2", this.keys[1][5]);
        prefs.putInt("keySelect2", this.keys[1][6]);
        prefs.putInt("keyStart2", this.keys[1][7]);
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(ControlsDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.okClicked = true;
        this.setVisible(false);
    }

    public boolean okClicked() {
        return this.okClicked;
    }

    private void jField1UpKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField1Up.setText(KeyEvent.getKeyText(k));
        this.keys[0][0] = k;
    }

    private void jField1DownKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField1Down.setText(KeyEvent.getKeyText(k));
        this.keys[0][1] = k;
    }

    private void jField1LeftKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField1Left.setText(KeyEvent.getKeyText(k));
        this.keys[0][2] = k;
    }

    private void jField1RightKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField1Right.setText(KeyEvent.getKeyText(k));
        this.keys[0][3] = k;
    }

    private void jField2StartActionPerformed(ActionEvent evt) {
    }

    private void jField1AKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField1A.setText(KeyEvent.getKeyText(k));
        this.keys[0][4] = k;
    }

    private void jField1BKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField1B.setText(KeyEvent.getKeyText(k));
        this.keys[0][5] = k;
    }

    private void jField1SelectKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField1Select.setText(KeyEvent.getKeyText(k));
        this.keys[0][6] = k;
    }

    private void jField1StartKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField1Start.setText(KeyEvent.getKeyText(k));
        this.keys[0][7] = k;
    }

    private void jField2UpKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField2Up.setText(KeyEvent.getKeyText(k));
        this.keys[1][0] = k;
    }

    private void jField2StartKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField2Start.setText(KeyEvent.getKeyText(k));
        this.keys[1][7] = k;
    }

    private void jField2DownKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField2Down.setText(KeyEvent.getKeyText(k));
        this.keys[1][1] = k;
    }

    private void jField2LeftKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField2Left.setText(KeyEvent.getKeyText(k));
        this.keys[1][2] = k;
    }

    private void jField2RightKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField2Right.setText(KeyEvent.getKeyText(k));
        this.keys[1][3] = k;
    }

    private void jField2AKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField2A.setText(KeyEvent.getKeyText(k));
        this.keys[1][4] = k;
    }

    private void jField2BKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField2B.setText(KeyEvent.getKeyText(k));
        this.keys[1][5] = k;
    }

    private void jField2SelectKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField2Select.setText(KeyEvent.getKeyText(k));
        this.keys[1][6] = k;
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
    }
}

