/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.ui;

import com.grapeshot.halfnes.NES;
import com.grapeshot.halfnes.PrefsSingleton;
import com.grapeshot.halfnes.ui.FrameLimiterInterface;
import java.util.concurrent.locks.LockSupport;

public class FrameLimiterImpl
implements FrameLimiterInterface {
    NES nes;
    private long sleepingtest = 0L;
    public long FRAME_NS;

    public FrameLimiterImpl(NES nes, long framens) {
        this.nes = nes;
        this.FRAME_NS = framens;
    }

    @Override
    public void setInterval(long ns) {
        this.FRAME_NS = ns;
    }

    @Override
    public void sleep() {
        if (!PrefsSingleton.get().getBoolean("Sleep", true)) {
            return;
        }
        long timeleft = System.nanoTime() - this.nes.frameStartTime;
        if (timeleft < this.FRAME_NS) {
            long sleepNs = this.FRAME_NS - timeleft + this.sleepingtest;
            if (sleepNs < 0L) {
                return;
            }
            this.sleepingtest = System.nanoTime();
            LockSupport.parkNanos(sleepNs);
            this.sleepingtest = System.nanoTime() - this.sleepingtest;
            this.sleepingtest = sleepNs - this.sleepingtest;
        }
    }

    @Override
    public void sleepFixed() {
        try {
            Thread.sleep(16L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void forceHighResolutionTimer() {
        Thread daemon = new Thread("ForceHighResolutionTimer"){

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(99999999999L);
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        };
        daemon.setDaemon(true);
        daemon.start();
    }
}

