/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.ui;

import com.grapeshot.halfnes.audio.AudioOutInterface;
import com.grapeshot.halfnes.ui.DebugUI;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class Oscilloscope
implements AudioOutInterface {
    private static final int width = 400;
    private static final int length = 640;
    private static final int scf = 81;
    DebugUI d;
    BufferedImage b;
    Graphics2D g;
    AudioOutInterface iface;
    int[] buffer = new int[640];
    int buf_ptr = 0;
    int prevsample = 0;

    public Oscilloscope(AudioOutInterface i) {
        this.iface = i;
        this.d = new DebugUI(640, 400);
        this.b = new BufferedImage(640, 400, 3);
        this.g = this.b.createGraphics();
        this.g.setBackground(Color.black);
        this.g.setColor(Color.green);
        this.d.pack();
        this.d.run();
    }

    public Oscilloscope() {
        this.iface = null;
        this.d = new DebugUI(640, 400);
        this.b = new BufferedImage(640, 400, 3);
        this.g = this.b.createGraphics();
        this.g.setBackground(Color.black);
        this.g.setColor(Color.red);
        this.d.pack();
        this.d.run();
    }

    @Override
    public void outputSample(int sample) {
        if ((this.buf_ptr > 0 || this.prevsample <= 0 && sample >= 0) && this.buf_ptr < this.buffer.length) {
            this.buffer[this.buf_ptr++] = sample;
        }
        this.prevsample = sample;
        if (this.iface != null) {
            this.iface.outputSample(sample);
        }
    }

    @Override
    public void flushFrame(boolean waitIfBufferFull) {
        if (this.iface != null) {
            this.iface.flushFrame(waitIfBufferFull);
        }
        this.g.clearRect(0, 0, 640, 400);
        for (int i = 1; i < this.buf_ptr; ++i) {
            this.g.drawLine(i - 1, this.buffer[i - 1] / 81 + 200, i, this.buffer[i] / 81 + 200);
        }
        this.g.drawLine(0, 200, 640, 200);
        this.d.setFrame(this.b);
        this.buf_ptr = 0;
    }

    @Override
    public void pause() {
        if (this.iface != null) {
            this.iface.pause();
        }
    }

    @Override
    public void resume() {
        if (this.iface != null) {
            this.iface.resume();
        }
    }

    @Override
    public void destroy() {
        this.d.setVisible(false);
        this.d.dispose();
        if (this.iface != null) {
            this.iface.destroy();
        }
    }

    @Override
    public boolean bufferHasLessThan(int samples) {
        if (this.iface != null) {
            return this.iface.bufferHasLessThan(samples);
        }
        return false;
    }
}

