/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.video;

import com.grapeshot.halfnes.video.Renderer;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.zip.CRC32;

public class NTSCRenderer
extends Renderer {
    private static final List<Integer> lines = new ArrayList<Integer>();
    private static final int[][] colorphases;
    private static final float[][][] lumas;
    private static final int[][] coloremph;
    private int frames = 0;
    private final float[] i_filter = new float[12];
    private final float[] q_filter = new float[12];
    private static final int[] colortbl;
    public static final float chroma_filterfreq = 3579000.0f;
    public static final float pixel_rate = 4.295E7f;
    private static final int[] cbstphase;
    private static final int[][] iqm;
    public static final int frame_w = 2112;
    int[] frame = new int[506880];
    Map<Long, int[]> cache = Collections.synchronizedMap(new WeakHashMap(600));

    public NTSCRenderer() {
        this.frame_width = 2112;
        this.init_images();
        int hue = -512;
        double col_adjust = 1.6973125884016973;
        for (int j = 0; j < 12; ++j) {
            float angle = (float)(Math.PI * ((double)(hue + (j << 8)) / 1536.0 - 0.18333333333333332));
            this.i_filter[j] = (float)(-col_adjust * Math.cos(angle));
            this.q_filter[j] = (float)(col_adjust * Math.sin(angle));
        }
    }

    public static int[] genColorCorrectTbl() {
        int[] corr = new int[256];
        float brightness = 20.0f;
        float contrast = 1.0f;
        for (int i = 0; i < 256; ++i) {
            float br = ((float)i * contrast - 128.0f * contrast + 128.0f + brightness) / 255.0f;
            corr[i] = NTSCRenderer.clamp((int)(255.0 * Math.pow(br, 1.3)));
        }
        return corr;
    }

    public static float[][][] genlumas() {
        float[][] lumas = new float[][]{{-0.117f, 0.0f, 0.308f, 0.715f}, {0.397f, 0.681f, 1.0f, 1.0f}};
        float[][][] premultlumas = new float[lumas.length][lumas[0].length][2];
        for (int i = 0; i < lumas.length; ++i) {
            for (int j = 0; j < lumas[i].length; ++j) {
                premultlumas[i][j][0] = lumas[i][j];
                premultlumas[i][j][1] = lumas[i][j] * 0.735f;
            }
        }
        return premultlumas;
    }

    public final float[] ntsc_encode(int[] nescolors, int offset, int scanline, int bgcolor) {
        int hue;
        int phase;
        int i;
        int col = bgcolor & 0xF;
        int lum = bgcolor >> 4 & 3;
        int emphasis = bgcolor >> 6;
        float[] sample = new float[2488];
        for (i = 160; i < 280; ++i) {
            phase = (i + offset) % 12;
            hue = colorphases[col][phase];
            sample[i] = lumas[hue][lum][coloremph[emphasis][phase]];
        }
        for (i = 2328; i < 2416; ++i) {
            phase = (i + offset) % 12;
            hue = colorphases[col][phase];
            sample[i] = lumas[hue][lum][coloremph[emphasis][phase]];
        }
        for (i = 280; i < 2328; ++i) {
            if ((i & 7) == 0) {
                col = nescolors[i - 280 >> 3];
                if ((col & 0xF) > 13) {
                    col = 15;
                }
                lum = col >> 4 & 3;
                emphasis = col >> 6;
                col &= 0xF;
            }
            phase = (i + offset) % 12;
            hue = colorphases[col][phase];
            sample[i] = lumas[hue][lum][coloremph[emphasis][phase]];
        }
        sample[2487] = offset;
        return sample;
    }

    public final int[] ntsc_decode(float[] ntsc, int offset) {
        float[] chroma = new float[2416];
        float[] luma = new float[2416];
        float[] eye = new float[2416];
        float[] queue = new float[2416];
        int[] line = new int[2112];
        NTSCRenderer.box_filter(ntsc, luma, chroma, 12);
        int cbst = cbstphase[offset];
        int j = 0;
        while (cbst < 2366) {
            eye[cbst] = this.i_filter[j] * chroma[cbst + 12];
            queue[cbst] = this.q_filter[j] * chroma[cbst + 12];
            ++cbst;
            ++j;
            j %= 12;
        }
        NTSCRenderer.lowpass_filter(eye, 0.06f);
        NTSCRenderer.lowpass_filter(queue, 0.05f);
        int i = 0;
        int x = 252;
        while (i < 2112) {
            line[i] = NTSCRenderer.compose_col(luma[x] <= 0.0f ? 0 : colortbl[NTSCRenderer.clamp((int)((float)iqm[0][0] * luma[x] + (float)iqm[0][1] * eye[x] + (float)iqm[0][2] * queue[x]))], luma[x] <= 0.0f ? 0 : colortbl[NTSCRenderer.clamp((int)((float)iqm[1][0] * luma[x] + (float)iqm[1][1] * eye[x] + (float)iqm[1][2] * queue[x]))], luma[x] <= 0.0f ? 0 : colortbl[NTSCRenderer.clamp((int)((float)iqm[2][0] * luma[x] + (float)iqm[2][1] * eye[x] + (float)iqm[2][2] * queue[x]))]);
            ++i;
            ++x;
        }
        return line;
    }

    public static void box_filter(float[] in, float[] lpout, float[] hpout, int order) {
        float accum = 0.0f;
        for (int i = 12; i < 2416; ++i) {
            lpout[i] = (accum += in[i] - in[i - order]) / (float)order;
            hpout[i] = in[i] - lpout[i];
        }
    }

    public static void lowpass_filter(float[] arr, float order) {
        float b = 0.0f;
        for (int i = 0; i < 2416; ++i) {
            int n = i;
            arr[n] = arr[n] - b;
            arr[i] = b += arr[i] * order;
        }
    }

    private static int compose_col(int r, int g, int b) {
        return r << 16 | g << 8 | b | 0xFF000000;
    }

    public static int clamp(int a) {
        return a != (a & 0xFF) ? (a < 0 ? 0 : 255) : a;
    }

    @Override
    public BufferedImage render(int[] nespixels, int[] bgcolors, boolean dotcrawl) {
        lines.parallelStream().forEach(line -> this.cacheRender(nespixels, (int)line, bgcolors, dotcrawl));
        BufferedImage i = this.getBufferedImage(this.frame);
        ++this.frames;
        return i;
    }

    private void cacheRender(int[] nespixels, int line, int[] bgcolors, boolean dotcrawl) {
        int offset = (this.frames & 1) == 0 && dotcrawl ? 0 : 6;
        offset = (4 * line + offset) % 12;
        int[] inpixels = new int[256];
        System.arraycopy(nespixels, line << 8, inpixels, 0, 256);
        long crc = NTSCRenderer.crc32(inpixels, offset, bgcolors[line]);
        int[] outpixels = this.cache.get(crc);
        if (outpixels == null) {
            outpixels = this.ntsc_decode(this.ntsc_encode(inpixels, offset, line, bgcolors[line]), offset);
            this.cache.put(crc, outpixels);
        }
        System.arraycopy(outpixels, 0, this.frame, line * 2112, 2112);
    }

    public static long crc32(int[] array, int offset, int bgcolor) {
        CRC32 c = new CRC32();
        for (int i : array) {
            c.update(i);
        }
        c.update(offset);
        c.update(bgcolor);
        return c.getValue();
    }

    static {
        for (int line = 0; line < 240; ++line) {
            lines.add(line);
        }
        colorphases = new int[][]{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0}, {0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0}, {0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1}, {1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1}, {1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1}, {1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1}, {1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        lumas = NTSCRenderer.genlumas();
        coloremph = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0}, {1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1}, {1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}};
        colortbl = NTSCRenderer.genColorCorrectTbl();
        cbstphase = new int[]{0, 0, 10, 0, 8, 0, 6, 0, 4, 0, 2, 0};
        iqm = new int[][]{{255, -244, 158}, {255, 69, -165}, {255, 282, 434}};
    }
}

